########################################
# Elf32_Ehdr or Elf64_Ehdr #############
########################################
.globl ehdr
ehdr:
  # e_ident[EI_MAG0], magic value 0x7F
  .byte 0x7f
  # e_ident[EI_MAG1] to e_indent[EI_MAG3], magic value "ELF"
  .ascii "ELF"
  # e_ident[EI_CLASS], ELFCLASS32 = 1, ELFCLASS64 = 2
  .byte 0x1
  # e_ident[EI_DATA], ELFDATA2LSB = 1, ELFDATA2MSB = 2
  .byte 0x1
  # e_ident[EI_VERSION], EV_CURRENT = 1
  .byte 0x1
  # e_ident[EI_OSABI], ELFOSABI_SYSV = 0, ELFOSABI_LINUX = 3, ELFOSABI_FREEBSD = 9
  .byte 0x0
  # e_ident[EI_ABIVERSION], always 0
  .byte 0x0
  # e_indent[EI_MAG10 to EI_MAG15], unused
  .byte 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
  # e_type, ET_EXEC = 2
  .short 0x2
  # e_machine, EM_386 = 3, EM_ARM = 40, EM_X86_64 = 62, EM_AARCH64 = 183
  .short 0x3
  # e_version, EV_CURRENT = 1
  .long 0x1
  # e_entry, execution starting point
  .long _start
  # e_phoff, offset from start to program headers
  .long phdr_load - ehdr
  # e_shoff, start of section headers
  .long 0x0
  # e_flags, unused
  .long 0x0
  # e_ehsize, Elf32_Ehdr size
  .short ehdr_end - ehdr
  # e_phentsize, Elf32_Phdr size
  .short phdr_load_end - phdr_load
  # e_phnum, Elf32_Phdr count, PT_LOAD, [PT_LOAD (bss)], PT_INTERP, PT_DYNAMIC
  .byte 0x3
  .byte 0x0
.globl phdr_load
phdr_load:
  # e_shentsize, Elf32_Shdr size
  # p_type, PT_LOAD = 1
  .byte 0x1
  .byte 0x0
  # e_shnum, Elf32_Shdr count
  .byte 0x0
  .byte 0x0
  # e_shstrndx, index of section containing string table of section header names
  # p_offset, offset of program start
  .byte 0x0
  .byte 0x0
.globl ehdr_end
ehdr_end:
########################################
# Elf32_Phdr, PT_LOAD ##################
########################################
  .byte 0x0
  .byte 0x0
  # p_vaddr, program virtual address
  .byte 0x0
  .byte 0x0
  .byte 0x0
  .byte 0x2
  # p_paddr, unused
  .byte 0x0
  .byte 0x0
  .byte 0x0
  .byte 0x0
  # p_filesz, program size on disk
  .long end - ehdr
  # p_memsz, program size in memory
  .long bss_end - ehdr
  # p_flags, rwx = 7
  .long 0x7
  # p_align, usually 0x1000
  .long 0x1000
.globl phdr_load_end
phdr_load_end:
########################################
# Elf32_Phdr, PT_INTERP ################
########################################
.globl phdr_interp
phdr_interp:
  # p_type, PT_INTERP = 3
  .long 0x3
  # p_offset, offset of block
  .long interp - ehdr
  # p_vaddr, address of block
  .long interp
  # p_paddr, unused
  .long 0x0
  # p_filesz, block size on disk
  .long interp_end - interp
  # p_memsz, block size in memory
  .long interp_end - interp
  # p_flags, ignored
  .long 0x0
  # p_align, 1 for strtab
  .long 0x1
.globl phdr_interp_end
phdr_interp_end:
########################################
# Elf32_Phdr, PT_DYNAMIC ###############
########################################
.globl phdr_dynamic
phdr_dynamic:
  # p_type, PT_DYNAMIC = 2
  .long 0x2
  # p_offset, offset of block
  .long dynamic - ehdr
  # p_vaddr, address of block
  .long dynamic
  # p_paddr, unused
  .long 0x0
  # p_filesz, block size on disk
  .long dynamic_end - dynamic
  # p_memsz, block size in memory
  .long dynamic_end - dynamic
.globl dynamic
dynamic:
  # p_flags, ignored
  # d_tag, DT_DEBUG = 21
  .byte 0x15
  .byte 0x0
  .byte 0x0
  .byte 0x0
.globl dynamic_r_debug
dynamic_r_debug:
  # p_align, ignored
  # d_un
  .byte 0x0
  .byte 0x0
  .byte 0x0
  .byte 0x0
.globl phdr_dynamic_end
phdr_dynamic_end:
########################################
# PT_DYNAMIC ###########################
########################################
  # d_tag, DT_NEEDED = 1
  .byte 0x1
  .byte 0x0
  .byte 0x0
  .byte 0x0
  # d_un, library name offset in strtab
  .long strtab_libsndfile_so - strtab
  # d_tag, DT_SYMTAB = 6
  .long 0x6
  # d_un
  .long 0x0
  # d_tag, DT_STRTAB = 5
  .long 0x5
  # d_un
  .long strtab
  # d_tag, DT_NULL = 0
  .long 0x0
  # d_un
  .long 0x0
.globl dynamic_end
dynamic_end:
########################################
# PT_INTERP ############################
########################################
.globl interp
interp:
  # path to interpreter
  .ascii "/lib/ld-linux.so.2"
.globl strtab
strtab:
  # interpreter terminating zero
  # initial zero
  .byte 0x0
.globl interp_end
interp_end:
########################################
# DT_STRTAB ############################
########################################
.globl strtab_libsndfile_so
strtab_libsndfile_so:
  # symbol name string
  .ascii "libsndfile.so"
  # string terminating zero
  .byte 0x0
.globl strtab_end
strtab_end:
########################################
# sections 'None' ######################
########################################
	.balign 1
.LC0:
	.string	"olkiluoto_3-2-1.wav"
	.balign 1
	.type	_ZL14g_symbol_table, @object
	.size	_ZL14g_symbol_table, 12
_ZL14g_symbol_table:
	.long	1918442466
	.long	-2129151572
	.long	-1507841914
	.ident	"GCC: (Ubuntu 11.4.0-1ubuntu1~22.04) 11.4.0"
	.balign 1
instr_addr:
.byte 0,0,0,0
	.balign 1
.equ OFF, 0
.equ Cs0, 1
.equ D0, 2
.equ Ds0, 3
.equ E0, 4
.equ F0, 5
.equ Fs0, 6
.equ G0, 7
.equ Gs0, 8
.equ A0, 9
.equ As0, 10
.equ B0, 11
.equ C1, 16
.equ Cs1, 17
.equ D1, 18
.equ Ds1, 19
.equ E1, 20
.equ F1, 21
.equ Fs1, 22
.equ G1, 23
.equ Gs1, 24
.equ A1, 25
.equ As1, 26
.equ B1, 27
.equ C2, 32
.equ Cs2, 33
.equ D2, 34
.equ Ds2, 35
.equ E2, 36
.equ F2, 37
.equ Fs2, 38
.equ G2, 39
.equ Gs2, 40
.equ A2, 41
.equ As2, 42
.equ B2, 43
.equ C3, 48
.equ Cs3, 49
.equ D3, 50
.equ Ds3, 51
.equ E3, 52
.equ F3, 53
.equ Fs3, 54
.equ G3, 55
.equ Gs3, 56
.equ A3, 57
.equ As3, 58
.equ B3, 59
.equ C4, 64
.equ Cs4, 65
.equ D4, 66
.equ Ds4, 67
.equ E4, 68
.equ F4, 69
.equ Fs4, 70
.equ G4, 71
.equ Gs4, 72
.equ A4, 73
.equ As4, 74
.equ B4, 75
.equ C5, 80
.equ Cs5, 81
.equ D5, 82
.equ Ds5, 83
.equ E5, 84
.equ F5, 85
.equ Fs5, 86
.equ G5, 87
.equ Gs5, 88
.equ A5, 89
.equ As5, 90
.equ B5, 91
.equ END_SONG, 255
.equ BD, 1
.equ SD, 2
osc_semitones:
.byte 12,0,0,0
song:
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 1
.byte 1
.byte 1
.byte 14
.byte 1
.byte 12
.byte 13
.byte 1
.byte 6
.byte 6
.byte 6
.byte 6
.byte 6
.byte 6
.byte 6
.byte 6
.byte 6
.byte 6
.byte 6
.byte 6
.byte 255
song2:
.byte 0
.byte 0
.byte 0
.byte 0
.byte 2
.byte 0
.byte 0
.byte 0
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 2
.byte 255
song3:
.byte 7
.byte 7
.byte 9
.byte 10
.byte 7
.byte 7
.byte 10
.byte 9
.byte 7
.byte 7
.byte 9
.byte 7
.byte 9
.byte 10
.byte 10
.byte 7
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 7
.byte 7
.byte 7
.byte 7
.byte 7
.byte 7
.byte 7
.byte 7
.byte 7
.byte 7
.byte 7
.byte 7
.byte 255
song4:
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 255
drum_song:
.byte 0
.byte 0
.byte 0
.byte 0
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 0
.byte 0
.byte 0
.byte 0
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 255
sequences:
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 32
.byte 32
.byte 0
.byte 26
.byte 0
.byte 32
.byte 32
.byte 0
.byte 0
.byte 0
.byte 0
.byte 58
.byte 64
.byte 0
.byte 70
.byte 65
.byte 0
.byte 0
.byte 0
.byte 0
.byte 80
.byte 0
.byte 0
.byte 81
.byte 0
.byte 0
.byte 80
.byte 0
.byte 0
.byte 75
.byte 0
.byte 0
.byte 1
.byte 0
.byte 0
.byte 0
.byte 2
.byte 0
.byte 1
.byte 0
.byte 1
.byte 0
.byte 0
.byte 0
.byte 2
.byte 0
.byte 1
.byte 0
.byte 1
.byte 0
.byte 0
.byte 0
.byte 2
.byte 0
.byte 1
.byte 0
.byte 1
.byte 0
.byte 0
.byte 0
.byte 2
.byte 0
.byte 1
.byte 0
.byte 1
.byte 0
.byte 0
.byte 1
.byte 2
.byte 0
.byte 1
.byte 0
.byte 0
.byte 0
.byte 1
.byte 0
.byte 2
.byte 0
.byte 0
.byte 0
.byte 37
.byte 37
.byte 0
.byte 35
.byte 0
.byte 37
.byte 37
.byte 0
.byte 0
.byte 53
.byte 0
.byte 64
.byte 0
.byte 67
.byte 69
.byte 70
.byte 16
.byte 16
.byte 16
.byte 0
.byte 16
.byte 0
.byte 0
.byte 0
.byte 0
.byte 16
.byte 16
.byte 0
.byte 16
.byte 0
.byte 0
.byte 0
.byte 21
.byte 21
.byte 21
.byte 0
.byte 21
.byte 0
.byte 0
.byte 0
.byte 0
.byte 21
.byte 21
.byte 0
.byte 21
.byte 0
.byte 0
.byte 0
.byte 16
.byte 16
.byte 16
.byte 0
.byte 16
.byte 0
.byte 0
.byte 0
.byte 0
.byte 16
.byte 16
.byte 0
.byte 16
.byte 17
.byte 0
.byte 17
.byte 10
.byte 10
.byte 10
.byte 0
.byte 10
.byte 0
.byte 0
.byte 0
.byte 0
.byte 10
.byte 10
.byte 0
.byte 10
.byte 17
.byte 0
.byte 17
.byte 0
.byte 80
.byte 0
.byte 0
.byte 80
.byte 0
.byte 0
.byte 80
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 48
.byte 42
.byte 0
.byte 42
.byte 0
.byte 26
.byte 26
.byte 0
.byte 0
.byte 0
.byte 0
.byte 58
.byte 64
.byte 0
.byte 68
.byte 69
.byte 26
.byte 26
.byte 0
.byte 26
.byte 0
.byte 26
.byte 42
.byte 0
.byte 26
.byte 0
.byte 0
.byte 58
.byte 64
.byte 0
.byte 69
.byte 64
.byte 32
.byte 32
.byte 0
.byte 26
.byte 0
.byte 32
.byte 32
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 65
	.balign 1
drum_magic:
.byte 0,249,34,71
drum_vol:
.byte 0,183,81,57
drum_vol_2:
small:
.byte 0,83,201,54
	.balign 1
fm_decay:
.byte 0,51,115,63
portamento_a:
.byte 0,183,209,57
portamento_b:
.byte 0,229,127,63
rev_amp:
.byte 0,153,25,63
base_freq:
.byte 0,251,46,59
rev_x:
.byte 0,204,204,62
fm_instruments:
fm_op_freqs:
.byte 0,0,128,63
.byte 0,0,128,63
.byte 0,0,0,64
fm_mod_amps:
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,204,204,61
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,204,76,62
.byte 0,204,76,62
.byte 0,204,204,61
volume:
.byte 0,153,25,62
fm_op_freqs2:
.byte 0,0,0,64
.byte 0,0,160,64
.byte 0,0,0,64
fm_mod_amps2:
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,153,25,62
.byte 0,204,76,61
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,153,25,62
.byte 0,0,0,0
volume2:
.byte 0,194,245,61
fm_op_freqs3:
.byte 0,0,128,64
.byte 0,0,64,64
.byte 0,0,128,63
fm_mod_amps3:
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,215,35,60
.byte 0,204,76,61
.byte 0,0,0,0
volume3:
.byte 0,204,76,62
fm_op_freqs4:
.byte 0,71,129,63
.byte 0,225,250,62
.byte 0,0,0,63
fm_mod_amps4:
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,194,245,61
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,194,245,61
.byte 0,153,25,62
.byte 0,153,153,62
volume4:
.byte 0,153,25,62
fm_op_freqs_drum:
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
fm_mod_amps_drum:
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
rev_filter_a:
.byte 0,204,204,61
rev_filter_b:
.byte 0,102,102,63
	.file	"synth-test.cpp"
	.globl	_start
	.type	_start, @function
_start:
	subl	$52, %esp
	xorl	%ebx, %ebx
.L12:
	movl	_ZL14g_symbol_table(,%ebx,4), %eax
	movl	%eax, 4(%esp)
	movl	dynamic_r_debug, %eax
	movl	4(%eax), %esi
.L15:
	movl	12(%esi), %esi
	movl	8(%esi), %edx
.L2:
	addl	$8, %edx
	cmpl	$5, (%edx)
	jne	.L2
	movl	4(%edx), %eax
	movl	%eax, (%esp)
	movl	(%esi), %eax
	cmpl	%eax, (%esp)
	jnb	.L3
	addl	%eax, (%esp)
.L3:
	movl	12(%edx), %edx
	cmpl	%edx, %eax
	jbe	.L5
	addl	%eax, %edx
	jmp	.L5
.L6:
	crc32b	%cl, %edi
.L9:
	incl	%ebp
	movb	-1(%ebp), %cl
	testb	%cl, %cl
	jne	.L6
	cmpl	%edi, 4(%esp)
	je	.L22
	addl	$16, %edx
.L5:
	cmpl	(%esp), %edx
	jnb	.L15
	movl	(%esp), %ecx
	addl	(%edx), %ecx
	movl	%ecx, %ebp
	xorl	%edi, %edi
	jmp	.L9
.L22:
	addl	4(%edx), %eax
	movb	12(%edx), %dl
	andl	$15, %edx
	cmpb	$10, %dl
	jne	.L11
	call	*%eax
.L11:
	movl	%eax, _ZL14g_symbol_table(,%ebx,4)
	incl	%ebx
	cmpl	$3, %ebx
	jne	.L12
	movl	$_ZL16g_scratch_buffer, %eax
	call	synth
	movl	$44100, 16(%esp)
	movl	$2, 20(%esp)
	movl	$65542, 24(%esp)
	leal	8(%esp), %eax
	pushl	%eax
	pushl	$32
	pushl	$.LC0
	call	*_ZL14g_symbol_table+4
	movl	%eax, %ebx
	pushl	$0
	pushl	$4806900
	pushl	$_ZL16g_scratch_buffer+19404000
	pushl	%eax
	call	*_ZL14g_symbol_table+8
	pushl	%ebx
	call	*_ZL14g_symbol_table
#APP
# 94 "src/dnload.h" 1
	int $0x3
.global synth
.equ REV_LEN, 24000
.equ FM_INSTR_SIZE, 48
.equ TICKLEN, 7000
.equ TICKLEN_B, 28000
synth:
pusha
movl %eax,%edi
pushl %edi
pushl %edi
movl $110*44100,%ecx
xorl %eax,%eax
rep
stosl
popl %edi
movl $fm_op_freqs, %eax
movl %eax,instr_addr
pushl %edi
movl $song, %ebp
call seq
popl %edi
movl $fm_op_freqs2, %eax
movl %eax,instr_addr
pushl %edi
movl $song2, %ebp
call seq
popl %edi
movl $fm_op_freqs3, %eax
movl %eax,instr_addr
pushl %edi
movl $song3, %ebp
call seq
popl %edi
movl $fm_op_freqs4, %eax
movl %eax,instr_addr
pushl %edi
movl $song4, %ebp
call seq
popl %edi
movl $fm_op_freqs_drum, %eax
movl %eax,instr_addr
pushl %edi
movl $drum_song, %ebp
call seq
popl %edi
synth.do_reverb:
popl %esi
movl %esi,%edi
addl $4*110*44100,%edi
movl $110*44100,%ecx
call reverb
popa
ret
seq:
xorl %edx,%edx
seq.seq_loop:
testl %edx,%edx
jnz seq.no_advance_order
xorl %eax,%eax
movb (%ebp),%al
incl %ebp
cmpb $-1,%al
je seq.out
imull $16,%eax,%esi
movl $16,%edx
seq.no_advance_order:
xorl %eax,%eax
movb sequences(%esi),%al
movl %eax,current_note
movb %al,%cl
shrb $4,%cl
andb $0x0f,%al
pushl %eax
fildl (%esp)
popl %eax
fidivl osc_semitones
f2xm1
fld1
faddp
movl $1,%ebx
shl %cl,%ebx
pushl %ebx
fimull (%esp)
popl %ebx
fmuls base_freq
movl $TICKLEN, %ecx
pusha
movl instr_addr,%ebp
testl $0xffffffff,(%ebp)
jz seq.is_drum
call fm
jmp seq.not_drum
seq.is_drum:
call drum
seq.not_drum:
popa
fstp %st
addl $TICKLEN_B, %edi
incl %esi
decl %edx
jmp seq.seq_loop
seq.out:
ret
fm:
fm.output_loop:
pushl %ecx
movl $fm_ctrs, %ebx
xorl %eax,%eax
movl $3,%ecx
fm.fm_osc_loop:
pushl %ecx
fld %st
fmuls portamento_a
flds 12(%ebx,%eax)
fmuls portamento_b
faddp
movl current_note,%ecx
cmpl $0,%ecx
je fm.no_porta
fsts 12(%ebx,%eax)
fld1
fstps fm_volume
jmp fm.yes_porta
fm.no_porta:
flds fm_volume
fmuls fm_decay
fadds small
fstps fm_volume
fm.yes_porta:
fldz
xorl %esi,%esi
movl $3,%ecx
fm.fm_mod_sum_loop:
pushl %ecx
pushl %eax
flds 24(%esi,%ebx)
imull $3,%eax,%eax
addl %esi,%eax
fmuls 12(%ebp,%eax)
faddp %st(1)
popl %eax
addl $4,%esi
popl %ecx
loop fm.fm_mod_sum_loop
flds (%ebx,%eax)
flds (%ebp,%eax)
fmul %st(3)
faddp
faddp
fldpi
fadd %st
fxch %st(1)
fprem1
fsts (%ebx,%eax)
fsin
fm.no_wrap:
fstps fm_outs(%eax)
addl $4,%eax
fstp %st
fstp %st
popl %ecx
decl %ecx
jnz fm.fm_osc_loop
flds last_osc
fmuls 48(%ebp)
fmuls fm_volume
fadds (%edi)
fstps (%edi)
addl $4,%edi
popl %ecx
decl %ecx
jnz fm.output_loop
ret
drum:
cmpb $1,%al
je drum.bd
cmpb $2,%al
je drum.sd
addl $TICKLEN_B, %edi
ret
drum.bd:
movl $2200,%ecx
xorl %eax,%eax
drum.bd_loop:
addl %ecx,%eax
andl $0x000fffff,%eax
pushl %eax
fildl (%esp)
popl %eax
fdivs drum_magic
fsin
pushl %ecx
fimull (%esp)
popl %ecx
fmuls drum_vol
flds (%edi)
faddp
fstps (%edi)
addl $4,%edi
loop drum.bd_loop
ret
drum.sd:
movl $1500,%ecx
movl %ecx,%eax
drum.sd_loop:
testl $0x80,%ecx
jnz drum.break
addl $12345,%eax
imull $12345,%eax
pushl %eax
filds (%esp)
popl %eax
fmuls drum_vol_2
fadds (%edi)
fstps (%edi)
drum.break:
addl $4,%edi
loop drum.sd_loop
ret
reverb:
reverb.reverb_loop:
pushl %ecx
flds (%esi)
fmuls rev_filter_a
flds rev_filter_state
fmuls rev_filter_b
faddp
fsts rev_filter_state
movl rev_buf_pos,%ebx
fadds rev_buf(%ebx)
fmuls rev_x
reverb.b:
fstps rev_buf(%ebx)
subl $4,%ebx
jns reverb.no_wrap
addl $REV_LEN, %ebx
reverb.no_wrap:
movl %ebx,rev_buf_pos
movl $2,%ecx
reverb.reverb_ch_loop:
pushl %ecx
fldz
movl $24,%ecx
reverb.reverb_accum_loop:
imull $128,%ecx,%eax
addl %eax,%ebx
subl $4777*4,%ebx
jns reverb.no_wrap2
addl $REV_LEN, %ebx
reverb.no_wrap2:
fadds rev_buf(%ebx)
fchs
loop reverb.reverb_accum_loop
fmuls rev_amp
fadds (%esi)
fsts (%edi)
addl $4,%edi
fstp %st
popl %ecx
loop reverb.reverb_ch_loop
addl $4,%esi
popl %ecx
decl %ecx
jnz reverb.reverb_loop
ret
current_note:
.byte 0,0,0,0
fm_volume:
.space 1*4
fm_ctrs:
.space 3*4
osc_freqs:
.space 3*4
fm_outs:
.space 2*4
last_osc:
.space 1*4
rev_filter_state:
.space 1*4
rev_buf_pos:
.space 1*4
.space 1*4
rev_buf:
.space 30000*4

.globl end
end:
.balign 4
.globl aligned_end
aligned_end:
.globl bss_start
bss_start:
.globl _ZL16g_scratch_buffer
.equ _ZL16g_scratch_buffer, bss_start + 0
.globl bss_end
.equ bss_end, bss_start + 65488500
