########################################
# Elf32_Ehdr or Elf64_Ehdr #############
########################################
.globl ehdr
ehdr:
  # e_ident[EI_MAG0], magic value 0x7F
  .byte 0x7f
  # e_ident[EI_MAG1] to e_indent[EI_MAG3], magic value "ELF"
  .ascii "ELF"
  # e_ident[EI_CLASS], ELFCLASS32 = 1, ELFCLASS64 = 2
  .byte 0x1
  # e_ident[EI_DATA], ELFDATA2LSB = 1, ELFDATA2MSB = 2
  .byte 0x1
  # e_ident[EI_VERSION], EV_CURRENT = 1
  .byte 0x1
  # e_ident[EI_OSABI], ELFOSABI_SYSV = 0, ELFOSABI_LINUX = 3, ELFOSABI_FREEBSD = 9
  .byte 0x0
  # e_ident[EI_ABIVERSION], always 0
  .byte 0x0
  # e_indent[EI_MAG10 to EI_MAG15], unused
  .byte 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
  # e_type, ET_EXEC = 2
  .short 0x2
  # e_machine, EM_386 = 3, EM_ARM = 40, EM_X86_64 = 62, EM_AARCH64 = 183
  .short 0x3
  # e_version, EV_CURRENT = 1
  .long 0x1
  # e_entry, execution starting point
  .long _start
  # e_phoff, offset from start to program headers
  .long phdr_load - ehdr
  # e_shoff, start of section headers
  .long 0x0
  # e_flags, unused
  .long 0x0
  # e_ehsize, Elf32_Ehdr size
  .short ehdr_end - ehdr
  # e_phentsize, Elf32_Phdr size
  .short phdr_load_end - phdr_load
  # e_phnum, Elf32_Phdr count, PT_LOAD, [PT_LOAD (bss)], PT_INTERP, PT_DYNAMIC
  .byte 0x2
  .byte 0x0
.globl phdr_load
phdr_load:
  # e_shentsize, Elf32_Shdr size
  # p_type, PT_LOAD = 1
  .byte 0x1
  .byte 0x0
  # e_shnum, Elf32_Shdr count
  .byte 0x0
  .byte 0x0
  # e_shstrndx, index of section containing string table of section header names
  # p_offset, offset of program start
  .byte 0x0
  .byte 0x0
.globl ehdr_end
ehdr_end:
########################################
# Elf32_Phdr, PT_LOAD ##################
########################################
  .byte 0x0
  .byte 0x0
  # p_vaddr, program virtual address
  .byte 0x0
  .byte 0x0
  .byte 0x0
  .byte 0x2
  # p_paddr, unused
  .byte 0x0
  .byte 0x0
  .byte 0x0
  .byte 0x0
  # p_filesz, program size on disk
  .long end - ehdr
  # p_memsz, program size in memory
  .long bss_end - ehdr
  # p_flags, rwx = 7
  .long 0x7
  # p_align, usually 0x1000
  .long 0x1000
.globl phdr_load_end
phdr_load_end:
########################################
# Elf32_Phdr, PT_DYNAMIC ###############
########################################
.globl phdr_dynamic
phdr_dynamic:
  # p_type, PT_DYNAMIC = 2
  .long 0x2
  # p_offset, offset of block
  .long dynamic - ehdr
  # p_vaddr, address of block
  .long dynamic
  # p_paddr, unused
  .long 0x0
  # p_filesz, block size on disk
  .long dynamic_end - dynamic
  # p_memsz, block size in memory
  .long dynamic_end - dynamic
.globl dynamic
dynamic:
  # p_flags, ignored
  # d_tag, DT_DEBUG = 21
  .byte 0x15
  .byte 0x0
  .byte 0x0
  .byte 0x0
.globl dynamic_r_debug
dynamic_r_debug:
  # p_align, ignored
  # d_un
  .byte 0x0
  .byte 0x0
  .byte 0x0
  .byte 0x0
.globl phdr_dynamic_end
phdr_dynamic_end:
########################################
# PT_DYNAMIC ###########################
########################################
  # d_tag, DT_NEEDED = 1
  .byte 0x1
  .byte 0x0
  .byte 0x0
  .byte 0x0
  # d_un, library name offset in strtab
  .long strtab_libGL_so_1 - strtab
  # d_tag, DT_NEEDED = 1
  .long 0x1
  # d_un, library name offset in strtab
  .long strtab_libSDL2_so - strtab
  # d_tag, DT_SYMTAB = 6
  .long 0x6
  # d_un
  .long 0x0
  # d_tag, DT_STRTAB = 5
  .long 0x5
  # d_un
  .long strtab
  # d_tag, DT_NULL = 0
  .byte 0x0
  .byte 0x0
  .byte 0x0
  .byte 0x0
  # d_un
  .byte 0x0
  .byte 0x0
  .byte 0x0
.globl strtab
strtab:
  # initial zero
  .byte 0x0
.globl dynamic_end
dynamic_end:
########################################
# DT_STRTAB ############################
########################################
.globl strtab_libGL_so_1
strtab_libGL_so_1:
  # symbol name string
  .ascii "libGL.so.1"
  # string terminating zero
  .byte 0x0
.globl strtab_libSDL2_so
strtab_libSDL2_so:
  # symbol name string
  .ascii "libSDL2.so"
  # string terminating zero
  .byte 0x0
.globl strtab_end
strtab_end:
########################################
# sections 'None' ######################
########################################
	.balign 1
.LC0:
	.ascii	"#version 450\n#extension GL_NV_mesh_shader : require\nlayout"
	.ascii	"(local_size_x=1)in;layout(points,max_vertices=96,max_primiti"
	.ascii	"ves=96)out;layout(location=0)uniform sampler3D n;layout(loca"
	.ascii	"tion=1)uniform int g;vec3 f[]={vec3(27,0,0),vec3(-16.5,-17.2"
	.ascii	",-11.4),vec3(-16.5,-17.2,-11.4),vec3(0,-1,.04),vec3(0,-1,.04"
	.ascii	"),vec3(25,0,0),vec3(-16.5,-17.2,-11.4),vec3(-16.5,-15,-11.4)"
	.ascii	",vec3(0,-1,.04),vec3(0,-1,.04),vec3(40,0,0),vec3(-23.6,-7.36"
	.ascii	",-8.22),vec3(-20,-8,-12),vec3(-.9,.2,-.4),vec3(-.7,.6,-.4),v"
	.ascii	"ec3(40,0,0),vec3(-18,-25.8,82.2),vec3(-20,-69,80),vec3(-.97,"
	.ascii	".14,-.18),vec3(-.97,.14,-.18),vec3(52,0,0),vec3(88,-170,116)"
	.ascii	",vec3(30,-166,70),vec3(-.6,.3,-.7),vec3(-.89,.1,-.45),vec3(5"
	.ascii	"0,0,0),vec3(-5.5,2,-7.4),vec3(10.6,2.4,-1),vec3(.2,.07,-1),v"
	.ascii	"ec3(.9,.2,-.4),vec3(60,0,0),vec3(11,0,-27),vec3(11,-43,-26),"
	.ascii	"vec3(0,-1,.1),vec3(0,-1,.1),vec3(32,0,0),vec3(11,-43,-26),ve"
	.ascii	"c3(13,-72,-23),vec3(0,-1,.1),vec3(.01,.2,1),vec3(26,0,0),vec"
	.ascii	"3(-9,-70,23),vec3(-10.5,-70,20),vec3(.7,.1,-.7),vec3(.8,.1,-"
	.ascii	".6),vec3(24,0,0),vec3(-6.64,-72.63,13.94),vec3(-6.56,-72.56,"
	.ascii	"12.4),vec3(.92,.39,-.01),vec3(.94,.33,.07),vec3(70,0,0),vec3"
	.ascii	"(21.76,-65.44,14.64),vec3(34.34,-66.88,21.3),vec3(-.88,.12,-"
	.ascii	".46),vec3(-.88,.12,-.46)};int l=int(gl_WorkGroupID.s),e=g>>9"
	.ascii	";float t=smoothstep(57600,59700,e)-smoothstep(69300,71300,e)"
	.ascii	"*1.6;mat3 x=mat3(-.8,-.6,-.01,-.59,.78,-.2,.13,-.16,-.98);ma"
	.ascii	"t4 m=mat4(0);vec3 r=vec3(14,-64,11),z=normalize(vec3(.3,1,.3"
	.ascii	"));float S=1.778,s=99,Q=3.14159,distance=.09;out q{vec4 e;}d"
	.ascii	"[];vec3 N(vec3 e,float o,float i){vec3 t=vec3(0);float c=1;f"
	.ascii	"or(int v=0;v<4;++v)e=x*e,t+=texture(n,e).stp*c,e*=o,c*=i;ret"
	.ascii	"urn normalize(t);}float u(vec3 o){vec3 c=o;float v=o.t-13.;f"
	.ascii	"or(float e=99;e>.1;e*=.3){if(e>1)c.sp*=mat2(x);else c*=x;c=e"
	.ascii	"*.77-abs(mod(c,e+e)-e);float t=min(min(c.t,c.s),c.p);v=max(v"
	.ascii	",t);}if(t>.0){vec3 c=o-r;vec2 o=mod(c.sp+e*.002,1.6)-.8;floa"
	.ascii	"t i=length(c.sp)*1.6-abs(c.t)*.5+1;vec3 e=vec3(abs(o)-vec2(t"
	.ascii	"*.4),i);float t=length(max(e,0))+min(max(max(e.s,e.p),e.t),0"
	.ascii	");v=min(v,t);}return v;}float h(vec3 o,vec3 l,float i,out fl"
	.ascii	"oat c,out vec3 e){vec3"
	.ascii	" v=o;c=0;for(int a=0;a<200&&c<i;++a){e=o+c*l;float o=u(e);if"
	.ascii	"(o<.0){for(int c=0;c<9;++c){vec3 t=(v+e)*.5;if(u(t)<.0)e=t;e"
	.ascii	"lse v=t;}return 1;}float m=length(e-r)-mix(1.5,4.,t);if(m<.0"
	.ascii	")return -1;v=e,c=min(i,c+min(o,m)*1.005+.005);}return 0;}vec"
	.ascii	"4 C(vec3 d,vec3 o,out float p,out vec3 e){float i=h(d,o,s,p,"
	.ascii	"e);if(i>.0){vec3 a=vec3(.04,0,0),c=normalize(normalize(vec3("
	.ascii	"u(e+a),u(e+a.tst),u(e+a.tts)))+N(e*9,.1,1.4)*.05),s=r-e;floa"
	.ascii	"t m=length(s);vec3 v=normalize(mix(s/m,z,mix(1.,smoothstep(2"
	.ascii	"0.,30.,m),t))),d=normalize(v-o);float t=max(dot(c,v),0),l=ma"
	.ascii	"x(dot(c,-o),0),n=acos(t),f=acos(l),p=dot(normalize(v-t*c),no"
	.ascii	"rmalize(-o-l*c)),r=max(dot(c,d),0),o=1,u=r*r*3.+1,x=1.1*t*(."
	.ascii	"51+.45*max(0,p)*sin(max(n,f))*tan(min(n,f)))+t*(4./(Q*u*u))/"
	.ascii	"((1-t*o+o)*(1-l*o+o)),P=h(e+v*a.s,v,33,t,c);if(P>.0)x*=.6;re"
	.ascii	"turn vec4(mix(vec3(1.5,1.3,1),vec3(i),min(m*.009,1))*x,i);}r"
	.ascii	"eturn vec4(i);}void V(vec3 i,vec3 a,vec3 o,vec4 s,vec3 f,vec"
	.ascii	"3 r,float u,float e,int h){vec3 c=vec3(0);for(int v=0;v<h;++"
	.ascii	"v){c+=texture(n,o*.03+c*.011+vec3(0,0,.1)).stp*f+r;vec4 t=m*"
	.ascii	"vec4(o+c*e*e,1);t/=t.q;vec2 c=texture(n,(i*.002-a*.003+vec3("
	.ascii	"l+v))*x).st*mix(.0022,.0033,e);t.st+=c,gl_MeshVerticesNV[gl_"
	.ascii	"PrimitiveCountNV].gl_Position=t;vec4 o=mix(vec4(s.stp,1)*.6,"
	.ascii	"vec4(mix(vec3(.5,.5,.3),vec3(.3),e),1),u);d[gl_PrimitiveCoun"
	.ascii	"tNV].e=vec4(o.st+max(c,0)*44,o.pq),gl_PrimitiveIndicesNV[gl_"
	.ascii	"PrimitiveCountNV]=gl_PrimitiveCountNV,gl_PrimitiveCountNV+=1"
	.ascii	";}}void main(){if(t>-.6)t*=mix(e&63,63,t)/63.;gl_PrimitiveCo"
	.ascii	"untNV=0;int x=l/384,L=l-x*384;float Q=mix(-1.,1.,L/384.),N=m"
	.ascii	"ix(-1.,1.,(L+1)/384.),I=mix(-1.,1.,x/216.),X=mix(-1.,1.,(x+1"
	.ascii	")/216.),W=mix(Q,N,.5),d=mix(I,X,.5);vec3 o,i,u=vec3(0,1,0);f"
	.ascii	"loat D=g,y=88000;for(int e=0;true;e+=5){vec3 v=f[e];float c="
	.ascii	"v.s*y,t=D/c;if(t<1){o=mix(f[e+1],f[e+2],t),i=normalize(mix(f"
	.ascii	"[e+3],f[e+4],t));break;}D-=c;}vec2 g=vec2(W*S,d);vec3 c=norm"
	.ascii	"alize(cross(i,u));u=normalize(cross(c,i));vec3 p=normalize(g"
	.ascii	".s*c+g.t*u+i);float b=1.315;m[0][0]=b/S,m[1][1]=b,m[2][2]=(d"
	.ascii	"istance+s)/(distance-s),m[2][3]=-1,m[3][2]=2.*distance*s/(di"
	.ascii	"stance-s);mat3 S=tra"
	.ascii	"nspose(mat3(c,u,-i));mat4 E=mat4(S);E[3]=vec4(S*-o,1),m*=E;v"
	.ascii	"ec4 a=C(o,p,distance,c);float m=distance/s,P=sqrt(1-m),j=smo"
	.ascii	"othstep(10400,13100,e),s=smoothstep(12700,13100,e);int f=175"
	.ascii	"0;float _=mod(e-200,f),C=length(c-mix(o,r,t))*11;if(t<=0)_*="
	.ascii	"mix(e&255,255,_/f)/255;float v=e>73000?.0:smoothstep(-200,0,"
	.ascii	"-abs(_-C))*j*.3;a+=vec4(.4,0,.1,0)*v,v=v*(min(abs(e-49500),a"
	.ascii	"bs(e-76000))<4500?.03:1)+(j-s)*.1,i=mix(z,normalize(c-r),t)*"
	.ascii	"min(v,s)*.6,f=e/30,i+=texture(n,c*.001+d*vec3(.11,.1,.12)).s"
	.ascii	"tp*smoothstep(-.05,.0,-abs(d-texture(n,vec3(f*.11)+vec3(.11,"
	.ascii	".1,.11)).t*6.))*(.001-j*.001+t*.05);if(a.q<.0)a=-a,v=max(v,t"
	.ascii	"*((e&2048)>0?.5:.2));s=a.s*.3+a.t*.59+.11*a.p,V(o,p,c,mix(a,"
	.ascii	"vec4(s*.3),smoothstep(73000,76000,e)),vec3(v),i,m,P,64);if(l"
	.ascii	"<(smoothstep(13100,15000,e)-t)*21*21*21){int a=l/441,s=(l-a*"
	.ascii	"21*21)/21,f=l-a*21*21-s*21;vec3 i=floor(o)+vec3(f,s,a)-10,"
	.string	"t=texture(n,i*.011).stp;m=min(length(t),1),P=sqrt(1-m),t.t=mod(t.t-e*.0006,1),i+=t*33,t=i-o,v=length(t),h(o,t/v,33,distance,c);if(distance>v){h(i,vec3(0,1,0),33,distance,c);if(distance>=33)V(o,p,i,vec4(vec3(.9,.9,1),.01),vec3(.01),vec3(0,.02,0),m,P,32);}}}"
.LC1:
	.string	"#version 450\nlayout(location=0)out vec4 e;in q{vec4 e;}d;void main(){e=d.e;}"
	.balign 1
	.type	_ZL10audio_spec, @object
	.size	_ZL10audio_spec, 24
_ZL10audio_spec:
	.long	44100
	.value	-32480
	.byte	2
	.byte	0
	.value	256
	.value	0
	.long	0
	.long	_ZL14audio_callbackPvPhi
	.long	0
	.balign 1
	.type	_ZL14g_symbol_table, @object
	.size	_ZL14g_symbol_table, 108
_ZL14g_symbol_table:
	.long	40056346
	.long	782145266
	.long	1197378275
	.long	1210320339
	.long	1227524260
	.long	1233067696
	.long	1290677617
	.long	1548583489
	.long	1679585984
	.long	1690199314
	.long	2013251294
	.long	2066654278
	.long	-2078945128
	.long	-1948056258
	.long	-1817296575
	.long	-1696957364
	.long	-1621735015
	.long	-1526895129
	.long	-1408394855
	.long	-1349911288
	.long	-712635194
	.long	-649906955
	.long	231601855
	.long	-466619394
	.long	-323552505
	.long	-279420374
	.long	-121883401
	.ident	"GCC: (Ubuntu 11.4.0-1ubuntu1~22.04) 11.4.0"
	.balign 1
instr_addr:
.byte 0,0,0,0
	.balign 1
.equ OFF, 0
.equ Cs0, 1
.equ D0, 2
.equ Ds0, 3
.equ E0, 4
.equ F0, 5
.equ Fs0, 6
.equ G0, 7
.equ Gs0, 8
.equ A0, 9
.equ As0, 10
.equ B0, 11
.equ C1, 16
.equ Cs1, 17
.equ D1, 18
.equ Ds1, 19
.equ E1, 20
.equ F1, 21
.equ Fs1, 22
.equ G1, 23
.equ Gs1, 24
.equ A1, 25
.equ As1, 26
.equ B1, 27
.equ C2, 32
.equ Cs2, 33
.equ D2, 34
.equ Ds2, 35
.equ E2, 36
.equ F2, 37
.equ Fs2, 38
.equ G2, 39
.equ Gs2, 40
.equ A2, 41
.equ As2, 42
.equ B2, 43
.equ C3, 48
.equ Cs3, 49
.equ D3, 50
.equ Ds3, 51
.equ E3, 52
.equ F3, 53
.equ Fs3, 54
.equ G3, 55
.equ Gs3, 56
.equ A3, 57
.equ As3, 58
.equ B3, 59
.equ C4, 64
.equ Cs4, 65
.equ D4, 66
.equ Ds4, 67
.equ E4, 68
.equ F4, 69
.equ Fs4, 70
.equ G4, 71
.equ Gs4, 72
.equ A4, 73
.equ As4, 74
.equ B4, 75
.equ C5, 80
.equ Cs5, 81
.equ D5, 82
.equ Ds5, 83
.equ E5, 84
.equ F5, 85
.equ Fs5, 86
.equ G5, 87
.equ Gs5, 88
.equ A5, 89
.equ As5, 90
.equ B5, 91
.equ END_SONG, 255
.equ BD, 1
.equ SD, 2
osc_semitones:
.byte 12,0,0,0
song:
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 1
.byte 1
.byte 1
.byte 14
.byte 1
.byte 12
.byte 13
.byte 1
.byte 6
.byte 6
.byte 6
.byte 15
.byte 6
.byte 6
.byte 6
.byte 15
.byte 1
.byte 1
.byte 1
.byte 14
.byte 1
.byte 12
.byte 13
.byte 1
.byte 6
.byte 6
.byte 15
.byte 6
.byte 15
.byte 6
.byte 6
.byte 13
.byte 1
.byte 5
.byte 255
song2:
.byte 0
.byte 0
.byte 0
.byte 0
.byte 2
.byte 0
.byte 0
.byte 0
.byte 2
.byte 0
.byte 2
.byte 0
.byte 2
.byte 0
.byte 2
.byte 2
.byte 0
.byte 0
.byte 0
.byte 0
.byte 17
.byte 0
.byte 17
.byte 0
.byte 2
.byte 0
.byte 2
.byte 2
.byte 2
.byte 0
.byte 2
.byte 0
.byte 2
.byte 17
.byte 0
.byte 17
.byte 2
.byte 2
.byte 0
.byte 2
.byte 255
song3:
.byte 7
.byte 7
.byte 9
.byte 10
.byte 7
.byte 7
.byte 10
.byte 9
.byte 7
.byte 7
.byte 9
.byte 7
.byte 9
.byte 10
.byte 10
.byte 7
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 7
.byte 7
.byte 10
.byte 9
.byte 7
.byte 10
.byte 8
.byte 7
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 8
.byte 10
.byte 7
.byte 7
.byte 255
song4:
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 11
.byte 19
.byte 19
.byte 19
.byte 19
.byte 19
.byte 19
.byte 19
.byte 11
.byte 11
.byte 11
.byte 255
drum_song:
.byte 0
.byte 0
.byte 0
.byte 0
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 3
.byte 4
.byte 4
.byte 0
.byte 0
.byte 0
.byte 0
.byte 4
.byte 4
.byte 3
.byte 4
.byte 4
.byte 4
.byte 4
.byte 3
.byte 4
.byte 4
.byte 3
.byte 4
.byte 4
.byte 3
.byte 4
.byte 4
.byte 4
.byte 4
.byte 4
.byte 3
.byte 255
sequences:
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 32
.byte 32
.byte 0
.byte 26
.byte 0
.byte 32
.byte 32
.byte 0
.byte 0
.byte 0
.byte 0
.byte 58
.byte 64
.byte 0
.byte 70
.byte 65
.byte 0
.byte 0
.byte 0
.byte 0
.byte 80
.byte 0
.byte 0
.byte 81
.byte 0
.byte 0
.byte 80
.byte 0
.byte 0
.byte 75
.byte 0
.byte 0
.byte 1
.byte 0
.byte 0
.byte 0
.byte 2
.byte 0
.byte 1
.byte 0
.byte 0
.byte 1
.byte 0
.byte 1
.byte 2
.byte 0
.byte 1
.byte 0
.byte 1
.byte 0
.byte 0
.byte 0
.byte 2
.byte 0
.byte 1
.byte 0
.byte 1
.byte 0
.byte 0
.byte 0
.byte 2
.byte 0
.byte 1
.byte 0
.byte 32
.byte 32
.byte 0
.byte 26
.byte 0
.byte 32
.byte 32
.byte 0
.byte 32
.byte 16
.byte 16
.byte 2
.byte 0
.byte 0
.byte 0
.byte 0
.byte 37
.byte 37
.byte 0
.byte 35
.byte 0
.byte 37
.byte 37
.byte 0
.byte 0
.byte 53
.byte 0
.byte 64
.byte 0
.byte 67
.byte 69
.byte 70
.byte 16
.byte 16
.byte 16
.byte 0
.byte 16
.byte 0
.byte 0
.byte 0
.byte 0
.byte 16
.byte 16
.byte 0
.byte 16
.byte 0
.byte 0
.byte 0
.byte 21
.byte 21
.byte 21
.byte 0
.byte 21
.byte 0
.byte 0
.byte 0
.byte 0
.byte 21
.byte 21
.byte 0
.byte 21
.byte 0
.byte 0
.byte 0
.byte 16
.byte 16
.byte 16
.byte 0
.byte 16
.byte 0
.byte 0
.byte 0
.byte 0
.byte 16
.byte 16
.byte 0
.byte 16
.byte 17
.byte 0
.byte 17
.byte 10
.byte 10
.byte 10
.byte 0
.byte 10
.byte 0
.byte 0
.byte 0
.byte 0
.byte 10
.byte 10
.byte 0
.byte 10
.byte 17
.byte 0
.byte 17
.byte 0
.byte 80
.byte 0
.byte 0
.byte 80
.byte 0
.byte 0
.byte 80
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 48
.byte 42
.byte 0
.byte 42
.byte 0
.byte 26
.byte 26
.byte 0
.byte 0
.byte 0
.byte 0
.byte 58
.byte 64
.byte 0
.byte 68
.byte 69
.byte 26
.byte 26
.byte 0
.byte 26
.byte 0
.byte 26
.byte 42
.byte 0
.byte 26
.byte 0
.byte 0
.byte 58
.byte 64
.byte 0
.byte 69
.byte 64
.byte 32
.byte 32
.byte 0
.byte 26
.byte 0
.byte 32
.byte 32
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 0
.byte 65
.byte 37
.byte 37
.byte 0
.byte 35
.byte 0
.byte 37
.byte 37
.byte 0
.byte 0
.byte 0
.byte 53
.byte 53
.byte 0
.byte 48
.byte 35
.byte 35
.byte 35
.byte 35
.byte 0
.byte 35
.byte 0
.byte 34
.byte 34
.byte 0
.byte 0
.byte 0
.byte 58
.byte 42
.byte 0
.byte 26
.byte 42
.byte 0
.byte 0
.byte 85
.byte 0
.byte 0
.byte 0
.byte 85
.byte 85
.byte 0
.byte 0
.byte 0
.byte 80
.byte 0
.byte 85
.byte 69
.byte 69
.byte 0
.byte 10
.byte 10
.byte 0
.byte 10
.byte 0
.byte 10
.byte 0
.byte 0
.byte 0
.byte 26
.byte 10
.byte 0
.byte 8
.byte 0
.byte 18
.byte 10
.byte 0
.byte 80
.byte 0
.byte 0
.byte 80
.byte 0
.byte 0
.byte 80
.byte 0
.byte 0
.byte 80
.byte 0
.byte 80
.byte 0
.byte 0
.byte 74
	.balign 1
drum_magic:
.byte 0,249,34,71
drum_vol:
.byte 0,183,81,57
drum_vol_2:
.byte 0,183,209,57
small:
.byte 0,197,167,54
	.balign 1
fm_decay:
.byte 0,190,127,63
fm_attack:
.byte 0,215,163,60
portamento_a:
.byte 0,73,29,58
portamento_b:
.byte 0,216,127,63
rev_amp:
.byte 0,153,25,63
base_freq:
.byte 0,251,46,59
rev_x:
.byte 0,204,204,62
fm_instruments:
fm_op_freqs:
.byte 0,0,128,63
.byte 0,0,128,63
.byte 0,0,0,64
fm_mod_amps:
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,204,204,61
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,204,76,62
.byte 0,204,76,62
.byte 0,204,204,61
volume:
.byte 0,20,46,62
fm_op_freqs2:
.byte 0,0,0,64
.byte 0,0,160,64
.byte 0,0,0,64
fm_mod_amps2:
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,153,25,62
.byte 0,204,76,61
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,153,25,62
.byte 0,0,0,0
volume2:
.byte 0,194,245,61
fm_op_freqs3:
.byte 0,0,128,64
.byte 0,0,64,64
.byte 0,0,128,63
fm_mod_amps3:
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,215,35,60
.byte 0,204,76,61
.byte 0,0,0,0
volume3:
.byte 0,215,35,62
fm_op_freqs4:
.byte 0,71,129,63
.byte 0,225,250,62
.byte 0,0,0,63
fm_mod_amps4:
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,194,245,61
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,194,245,61
.byte 0,153,25,62
.byte 0,153,153,62
volume4:
.byte 0,81,56,62
fm_op_freqs_drum:
.byte 0,0,0,0
.byte 0,0,0,0
.byte 0,0,0,0
rev_filter_a:
.byte 0,204,204,61
rev_filter_b:
.byte 0,102,102,63
	.file	"intro.cpp"
	.type	_ZL14audio_callbackPvPhi, @function
_ZL14audio_callbackPvPhi:
	pushl	%esi
	pushl	%ebx
	movl	20(%esp), %ecx
	movl	_ZL16g_audio_position, %edx
	xorl	%eax, %eax
.L2:
	cmpl	%ecx, %eax
	jge	.L6
	movl	16(%esp), %esi
	movb	_ZL16g_scratch_buffer+19404000(%edx,%eax), %bl
	movb	%bl, (%esi,%eax)
	incl	%eax
	jmp	.L2
.L6:
	addl	%ecx, %edx
	movl	%edx, _ZL16g_audio_position
	popl	%ebx
	popl	%esi
	ret
	.size	_ZL14audio_callbackPvPhi, .-_ZL14audio_callbackPvPhi
	.type	_ZL13create_shaderPKcj, @function
_ZL13create_shaderPKcj:
	pushl	%ebx
	pushl	%ecx
	movl	%eax, (%esp)
	pushl	%edx
	call	*_ZL14g_symbol_table+104
	movl	%eax, %ebx
	pushl	$0
	leal	8(%esp), %eax
	pushl	%eax
	pushl	$1
	pushl	%ebx
	call	*_ZL14g_symbol_table+12
	pushl	%ebx
	call	*_ZL14g_symbol_table+72
	movl	%ebx, %eax
	addl	$28, %esp
	popl	%ebx
	ret
	.size	_ZL13create_shaderPKcj, .-_ZL13create_shaderPKcj
	.globl	_start
	.type	_start, @function
_start:
	subl	$80, %esp
	xorl	%ebx, %ebx
.L20:
	movl	_ZL14g_symbol_table(,%ebx,4), %eax
	movl	%eax, 4(%esp)
	movl	dynamic_r_debug, %eax
	movl	4(%eax), %esi
.L23:
	movl	12(%esi), %esi
	movl	8(%esi), %edx
.L10:
	addl	$8, %edx
	cmpl	$5, (%edx)
	jne	.L10
	movl	4(%edx), %eax
	movl	%eax, (%esp)
	movl	(%esi), %eax
	cmpl	%eax, (%esp)
	jnb	.L11
	addl	%eax, (%esp)
.L11:
	movl	12(%edx), %edx
	cmpl	%edx, %eax
	jbe	.L13
	addl	%eax, %edx
	jmp	.L13
.L14:
	crc32b	%cl, %edi
.L17:
	incl	%ebp
	movb	-1(%ebp), %cl
	testb	%cl, %cl
	jne	.L14
	cmpl	%edi, 4(%esp)
	je	.L33
	addl	$16, %edx
.L13:
	cmpl	(%esp), %edx
	jnb	.L23
	movl	(%esp), %ecx
	addl	(%edx), %ecx
	movl	%ecx, %ebp
	xorl	%edi, %edi
	jmp	.L17
.L33:
	addl	4(%edx), %eax
	movb	12(%edx), %dl
	andl	$15, %edx
	cmpb	$10, %dl
	jne	.L19
	call	*%eax
.L19:
	movl	%eax, _ZL14g_symbol_table(,%ebx,4)
	incl	%ebx
	cmpl	$27, %ebx
	jne	.L20
	pushl	$48
	call	*_ZL14g_symbol_table+36
	pushl	$1
	pushl	$21
	call	*_ZL14g_symbol_table+40
	pushl	$4
	pushl	$17
	call	*_ZL14g_symbol_table+40
	pushl	$5
	pushl	$18
	call	*_ZL14g_symbol_table+40
	pushl	$3
	pushl	$1080
	pushl	$1920
	pushl	$536805376
	pushl	$536805376
	pushl	$0
	call	*_ZL14g_symbol_table+92
	movl	%eax, g_sdl_window
	addl	$52, %esp
	pushl	%eax
	call	*_ZL14g_symbol_table+4
	pushl	$0
	call	*_ZL14g_symbol_table+20
	pushl	$_ZL10g_gl_array
	pushl	$1
	call	*_ZL14g_symbol_table+76
	movl	_ZL15g_lgc_rand_seed, %eax
	addl	$16, %esp
	xorl	%edx, %edx
.L24:
	imull	$1103515245, %eax, %eax
	addl	$12345, %eax
	movl	%eax, %ecx
	sarl	$16, %ecx
	movw	%cx, _ZL16g_scratch_buffer+19404000(%edx)
	addl	$2, %edx
	cmpl	$1572864, %edx
	jne	.L24
	movl	%eax, _ZL15g_lgc_rand_seed
	pushl	_ZL10g_gl_array
	pushl	$32879
	call	*_ZL14g_symbol_table+16
	pushl	$_ZL16g_scratch_buffer+19404000
	pushl	$5122
	pushl	$6407
	pushl	$0
	pushl	$64
	pushl	$64
	pushl	$64
	pushl	$36762
	pushl	$0
	pushl	$32879
	call	*_ZL14g_symbol_table+80
	addl	$48, %esp
	pushl	$9987
	pushl	$10241
	pushl	$32879
	call	*_ZL14g_symbol_table+24
	pushl	$32879
	call	*_ZL14g_symbol_table+8
	pushl	$3042
	call	*_ZL14g_symbol_table+68
	pushl	$771
	pushl	$1
	call	*_ZL14g_symbol_table+96
	call	*_ZL14g_symbol_table
	movl	%eax, %ebx
	movl	_ZL14g_symbol_table+28, %esi
	movl	$38233, %edx
	movl	$.LC0, %eax
	call	_ZL13create_shaderPKcj
	pushl	%eax
	pushl	%ebx
	call	*%esi
	movl	_ZL14g_symbol_table+28, %esi
	addl	$36, %esp
	movl	$35632, %edx
	movl	$.LC1, %eax
	call	_ZL13create_shaderPKcj
	pushl	%eax
	pushl	%ebx
	call	*%esi
	pushl	%ebx
	call	*_ZL14g_symbol_table+60
	movl	%ebx, _ZL10g_gl_array+4
	pushl	%ebx
	call	*_ZL14g_symbol_table+48
	movl	$_ZL16g_scratch_buffer, %eax
	call	synth
	pushl	$0
	pushl	$_ZL10audio_spec
	call	*_ZL14g_symbol_table+44
	pushl	$0
	call	*_ZL14g_symbol_table+100
	addl	$28, %esp
.L26:
	movl	_ZL16g_audio_position, %ebx
	leal	8(%esp), %eax
	pushl	%eax
	call	*_ZL14g_symbol_table+32
	popl	%eax
	cmpl	$39160799, %ebx
	jg	.L25
	cmpl	$768, 8(%esp)
	je	.L25
	pushl	$16384
	call	*_ZL14g_symbol_table+56
	pushl	$0
	pushl	$0
	call	*_ZL14g_symbol_table+52
	pushl	%ebx
	pushl	$1
	call	*_ZL14g_symbol_table+52
	pushl	$82944
	pushl	$0
	call	*_ZL14g_symbol_table+88
	pushl	g_sdl_window
	call	*_ZL14g_symbol_table+64
	addl	$32, %esp
	jmp	.L26
.L25:
	call	*_ZL14g_symbol_table+84
#APP
# 138 "src/dnload.h" 1
	int $0x3
.global synth
.equ REV_LEN, 24000
.equ FM_INSTR_SIZE, 48
.equ TICKLEN, 7000
.equ TICKLEN_B, 28000
synth:
pusha
movl %eax,%edi
pushl %edi
pushl %edi
movl $110*44100,%ecx
xorl %eax,%eax
rep
stosl
popl %edi
movl $fm_op_freqs, %eax
movl %eax,instr_addr
pushl %edi
movl $song, %ebp
call seq
popl %edi
movl $fm_op_freqs2, %eax
movl %eax,instr_addr
pushl %edi
movl $song2, %ebp
call seq
popl %edi
synth.skip2:
movl $fm_op_freqs3, %eax
movl %eax,instr_addr
pushl %edi
movl $song3, %ebp
call seq
popl %edi
synth.skip3:
movl $fm_op_freqs4, %eax
movl %eax,instr_addr
pushl %edi
movl $song4, %ebp
call seq
popl %edi
synth.drum:
movl $fm_op_freqs_drum, %eax
movl %eax,instr_addr
pushl %edi
movl $drum_song, %ebp
call seq
popl %edi
synth.do_reverb:
popl %esi
movl %esi,%edi
addl $4*110*44100,%edi
movl $110*44100,%ecx
call reverb
popa
ret
seq:
xorl %edx,%edx
seq.seq_loop:
testl %edx,%edx
jnz seq.no_advance_order
xorl %eax,%eax
movb (%ebp),%al
incl %ebp
cmpb $-1,%al
je seq.out
imull $16,%eax,%esi
movl $16,%edx
seq.no_advance_order:
xorl %eax,%eax
movb sequences(%esi),%al
movl %eax,current_note
movb %al,%cl
shrb $4,%cl
andb $0x0f,%al
pushl %eax
fildl (%esp)
popl %eax
fidivl osc_semitones
f2xm1
fld1
faddp
movl $1,%ebx
shl %cl,%ebx
pushl %ebx
fimull (%esp)
popl %ebx
fmuls base_freq
movl $TICKLEN, %ecx
pusha
movl instr_addr,%ebp
testl $0xffffffff,(%ebp)
jz seq.is_drum
call fm
jmp seq.not_drum
seq.is_drum:
call drum
seq.not_drum:
popa
fstp %st
addl $TICKLEN_B, %edi
incl %esi
decl %edx
jmp seq.seq_loop
seq.out:
ret
fm:
fm.output_loop:
pushl %ecx
movl $fm_ctrs, %ebx
xorl %eax,%eax
movl $3,%ecx
fm.fm_osc_loop:
pushl %ecx
fld %st
fmuls portamento_a
flds 12(%ebx,%eax)
fmuls portamento_b
faddp
movl current_note,%ecx
cmpl $0,%ecx
je fm.no_porta
fsts 12(%ebx,%eax)
fld1
fsubs fm_volume
fmuls fm_attack
fadds fm_volume
fstps fm_volume
jmp fm.yes_porta
fm.no_porta:
flds fm_volume
fmuls fm_decay
fadds small
fstps fm_volume
fm.yes_porta:
fldz
xorl %esi,%esi
movl $3,%ecx
fm.fm_mod_sum_loop:
pushl %ecx
pushl %eax
flds 24(%esi,%ebx)
imull $3,%eax,%eax
addl %esi,%eax
fmuls 12(%ebp,%eax)
faddp %st(1)
popl %eax
addl $4,%esi
popl %ecx
loop fm.fm_mod_sum_loop
flds (%ebx,%eax)
flds (%ebp,%eax)
fmul %st(3)
faddp
faddp
fldpi
fadd %st
fxch %st(1)
fprem1
fsts (%ebx,%eax)
fsin
fm.no_wrap:
fstps fm_outs(%eax)
addl $4,%eax
fstp %st
fstp %st
popl %ecx
decl %ecx
jnz fm.fm_osc_loop
flds last_osc
fmuls 48(%ebp)
fmuls fm_volume
fadds (%edi)
fstps (%edi)
addl $4,%edi
popl %ecx
decl %ecx
jnz fm.output_loop
ret
drum:
xorl %ebx,%ebx
cmpb $1,%al
je drum.bd
cmpb $2,%al
je drum.sd
addl $TICKLEN_B, %edi
ret
drum.bd:
movl $2200,%ecx
movl $0x00fffff,%esi
flds drum_vol
jmp drum.bd_loop
drum.sd:
movl $1200,%ecx
movl $0x08ffff,%esi
flds drum_vol_2
drum.bd_loop:
addl %ecx,%ebx
andl %esi,%ebx
pushl %ebx
fildl (%esp)
popl %ebx
fdivs drum_magic
fsin
pushl %ecx
fimull (%esp)
popl %ecx
fmul %st(1)
flds (%edi)
faddp
fstps (%edi)
addl $4,%edi
loop drum.bd_loop
fstp %st
ret
reverb:
reverb.reverb_loop:
pushl %ecx
flds (%esi)
fmuls rev_filter_a
flds rev_filter_state
fmuls rev_filter_b
faddp
fsts rev_filter_state
movl rev_buf_pos,%ebx
fadds rev_buf(%ebx)
fmuls rev_x
reverb.b:
fstps rev_buf(%ebx)
subl $4,%ebx
jns reverb.no_wrap
addl $REV_LEN, %ebx
reverb.no_wrap:
movl %ebx,rev_buf_pos
movl $2,%ecx
reverb.reverb_ch_loop:
pushl %ecx
fldz
movl $24,%ecx
reverb.reverb_accum_loop:
imull $128,%ecx,%eax
addl %eax,%ebx
subl $4777*4,%ebx
jns reverb.no_wrap2
addl $REV_LEN, %ebx
reverb.no_wrap2:
fadds rev_buf(%ebx)
fchs
loop reverb.reverb_accum_loop
fmuls rev_amp
fadds (%esi)
fsts (%edi)
addl $4,%edi
fstp %st
popl %ecx
loop reverb.reverb_ch_loop
addl $4,%esi
popl %ecx
decl %ecx
jnz reverb.reverb_loop
ret
current_note:
.byte 0,0,0,0
fm_volume:
.space 1*4
fm_ctrs:
.space 3*4
osc_freqs:
.space 3*4
fm_outs:
.space 2*4
last_osc:
.space 1*4
rev_filter_state:
.space 1*4
rev_buf_pos:
.space 1*4
.space 1*4
rev_buf:
.space 30000*4

.globl end
end:
.balign 4
.globl aligned_end
aligned_end:
.globl bss_start
bss_start:
.globl _ZL15g_lgc_rand_seed
.equ _ZL15g_lgc_rand_seed, bss_start + 0
.globl g_sdl_window
.equ g_sdl_window, bss_start + 4
.globl _ZL16g_audio_position
.equ _ZL16g_audio_position, bss_start + 8
.globl _ZL10g_gl_array
.equ _ZL10g_gl_array, bss_start + 12
.globl _ZL16g_scratch_buffer
.equ _ZL16g_scratch_buffer, bss_start + 20
.globl bss_end
.equ bss_end, bss_start + 63459920
