import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:useless_app/data.dart';
import 'dart:math';


void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return ChangeNotifierProvider(
      create: (context) => MyAppState(),
      child: MaterialApp(
        debugShowCheckedModeBanner: true,
        title: 'Useless App',
        theme: ThemeData(
          useMaterial3: true,
          colorScheme: ColorScheme.fromSeed(seedColor: Colors.purple),
        ),
        home: MyHomePage(),
      ),
    );
  }
}

class MyAppState extends ChangeNotifier {
  void getNext() {
    notifyListeners();
  }
}

class MyHomePage extends StatefulWidget {
  @override
  State<MyHomePage> createState() => _MyHomePageState();
}

class _MyHomePageState extends State<MyHomePage> {

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        return Scaffold(
          body: Row(
            children: [
              Expanded(
                child: Container(
                  color: Theme.of(context).colorScheme.primaryContainer,
                  child: uselessPage(),
                ),
              ),
            ],
          ),
        );
      }
    );
  }
}



class uselessPage extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    var appState = context.watch<MyAppState>();
    return Center(
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          Container(
            padding: EdgeInsets.all(20),
            margin: EdgeInsets.all(10),
            height: 100,
            color: Colors.redAccent,
            child: Center(child: Text(getResults(),style: TextStyle(color: Colors.white  ))),
          ),
          const SizedBox(height: 10),
          Column(
            children: [
              ElevatedButton(
                onPressed: () {
                  appState.getNext();
                },
                child: const Text('Trykk her'),
              ),
            ]
          ),
        ],
      ),
    );
  }
}

String getResults(){
  return results[Random().nextInt(results.length)];
}