;
; params.s
; Synth85
;
; Created by Stefan Koch on 20.08.16.
; Copyright (c) 2016 Moods Plateau.
; All rights reserved.
;

; ---------- constants ----------

_P_PRESCALE:	EQU	0
_P_VALUE:	EQU	1
_P_VOLUME:	EQU	2
_P_PFLAG:	EQU	3	; period changed
_P_VFLAG:	EQU	4	; volume changed

_P_BUFFER_SIZE:	EQU	5

; ---------- set ----------

; setup working buffer from channel 1
params_setup_ch1:
	ld	HL,_p_channel1
	ld	DE,_p_channel
	ld	BC,_P_BUFFER_SIZE
	ldir
	; reset flags
	xor	A
	ld	(_p_channel+_P_PFLAG),A
	ld	(_p_channel+_P_VFLAG),A
	ret

; setup working buffer from channel 2
params_setup_ch2:
	ld	HL,_p_channel2
	ld	DE,_p_channel
	ld	BC,_P_BUFFER_SIZE
	ldir
	; reset flags
	xor	A
	ld	(_p_channel+_P_PFLAG),A
	ld	(_p_channel+_P_VFLAG),A
	ret

; set working buffer period
;
; H = VT
; L = ZG
params_set_period:
	ld	A,H
	ld	(_p_channel+_P_PRESCALE),A
	ld	A,L
	ld	(_p_channel+_P_VALUE),A
	ld	A,1
	ld	(_p_channel+_P_PFLAG),A
	ret

; set working buffer volume
;
; Sets period to zero (channel off) if volume is 0.
;
; A = Volume (0..64 / 00H..40H)
params_set_volume:
	and	A
	jr	NZ,.skip_off

	; note off (current channel)
	xor	A	; 0 = off
	ld	(_p_channel+_P_VALUE),A
	ld	A,1	; period changed
	ld	(_p_channel+_P_PFLAG),A
	ret

.skip_off:
	ld	(_p_channel+_P_VOLUME),A
	ld	A,1	; volume changed
	ld	(_p_channel+_P_VFLAG),A
	ret

; ---------- get ----------

; store working buffer in channel 1
params_store_ch1:
	ld	HL,_p_channel
	ld	DE,_p_channel1
	ld	BC,_P_BUFFER_SIZE
	ldir

	; volume control
	ld	A,(mod_song_attrs)
	and	MOD_SA_LEFT
	jp	NZ,.p_vc_ch1_skip

	ld	HL,_p_channel1+_P_VFLAG
	ld	(HL),0	; reset volume changed flag

.p_vc_ch1_skip:
	ret

; store working buffer in channel 2
params_store_ch2:
	ld	HL,_p_channel
	ld	DE,_p_channel2
	ld	BC,_P_BUFFER_SIZE
	ldir

	; volume control
	ld	A,(mod_song_attrs)
	and	MOD_SA_RIGHT
	jp	NZ,.p_vc_ch2_skip

	ld	HL,_p_channel2+_P_VFLAG
	ld	(HL),0	; reset volume changed flag

.p_vc_ch2_skip:
	ret

; ---------- value access ----------

; loads ch1 period into HL, pflag into A
params_load_ch1:
	ld	A,(_p_channel1+_P_PRESCALE)
	ld	H,A
	ld	A,(_p_channel1+_P_VALUE)
	ld	L,A
	ld	A,(_p_channel1+_P_PFLAG)
	ret

; loads ch2 period into HL, pflag into A
params_load_ch2:
	ld	A,(_p_channel2+_P_PRESCALE)
	ld	H,A
	ld	A,(_p_channel2+_P_VALUE)
	ld	L,A
	ld	A,(_p_channel2+_P_PFLAG)
	ret

; loads resulting volume into C, vflag into A
params_load_volume:
	ld	A,(_p_channel2+_P_VFLAG)	; ch2 overwrites ch1
	and	A
	jp	NZ,.lv_ch2

	ld	A,(_p_channel1+_P_VFLAG)
	and	A
	jp	NZ,.lv_ch1

	xor	A
	ret

.lv_ch2:
	ld	A,(_p_channel2+_P_VOLUME)
	ld	C,A
	ld	A,1
	ret

.lv_ch1:
	ld	A,(_p_channel1+_P_VOLUME)
	ld	C,A
	ld	A,1
	ret

; ---------- data ----------

; work buffer
;
; prescale. period, volume, pflag, vflag
; channel off if period = 0
;
_p_channel:
	defs	_P_BUFFER_SIZE

; channel buffer
;
_p_channel1:
	defs	_P_BUFFER_SIZE

_p_channel2:
	defs	_P_BUFFER_SIZE
