;
; interrupt.s
; Framework85
;
; Created by Stefan Koch on 27.05.17.
;
;

; Initializes ISR and sets timer to division of 50 Hz.
;
; The ISR must save and restore all modified registers
; and return with EI and RETI instructions.
;
; HL = Int Handler (ISR)
; A = Time Constant (Division of 50 Hz)
;
CTC_INIT:

	LD	C,CTC2		; CTC2 -> C

	DI

	LD	E,(IX+IXO_CTC2)	; store current int service routine
	LD	D,(IX+IXO_CTC2+1)
	LD	(_CTC_OLDINT),DE

	LD	(IX+IXO_CTC2),L	; entry new interrupt routine (interner CTC Kanal 2)
	LD	(IX+IXO_CTC2+1),H

;	synced with vblank
;	LD	L,CTCF_CONTROL|CTCF_RESET|CTCF_TCONST|CTCF_TTRIGGER|CTCF_PRESCALE|CTCF_INT

	; This is definitely wrong! Trigger does only work in timer mode.
	LD	L,CTCF_CONTROL|CTCF_RESET|CTCF_TCONST|CTCF_TTRIGGER|CTCF_COUNTER|CTCF_INT
	OUT	(C),L		; Zeitgeber (50 Hz)
	OUT	(C),A		; Dauer (A/50 s)

	IM	2		; Interrupt Modus 2
	EI

	RET

CTC_CLEANUP:

	LD	A,3
	OUT	(CTC2),A	; CTC2 stoppen

	DI

	LD	HL,(_CTC_OLDINT)
	LD	(IX+IXO_CTC2),L	; restore original int routine
	LD	(IX+IXO_CTC2+1),H

	EI

	RET

IRET:
	EI
	RETI

; ---------- static data ----------

_CTC_OLDINT:
	DEFW	0
