;
; add16.i
; Framework85
;
; Created by Stefan Koch on 28.11.17.
;
;

; Add A to 16 bit register
;
; https://wikiti.brandonw.net/index.php?title=Z80_Routines:Optimized:addAtoHL
;
ADD16:	MACRO hi lo	; 20 cycles
	ADD	lo
	LD	lo,A
	JR	NC,$+3
	INC	hi
	ENDM

; Add A with 16 bit constant
;
; result in HL
;
ADDC16:	MACRO c	; 26 cycles
	ADD	(c)%256
	LD	L,A
	ADC	A,(c)/256
	SUB	L
	LD	H,A
	ENDM
