poke(0x7FC3F,1,1) -- get rid of the cursor
ticks = 0

function TIC()

ticks = ticks + 1

t=ticks/60

vs = {
    -- Top vertex
    0,  1,  0,

    -- Middle vertices around the equator
    -1,  0, -1,
     1,  0, -1,
     1,  0,  1,
    -1,  0,  1,

    -- Bottom vertex
    0, -1,  0,
}


is = {
    -- Top pyramid (CCW from the top view)
    0, 2, 1,        -- outside a
    0, 3, 2,        -- outside b
    0, 4, 3,        -- outside c
    0, 1, 4,        -- outside d

    -- Bottom pyramid (CCW from the bottom view)
    5, 1, 2,        -- o
    5, 2, 3,        -- o
    5, 3, 4,        -- o
    5, 4, 1,
}

w=240
h=136
-- using theta = w*t*2*PI with a well chosen w :D
s = math.sin(t/2)
c = math.cos(t/2)


ns = {}


function quatMultiply(q1, q2)
     return {
         q1[1]*q2[1] - q1[2]*q2[2] - q1[3]*q2[3] - q1[4]*q2[4],
         q1[1]*q2[2] + q1[2]*q2[1] + q1[3]*q2[4] - q1[4]*q2[3],
         q1[1]*q2[3] - q1[2]*q2[4] + q1[3]*q2[1] + q1[4]*q2[2],
         q1[1]*q2[4] + q1[2]*q2[3] - q1[3]*q2[2] + q1[4]*q2[1]
     }
end

cls()

axis = {1,0,1}
if s > 0 then
    axis = {1,1,0}
end
glenz = 1
translate_z = 4
scale_xz = 0.8
scale_y = 0.8
vol = 2 * (1+ticks/600)

if ticks < 600 then
    translate_z = 1.2
    axis = {0,0,1}
elseif ticks < 1200 then
    scale_y = 0
    translate_z = 8
end
if ticks > 2000 then
    glenz = -1
    scale_xz = 1.2
    scale_y = 1.2
end


is_i = 0
for tri_i=0,7 do
    poke(2*(0xFF9C+1)+2*tri_i,scale_xz*tri_i/2, 4)

    ns_i0 = 0
    for tri_local_v_i=0,2 do
        is_i = is_i + 1
        vs_i0 = is[is_i]*3
        q = {c, axis[1]*s, axis[2]*s, axis[3]*s}
        r = quatMultiply(q, {0, vs[vs_i0+1]*scale_xz,vs[vs_i0+2]*scale_y,vs[vs_i0+3]*scale_xz})
        q_inv = {q[1], -q[2], -q[3], -q[4]}
        p = quatMultiply(r, q_inv)
        ns_i0 = ns_i0 + 2
        ns[ns_i0-1] = w/2 - h*p[2] / (p[4]+translate_z)
        ns[ns_i0  ] = h/2 + h*p[3] / (p[4]+translate_z)
    end

    trib(ns[1],ns[2],ns[3],ns[4],ns[5],ns[6], tri_i+1)

    sgn = 1
    if ticks % 2 == 0 then
        sgn = glenz
    end

    --    (x1-    x3)*(   y2-    y3) - (x2-   x3)*(   y1-    y3)
    cross = (ns[1]-ns[5])*(ns[4]-ns[6]) - (ns[3]-ns[5])*(ns[2]-ns[6])
    if sgn*cross < 0 then
        tri(ns[1],ns[2],ns[3],ns[4],ns[5],ns[6], math.fmod(tri_i+t, 16))
    end

end


--for i=0,31 do
--    poke(2*(0xFF9C+1)+i,i/2, 4)
--end
--poke(0xFF9C+0,s*s*4096)
--poke(0xFF9C+1,(s*s*4096)%16 + s*vol)

--sfx(0, 20, -1,0,15)
--poke(0xFF9C+0,s*0xff9c)
poke(0xFF9C+1,(s*0xff9c)%16 + s*vol)


end

