; Prepared for Demosplash 2023
;
; Code: Kneebiter
; 
; Animates a morphing Julia set along with some midi bleeps.
; Order of operations could probably be optimized to reduce fxch calls.
;
org 0x100
bits 16

main:
    mov al, 0x13
    int 0x10

    push 0xa000
    pop  es

frame:
    mov cx, 16*3
    mov dx, 3C8h
    xor al, al
    out dx, al
    inc dx
palette:
    out dx, al
    inc al
    loop palette

frame_loop:
    xor di, di
    mov si, 320*200 - 1
    mov cx, 100
y_loop:
    mov dx, 160
x_loop:
    fild word cs:[scale]             ; scale

    fild word cs:[frame]
    fmul dword cs:[x_rot]
    fsin
    fild word cs:[frame]
    fmul dword cs:[y_rot]
    fsin

    mov word cs:[main], cx
    fild word cs:[main]              ; y, scale
    fdiv st0, st3                    ; (y - 100) / 200 = scaled-y, scale

    mov word cs:[main], dx           ;
    fild word cs:[main]              ; x
    fdiv st0, st4                    ; scaled-x, scaled-y, scale

    mov bl, 16
fractal_loop:
    dec  bl
    jz   display_pixel
    fld  st1                         ; i, r, i
    fmul st0                         ; i^2, r, i
    fld  st1                         ; r, i^2, r, i
    fmul st0                         ; r^2, i^2, r, i
    fld  st1
    fadd st1
    fcomp dword cs:[four]
    fnstsw ax

;    fxch st1                         ; should be commented back in, but still looks good without.
    fsubp st1                        ; r^2 - i^2, r, i
    fxch  st2                        ; i, r, r^2 - i^2
    fmulp st1                        ; ri, r^2 - i^2
    fadd  st0, st0                   ; 2ri, x^2 - y^2, sin(r), sin(i), scale
    fsub  st0, st3
    fxch  st1                        ; new r, new i
    fsub  st0, st2

    sahf
    jbe  fractal_loop

display_pixel:
    fstp st0
    fstp st0                     ; unsure why fpu stack needs to be cleared
    fstp st0
    fstp st0
    mov al, bl
    stosb
    mov es:[si], bl
    dec si

    dec dx
    cmp dx, -160
    jg x_loop
    dec cx
    jnz y_loop

    inc word [frame]
    mov bx, word [frame]
    test bl, 15
    jne  no_note

    ; turn off old note -- this isn't the place for endless reverb.
    ; The bytes feel wasted, but the result sounds horrible/even worse without.
    mov dx,0x330        ; port number for MIDI
    mov si, $note_off
    imul ax, bx, 7*4321
    shr ax, 11
    add al, 22
    mov byte cs:[pitch], al
    mov cl, 8
out_loop:
    outsb               ; send MIDI note data
    loop out_loop
    mov byte cs:[old_pitch], al

no_note:
    ; poll for esc key
    in   al,60h
    dec  al
    jnz  frame_loop

    mov ax, 0x0003
    int 0x10

    mov dx, $greets_msg
    mov ah, 9
    int 0x21

    ret

scale:    dw 80
four:     dd 4.001
x_rot:    dd 0.0095
y_rot:    dd 0.0123

note_off: db 0x83
old_pitch: db 66, 0x70
sound: db 0xc3, 38, 0x93               ; 38 = synth bass, 45 = plucked bass
pitch: db 66, 0x70
greets_msg: db 'Demosplash 2023!', 0x0a, '$'