const script = [
    // -------------------- intro dot cube screen --------------------
    {
        type: 'scene',
        name: 'dot cube scene intro',
        start: 0,
        duration: 52,
        enabled: true,
        children: [
            {
                type: 'brightSpot',
                config: {
                    brightness: [
                        [0, 0.0],
                        [72, 0.75],
                    ]
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: [
                        [0, 180],
                        [72, 130]
                    ],
                    fov: 60,
                    lookAt: [
                        [0, [0, 0, 0]],
                    ],
                    rotation: [
                        [0, 90, 'easeOutSine'],
                        [32, 0, 'easeInSine'],
                        [72, 90]
                    ],
                    roll: [
                        [0, 0],
                        [32, 0],
                    ]
                }
            },
            {
                type: 'dotCube',
                config: {
                    width: 7,
                    spacing: 5,
                    brightness: 0.5,
                    dotSize: [
                        [8, 0],
                        [16, 2.0],
                    ],
                    warpPos: [
                        [ 0, [ 4,  9,  -5]],
                        [72, [12, 13, -13]],
                    ]
                },
                syncs: {
                    brightness: [
                        ['kick', 1.5],
                        ['snare', 2.0]
                    ],
                    size: [
                        ['snare', 1.5]
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2
                }
            },
            {
                type: 'zoom',
                enabled: true,
                config: {
                    repeats: 3,
                    zoom: 1.5,
                    blend: [
                        [8, 0],
                        [52, 0.15, 'easeInSine'],
                    ],
                }
            },
            {
                type: 'noise',
                config: {
                    strength: 0.25,
                    mode: 'additive'
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 1
                }
            },
            {
                type: 'overlay',
                enabled: false,
                config: {
                    source: 'shadowlay',
                    alpha: 0.5
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    mode: 'multiply',
                    alpha: [
                        [0, 1, 'easeOutSine'],
                        [8, 0],
                        [48, 0, 'easeOutSine'],
                        [52, 1],
                    ]
                }
            }
        ]
    },
    // -------------------- start of all-scenes wrapper --------------------
    {
        type: 'scene',
        name: 'all-scenes wrapper',
        start: 0,
        duration: 424,
        config: {
            time: [
                [0, 0],
                [340, 340, 'easeInOutSine'],
                [424, 52]
            ]
        },
        children: [
    // -------------------- short dust scene --------------------
    {
        type: 'scene',
        name: 'dust scene',
        start: 52,
        duration: 12,
        enabled: true,
        config: {
            time: [
                [0, 0],
                [12, 12],
            ],
        },
        children: [
            {
                type: 'brightSpot',
                config: {
                    brightness: [
                        [0, 0.5],
                        [16, 1.5],
                        [32, 1.5],
                        [48, 0.5],
                        [64, 1.2],
                    ],
                    offset: [
                        [0, [-0.25, 0]],
                        [52, [0.25, 0]]
                    ]
                }
            },
            {
                type: 'dust',
                config: {
                    texture: 'ball',
                    amount: [
                        [0, 0.5],
                    ],
                    position: [
                        [0, [0, 0]],
                        [52, [-500, 100]],
                    ],
                    brightness: 0.75,
                    size: [
                        [ 0, 1.3],
                        [ 4, 1.0],
                        [ 8, 0.6],
                        [16, 1.2],
                        [20, 0.5],
                        [24, 0.8],
                        [28, 0.5],
                        [32, 1.1],
                        [36, 0.9],
                        [40, 1.5],
                        [44, 1.1],
                        [48, 0.2],
                        [52, 1.2],
                    ],
                    wobble: [
                        [0, 0],
                        [52, 5],
                    ]
                },
                syncs: {
                    size: [
                        ['snare', 1.2]
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2
                }
            },
            {
                type: 'zoom',
                config: {
                    repeats: 7,
                    zoom: 1.1,
                    blend: 0.125,
                    offset: [
                        [0, [-0.0125, 0]],
                        [52, [0.0125, 0]]
                    ]
                }
            },
            {
                type: 'noise',
                config: {
                    strength: 0.25,
                    mode: 'additive'
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 1
                }
            },
            {
                type: 'distort',
                name: 'rewind distort',
                config: {
                    distortTime: [
                        [0, 0],
                        [100, 100],
                    ],
                    distance: 20,
                    magnetDistance: 200,
                    brightness: 0.5,
                    strength: 1.0
                },
                syncs: {
                    strength: [
                        ['!rewind', 0]
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 0
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    mode: 'multiply',
                    alpha: [
                        [0, 1, 'easeInSine'],
                        [2, 0],
                        [10, 0, 'easeOutSine'],
                        [12, 1],
                    ]
                }
            }
        ]
    },
    // -------------------- dot grid screen --------------------
    {
        type: 'scene',
        name: 'dot grid scene',
        start: 64,
        duration: 12,
        enabled: true,
        children: [
            {
                type: 'clear',
                config: {
                    value: 0.0
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: 100,
                    fov: 110,
                    lookAt: [
                        [0, [3, 0, 0]],
                        [66, [0, 2, 0]],
                    ],
                    rotation: [
                        [0, 90],
                        [66, 0]
                    ],
                    roll: [
                        [0, 20],
                        [66, -100],
                    ]
                }
            },
            {
                type: 'dotCube',
                config: {
                    width: 10,
                    spacing: 8,
                    brightness: 0.25,
                    dotSize: 0.5,
                    warpPos: [
                        [ 0, [ 1,  3,  5]],
                        [66, [10, -3,  2]],
                    ]
                },
                syncs: {
                    brightness: [
                        ['kick', 1.5],
                        ['snare', 2.0]
                    ],
                    dotSize: [
                        ['snare', 1.125]
                    ]
                }
            },
            {
                type: 'zoom',
                config: {
                    repeats: 9,
                    zoom: 1.5,
                    blend: [
                        [0, 0.0],
                        [10, 0.25],
                    ],
                    offset: [0.0, 0.1]
                }
            },
            {
                type: 'noise',
                config: {
                    strength: 0.25,
                    mode: 'additive'
                }
            },
            {
                type: 'distort',
                name: 'rewind distort',
                config: {
                    distortTime: [
                        [0, 0],
                        [100, 100],
                    ],
                    distance: 20,
                    magnetDistance: 200,
                    brightness: 0.5,
                    strength: 1.0
                },
                syncs: {
                    strength: [
                        ['!rewind', 0]
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 0
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    mode: 'multiply',
                    alpha: [
                        [0, 1, 'easeInSine'],
                        [4, 0],
                        [10, 0, 'easeOutSine'],
                        [12, 1],
                    ]
                }
            }
        ]
    },
    // -------------------- tunnel scene --------------------
    {
        type: 'scene',
        name: 'tunnel scene',
        start: 76,
        duration: 48,
        enabled: true,
        children: [
            {
                type: 'orbitCam',
                config: {
                    distance: [
                        [0, 100],
                        [11, 100],
                        [12, 200],
                        [13, 100],
                        [24, 200],
                        // this feels like accelerating
                        [48, 30],
                    ],
                    fov: [
                        [0, 110],
                        [11, 110],
                        // oh wow hey wat?
                        [12, 30],
                        [13, 110],
                        [40, 110],
                        [48, 30],
                    ],
                    lookAt: [
                        [0, [2, 0, 0], 'easeInOutSine'],
                        [8, [0, 2, 0], 'easeInOutSine'],
                        [16, [0.5, -.5, 0], 'easeInOutSine'],
                        [20, [0.5, -.5, 0], 'easeInOutSine'],
                        [24, [-2, .5, 0], 'easeInOutSine'],
                        [28, [0, 0, 0], 'easeInOutSine'],
                        [32, [0, 0, 0], 'easeInOutSine'],
                        [36, [-2, -2.5, -10]],
                        [48, [0, 0, 0]],
                    ],
                }
            },
            {
                type: 'tunnel',
                config: {
                    texture: 'square',
                    roll: [
                        [8, 0, 'easeInOutSine'],
                        [48, 450]
                    ],
                    distance: [
                        [0, 0],
                        [48, 3500]
                    ],
                    brightness: 0.01
                },
                syncs: {
                    brightness: [
                        ['kick', 2]
                    ]
                }
            },
            {
                type: 'distort',
                config: {
                    distortTime: [
                        [0, 0],
                        [48, 100],
                    ],
                    distance: 40,
                    brightness: 0.5,
                    strength: 0.1
                },
                syncs: {
                    strength: [
                        ['distort', 10],
                        ['distort2', 20],
                        ['distort3', 30]
                    ],
                }
            },
            {
                type: 'distort',
                name: 'rewind distort',
                config: {
                    distortTime: [
                        [0, 0],
                        [100, 100],
                    ],
                    distance: 20,
                    magnetDistance: 200,
                    brightness: 0.5,
                    strength: 1.0
                },
                syncs: {
                    strength: [
                        ['!rewind', 0]
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 1
                }
            },
            {
                type: 'overlay',
                name: 'circles',
                config: {
                    source: [
                      [0, ''],
                      [28, 'circle1'],
                      [28.2, 'circle2'],
                      [28.4, 'circle3'],
                      [28.6, 'circle4'], 
                      [28.8, 'circle5'],
                      [29, ''],
                      [29.2, 'circle4'],
                      [29.4, 'circle3'],
                      [29.6, 'circle2'],
                      [29.8, 'circle1'],
                      [30, ''],
                    ],
                    alpha: [
                      [0, 0],
                      [28, 0.2],
                      [28.2, .6],
                      [28.4, 1],
                      [29.4, .8],
                      [29.6, .6],
                      [29.8, .4],
                      [30, 0],
                  ],
                }
            },

            // credits evilpaul
            {
                type: 'overlay',
                name: 'evilpaul logos',
                start: 12,
                duration: 5,
                config: {
                    source: [
                        [0.00, 'ninjaverlays/evilpaul-1'],
                        [0.75, 'ninjaverlays/evilpaul-2'],
                        [1.50, 'ninjaverlays/evilpaul-3'],
                        [2.00, 'ninjaverlays/evilpaul-4'],
                        [5, ''],
                    ],
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },
            {
                type: 'overlay',
                start: 16.5,
                duration: 1,
                config: {
                    source: 'white',
                    alpha: [
                        [0, 1],
                        [1, 0],
                    ]
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },
            {
                type: 'overlay',
                start: 16.5,
                duration: 1,
                config: {
                    source: 'ninjaverlays/cut-paul',
                    position: [
                        [0, [480, -80]],
                        [.1, [0, 0]],
                    ],
                    alpha: [
                        [0, 1],
                        [.2, 0],
                    ]
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },
            {
                type: 'overlay',
                start: 17,
                duration: 8,
                config: {
                    source: 'ninjaverlays/evilpaul-slice-1',
                    position: [
                        [0, [-12, 1]],
                        [0.95, [-12, 1]],
                        [12, [-120, 20], 'easeInSine'],
                    ],
                    OLDposition: [
                        [0, [-15, 3]],
                        [0.95, [-15, 3], 'easeInSine'],
                        [12, [-240, 34]],
                    ],
                    alpha: [
                        [0, 1, 'easeOutSine'],
                        [8, 0]
                    ]
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },
            {
                type: 'overlay',
                start: 17,
                duration: 8,
                config: {
                    source: 'ninjaverlays/evilpaul-slice-2',
                    position: [0, 0],
                    alpha: [
                        [0, 1, 'easeOutSine'],
                        [8, 0]
                    ]
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },

            // credits kaneel
            {
                type: 'overlay',
                name: 'kaneel logos',
                start: 24,
                duration: 5,
                config: {
                    source: [
                        [0.00, 'ninjaverlays/kaneel-1'],
                        [0.75, 'ninjaverlays/kaneel-2'],
                        [1.50, 'ninjaverlays/kaneel-3'],
                        [2.00, 'ninjaverlays/kaneel-4'],
                        [5, ''],
                    ],
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },
            {
                type: 'overlay',
                start: 28.5,
                duration: 1,
                config: {
                    source: 'white',
                    alpha: [
                        [0, 1],
                        [1, 0],
                    ]
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },
            {
                type: 'overlay',
                start: 28.5,
                duration: 1,
                config: {
                    source: 'ninjaverlays/cut-kaneel',
                    position: [
                        [0, [-500, -106]],
                        [.1, [0, 0]],
                    ],
                    alpha: [
                        [0, 1],
                        [.2, 0],
                    ]
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },
            {
                type: 'overlay',
                start: 29,
                duration: 8,
                config: {
                    source: 'ninjaverlays/kaneel-slice-1',
                    position: [
                        [0, [15, 3]],
                        [0.95, [15, 3]],
                        [12, [120, 22], 'easeInSine'],
                    ],
                    alpha: [
                        [0, 1, 'easeOutSine'],
                        [8, 0]
                    ]
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },
            {
                type: 'overlay',
                start: 29,
                duration: 8,
                config: {
                    source: 'ninjaverlays/kaneel-slice-2',
                    position: [0, 0],
                    alpha: [
                        [0, 1, 'easeOutSine'],
                        [8, 0]
                    ]
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },
 
            {
                type: 'overlay',
                name: 'fade',
                config: {
                    source: 'black',
                    mode: 'multiply',
                    alpha: [
                        [0, 0, 'easeInSine'],
                        [2, 0],
                        [46, 0, 'easeOutSine'],
                        [48, 1],
                    ]
                }
            }
        ]
    },
    // -------------------- cube scene --------------------
    {
        type: 'scene',
        name: 'cube scene',
        start: 124,
        duration: 48,
        enabled: true,
        children: [
            {
                type: 'cube',
                config: {
                    texture: 'border',
                    brightness: 0.9,
                    scale: [
                        [0.00, [0, 0, 0], 'easeInSine'],
                        [1.75, [1, 1, 1]],
                        [6.75, [1, 1, 1], 'easeInSine'],
                        [7.75, [1, 1, 2]],
                        [12.75, [1, 1, 2], 'easeInSine'],
                        [13.75, [1, 2, 2]],
                        [18.75, [1, 2, 2], 'easeInSine'],
                        [19.75, [2, 2, 2]],
                        [24.00, [2, 2, 2], 'easeInSine'],
                        [26.00, [0.25, 0.25, 0.25]],
                        [30.75, [0.25, 0.25, 0.25], 'easeInSine'],
                        [31.75, [0.25, 0.25, 1]],
                        [36.00, [0.25, 0.25, 1], 'easeInSine'],
                        [39.00, [1, 2, 1]],
                        [42.75, [1, 2, 1], 'easeInSine'],
                        [43.75, [3, 3, 3]],
                    ],
                    fov: [
                        [44, 30],
                        [48, 20]
                    ],
                    roll: [
                        [0, 0],
                    ],
                    pitch: [
                        [0, 321, 'easeOutSine'],
                        [8, 520, 'easeOutSine'],
                        [16, 432, 'easeOutSine'],
                        [24, 220, 'easeOutSine'],
                        [32, 343, 'easeOutSine'],
                        [40, 120, 'easeOutSine'],
                        [48, 250, 'easeOutSine'],
                    ],
                    roll: [
                        [0, 0],
                        [48, -110],
                    ],
                },
                syncs: {
                    brightness: [
                        ['kick', 1.5],
                    ],
                    fov: [
                        ['snare', 1.05]
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2
                }
            },
            {
                type: 'noise',
                enabled: true,
                config: {
                    strength: 0.2,
                    mode: 'additive'
                }
            },
            {
                type: 'distort',
                name: 'rewind distort',
                config: {
                    distortTime: [
                        [0, 0],
                        [100, 100],
                    ],
                    distance: 20,
                    magnetDistance: 200,
                    brightness: 0.5,
                    strength: 1.0
                },
                syncs: {
                    strength: [
                        ['!rewind', 0]
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 0
                }
            },
            {
                type: 'overlay',
                enabled: true,
                config: {
                    source: 'shadowlay',
                    alpha: [
                        [0, .5, 'easeInOutSine'],
                        [24, .8, 'easeInOutSine'],
                        [26, 1, 'easeInOutSine'],
                        [48, 0, 'easeInOutSine']
                    ]
                },
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    mode: 'multiply',
                    alpha: [
                        [0, 1, 'easeInSine'],
                        [1, 0],
                        [46, 0, 'easeOutSine'],
                        [48, 1],
                    ]
                }
            }
        ]
    },
    // -------------------- short dust scene --------------------
    {
        type: 'scene',
        name: 'dust scene',
        start: 172,
        duration: 12,
        enabled: true,
        config: {
            time: [
                [0, 12],
                [12, 24],
            ],
        },
        children: [
            {
                type: 'brightSpot',
                config: {
                    brightness: [
                        [0, 0.5],
                        [16, 1.5],
                        [32, 1.5],
                        [48, 0.5],
                        [64, 1.2],
                    ],
                    offset: [
                        [0, [-0.25, 0]],
                        [52, [0.25, 0]]
                    ]
                }
            },
            {
                type: 'dust',
                config: {
                    texture: 'ball',
                    amount: [
                        [0, 0.5],
                    ],
                    position: [
                        [0, [0, 0]],
                        [52, [-500, 100]],
                    ],
                    brightness: 0.75,
                    size: [
                        [ 0, 1.3],
                        [ 4, 1.0],
                        [ 8, 0.6],
                        [16, 1.2],
                        [20, 0.5],
                        [24, 0.8],
                        [28, 0.5],
                        [32, 1.1],
                        [36, 0.9],
                        [40, 1.5],
                        [44, 1.1],
                        [48, 0.2],
                        [52, 1.2],
                    ],
                    wobble: [
                        [0, 0],
                        [52, 5],
                    ]
                },
                syncs: {
                    size: [
                        ['snare', 1.2]
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2
                }
            },
            {
                type: 'zoom',
                config: {
                    repeats: 7,
                    zoom: 1.1,
                    blend: 0.125,
                    offset: [
                        [0, [-0.0125, 0]],
                        [52, [0.0125, 0]]
                    ]
                }
            },
            {
                type: 'noise',
                config: {
                    strength: 0.25,
                    mode: 'additive'
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 1
                }
            },
            {
                type: 'distort',
                name: 'rewind distort',
                config: {
                    distortTime: [
                        [0, 0],
                        [100, 100],
                    ],
                    distance: 20,
                    magnetDistance: 200,
                    brightness: 0.5,
                    strength: 1.0
                },
                syncs: {
                    strength: [
                        ['!rewind', 0]
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 0
                }
            },
            { 
                type: "overlay",
                config: {
                    source: 'mikucom-mask',
                    alpha: 1
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    mode: 'multiply',
                    alpha: [
                        [12, 1, 'easeInSine'],
                        [14, 0],
                        [22, 0, 'easeOutSine'],
                        [24, 1],
                    ]
                }
            }
        ]
    },
    // -------------------- dot sphere scene --------------------
    {
        type: 'scene',
        name: 'dot cube scene',
        start: 184,
        duration: 48,
        enabled: true,
        children: [
            {
                type: 'noise',
                config: {
                    strength: 0.2,
                    mode: 'absolute'
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: [
                        [0, 50],
                        [6, 50, 'easeInOutSine'],
                        [7, 90],
                        [48, 120],
                    ],
                    fov: 80,
                    lookAt: [
                        [ 0, [ 5, -2, 0], 'easeOutSine'],
                        [12, [-3,  1, 0], 'easeOutSine'],
                        [16, [-4,  5, 0], 'easeOutSine'],
                        [20, [-9, 12, 0], 'easeOutSine'],
                        [24, [ 1,  3, 0], 'easeOutSine'],
                        [28, [-3, -9, 0], 'easeOutSine'],
                        [32, [ 7,  2, 0], 'easeOutSine'],
                        [36, [ -7,  2, 0], 'easeOutSine'],
                        [40, [ 7,  2, 0], 'easeOutSine'],
                        [44, [ 0, -3, 0], 'easeOutSine'],
                        [48, [ 2, -2, 0], 'easeOutSine'],
                    ],
                    rotation: [
                        [ 0,  20, 'easeOutSine'],
                        [12,  70, 'easeOutSine'],
                        [16, 120, 'easeOutSine'],
                        [20,  20, 'easeOutSine'],
                        [24,  40, 'easeOutSine'],
                        [28, -30, 'easeOutSine'],
                        [32, -90, 'easeOutSine'],
                        [36, -30, 'easeOutSine'],
                        [40,  30, 'easeOutSine'],
                        [44,  70, 'easeOutSine'],
                        [48,  60, 'easeOutSine'],
                    ],
                    roll: [
                        [ 0,  60, 'easeOutSine'],
                        [12, -10, 'easeOutSine'],
                        [16, -70, 'easeOutSine'],
                        [20, -20, 'easeOutSine'],
                        [24, -70, 'easeOutSine'],
                        [28,  30, 'easeOutSine'],
                        [32, 120, 'easeOutSine'],
                        [36, -50, 'easeOutSine'],
                        [40, -90, 'easeOutSine'],
                        [44,  20, 'easeOutSine'],
                        [48, 120, 'easeOutSine'],
                    ]
                }
            },
            {
                type: 'dotSphere',
                config: {
                    texture: 'hoop',
                    brightness: 1,
                    spriteSize: 6.0,
                    innerSize: 50,
                    offsetSize: [
                        [0, 0],
                        [48, 20],
                    ],
                    offsetPosition: [
                        [0, 0],
                        [48, 25],
                    ]
                },
                syncs: {
                    brightness: [
                        ['kick', 1.5]
                    ],
                }
            },
            {
                type: 'zoom',
                config: {
                    repeats: 4,
                    zoom: 1.25,
                    blend: [
                        [06, 0.05],
                        [06, 0.45, 'easeInSine'],
                        [08, 0.05],
                        [08, 0.30, 'easeInSine'],
                        [10, 0.05],
                        [10, 0.15, 'easeInSine'],
                        [12, 0.05],

                        [18, 0.05],
                        [18, 0.30, 'easeInSine'],
                        [20, 0.05],
                        [20, 0.20, 'easeInSine'],
                        [22, 0.05],
                        [22, 0.10, 'easeInSine'],
                        [24, 0.05],

                        [30, 0.05],
                        [30, 0.60, 'easeInSine'],
                        [32, 0.05],
                        [32, 0.40, 'easeInSine'],
                        [34, 0.05],
                        [34, 0.20, 'easeInSine'],
                        [36, 0.05],

                        [42, 0.05],
                        [42, 0.30, 'easeInSine'],
                        [44, 0.05],
                        [44, 0.20, 'easeInSine'],
                        [46, 0.05],
                        [46, 0.10, 'easeInSine'],
                        [48, 0.05],
                    ],
                    offset: [0.0, 0.0]
                }
            },
            {
                type: 'distort',
                name: 'rewind distort',
                config: {
                    distortTime: [
                        [0, 0],
                        [100, 100],
                    ],
                    distance: 20,
                    magnetDistance: 200,
                    brightness: 0.5,
                    strength: 1.0
                },
                syncs: {
                    strength: [
                        ['!rewind', 0]
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 1
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'lines',
                    alpha: [
                        [6, 0, 'easeInSine'],
                        [7, 1]
                    ]
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    mode: 'multiply',
                    alpha: [
                        [47, 0, 'easeOutSine'],
                        [48, 1],
                    ]
                }
            }
        ]
    },
    // -------------------- short dust scene --------------------
    {
        type: 'scene',
        name: 'dust scene',
        start: 232,
        duration: 12,
        enabled: true,
        config: {
            time: [
                [0, 24],
                [12, 36],
            ],
        },
        children: [
            {
                type: 'brightSpot',
                config: {
                    brightness: [
                        [0, 0.5],
                        [16, 1.5],
                        [32, 1.5],
                        [48, 0.5],
                        [64, 1.2],
                    ],
                    offset: [
                        [0, [-0.25, 0]],
                        [52, [0.25, 0]]
                    ]
                }
            },
            {
                type: 'dust',
                config: {
                    texture: 'ball',
                    amount: [
                        [0, 0.5],
                    ],
                    position: [
                        [0, [0, 0]],
                        [52, [-500, 100]],
                    ],
                    brightness: [
                        [34, 0.75],
                        [36, 1.2],
                    ],
                    size: [
                        [24, 1.2],
                        [30, 2],
                        [31, 1.5],
                        [31.5, 1.2],
                        [32, 1],
                        [32.2, 0.8],
                        [32.4, 0.6],
                        [32.6, 0.4],
                        [33, 0.2],
                        [34, 0.1]
                    ],
                    wobble: [
                        [0, 0],
                        [52, 5],
                    ]
                },
                syncs: {
                    size: [
                        ['snare', 1.2]
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2
                }
            },
            {
                type: 'zoom',
                config: {
                    repeats: 7,
                    zoom: 1.1,
                    blend: 0.125,
                    offset: [
                        [0, [-0.0125, 0]],
                        [52, [0.0125, 0]]
                    ]
                }
            },
            {
                type: 'noise',
                config: {
                    strength: 0.25,
                    mode: 'additive'
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 1
                }
            },
            {
                type: 'distort',
                name: 'rewind distort',
                config: {
                    distortTime: [
                        [0, 0],
                        [100, 100],
                    ],
                    distance: 20,
                    magnetDistance: 200,
                    brightness: 0.5,
                    strength: 1.0
                },
                syncs: {
                    strength: [
                        ['!rewind', 0]
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 0
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'greets-before-overlay',
                    alpha: [
                        [24, 0],
                        [26, 1]
                    ]
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },
            {
                type: 'overlay',
                config: {
                    source: [
                        [24, ''],
                        [25, 'greets-before-text1'],
                        [26, 'greets-before-text2'],
                        [27, 'greets-before-text3'],
                        [28, 'greets-before-text4'],
                        [29, 'greets-before-text5'],
                        [30, 'greets-before-text6'],
                        [31, 'greets-before-text7'],
                        [32, 'greets-before-text8'],
                        [32.5, 'greets-before-text9'],
                        [33, 'greets-before-text10'],
                        [33.2, 'greets-before-text10'],
                        [33.4, 'greets-before-text11'],
                        [33.6, 'greets-before-text12']
                    ]
                },
                syncs: {
                    alpha: [
                        ['rewind', 0]
                    ]
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    mode: 'multiply',
                    alpha: [
                        [24, 1, 'easeInSine'],
                        [25, 0],
                        [34, 0, 'easeOutSine'],
                        [36, 1],
                    ]
                }
            }
        ]
    },
    // -------------------- greets scene --------------------
    {
        type: 'scene',
        name: 'greets scene',
        start: 244,
        duration: 48,
        children: [
            {
                type: 'greets',
                config: {
                    plasmaBase: -200, // base depth of the plasma
                    plasmaRange: 200, // depth range of the plasma
                    plasmaSteps: 30, // number of steps in the plasma
                    lightBase: [320, 240, 320], // base position of light
                    lightRange: [150, 120, 30], // range of the light's movement
                    lightFallOff: 500, // falloff
                    lightBrightness: 1.2, // light brightness
                    lightCap: 0.90, // artificially caps max strength of light
                    cycleSpeed: 0.4, // how quickly each greets is shown
                    displaySpeed: 1, // how quickly each greet appears/disappears
                    startDelay: 2, // delay before texts come in
                    textBase: -400, // base depth of the text
                    textRange: 200, // how far the text moves forwards as it appears
                    textHeight: 200, // height of the text embossing effect
                },
                syncs: {
                    brightness: [
                        ['snare', 1.1],
                    ],
                }
            },
            {
                type: 'blur',
                passes: 1,
                syncs: {
                    passes: [
                        ['distort', 10],
                        ['distort2', 15],
                        ['distort3', 20],
                    ],
                }
            },
            {
                type: 'noise',
                config: {
                    strength: 0.125,
                    mode: 'additive'
                },
                syncs: {
                    strength: [
                        ['snare', 2],
                    ],
                }
            },
            {
                type: 'distort',
                name: 'rewind distort',
                config: {
                    distortTime: [
                        [0, 0],
                        [100, 100],
                    ],
                    distance: 20,
                    magnetDistance: 200,
                    brightness: 0.5,
                    strength: 1.0
                },
                syncs: {
                    strength: [
                        ['!rewind', 0]
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 1
                }
            },
            {
                type: 'overlay',
                enabled: false,
                config: {
                    source: 'shadowlay',
                    alpha: 1.0
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    mode: 'multiply',
                    alpha: [
                        [47, 0, 'easeOutSine'],
                        [48, 1],
                    ]
                }
            }
        ]
    },
    // -------------------- tendrils scene --------------------
    {
        type: 'scene',
        name: 'tendrils scene',
        start: 292,
        duration: 48,
        enabled: true,
        children: [
            {
                type: 'brightSpot',
                config: {
                    brightness: [
                        [7.5, 0.5, 'easeInSine'],
                        [8, 4, 'easeOutSine'],
                        [13, 0.5],

                        [23.5, 0.5, 'easeInSine'],
                        [24, 4, 'easeOutSine'],
                        [29, 0.5],

                        [34.5, 0.5, 'easeInSine'],
                        [35, 4, 'easeOutSine'],
                        [40, 0.5],
                    ]
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: [
                        [0, 1, 'easeOutSine'],
                        [2, 50],
                        [40, 120],
                        [48, 100],
                    ],
                    fov: 80,
                    lookAt: [
                        [0.00, [ 5, -2, 0], 'easeOutSine'],
                        [12.75, [ 1,  2, 0], 'easeOutSine'],
                        [20.00, [ 2, -5, 0], 'easeOutSine'],
                        [24.00, [-3,  1, 0], 'easeOutSine'],
                        [35.50, [-4,  5, 0], 'easeOutSine'],
                        [38.00, [-9, 12, 0], 'easeOutSine'],
                        [48.00, [ 1,  3, 0], 'easeOutSine'],
                    ],
                    rotation: [
                        [  0.00,  120, 'easeOutSine'],
                        [ 12.75, -120, 'easeOutSine'],
                        [ 20.00,   90, 'easeOutSine'],
                        [ 24.00,    0, 'easeOutSine'],
                        [ 35.50,  140, 'easeOutSine'],
                        [ 38.00,  -40, 'easeOutSine'],
                        [ 48.00,  110, 'easeOutSine'],
                    ],
                    roll: [
                        [  0.00,   60, 'easeOutSine'],
                        [ 12.75,  120, 'easeOutSine'],
                        [ 20.00,  -90, 'easeOutSine'],
                        [ 24.00,   30, 'easeOutSine'],
                        [ 35.50,   90, 'easeOutSine'],
                        [ 38.00,  -50, 'easeOutSine'],
                        [ 48.00,  100, 'easeOutSine'],
                    ]
                }
            },
            {
                type: 'tendrils',
                config: {
                    texture: 'ball',
                    brightness: [
                        [0, 20, 'easeOutSine'],
                        [3, 0.125],

                        [12.75, 0.125],
                        [12.75, 5, 'easeOutSine'],
                        [15.75, 0.125],

                        [20.00, 0.125],
                        [20.00, 20, 'easeOutSine'],
                        [23.00, 0.125],

                        [24.00, 0.125],
                        [24.00, 20, 'easeOutSine'],
                        [27.00, 0.125],

                        [35.00, 0.125],
                        [36.00, 1, 'easeOutSine'],
                        [39.00, 0.125],

                        [42.00, 0.125],
                        [46.00, 1],
                        [48.00, 0],
                    ],
                    size: 1,
                    pulsePosition: [
                        [0, 0],
                        [48, 100],
                    ],
                    pulseSize: [
                        [0.00, 2, 'easeOutSine'],
                        [1.00, 0],

                        [10.75, 0, 'easeInSine'],
                        [12.75, 2, 'easeOutSine'],
                        [13.75, 0],

                        [18.75, 0, 'easeInSine'],
                        [20.75, 2, 'easeOutSine'],
                        [21.75, 0],

                        [22.00, 0, 'easeInSine'],
                        [24.00, 2, 'easeOutSine'],
                        [25.00, 0],

                        [36.00, 0],
                        [36.00, 2, 'easeOutSine'],
                        [39.00, 0],

                        [42.00, 0, 'easeOutSine'],
                        [48.00, 1]
                    ]
                },
                syncs: {
                    brightness: [
                        ['snare', 1.5]
                    ],
                    pulseSize: [
                        ['snare', 2]
                    ]
                }
            },
            {
                type: 'distort',
                config: {
                    distortTime: [
                        [0, 0],
                        [48, 248],
                    ],
                    distance: 30,
                    brightness: 0.5,
                    strength: [
                        [12, 0],
                        [12, 1],
                        [14, 1],
                        [14.5, 0],

                        [30, 0],
                        [30, 1],
                        [31, 1],
                        [31.5, 0],

                        [35.5, 0],
                        [36, 10],
                        [37, 2],
                        [37.5, 0],
                    ]
                }
            },
            {
                type: 'noise',
                config: {
                    strength: 0.125,
                    mode: 'additive'
                }
            },
            {
                type: 'zoom',
                config: {
                    repeats: 2,
                    zoom: 1.75,
                    blend: 0.15,
                    offset: [0.0, 0.0]
                }
            },
            {
                type: 'distort',
                name: 'rewind distort',
                config: {
                    distortTime: [
                        [0, 0],
                        [100, 100],
                    ],
                    distance: 20,
                    magnetDistance: 200,
                    brightness: 0.5,
                    strength: 1.0
                },
                syncs: {
                    strength: [
                        ['!rewind', 0]
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 2
                }
            }
        ]
    },

    // -------------------- end of all-scenes wrapper --------------------
        ]
    },
    { 
        type: "overlay",
        start: 340,
        duration: 84,
        config: {
            source: 'shadowlay',
            alpha: [
                [0, 0],
                [2, .25],
                [78, .25],
                [82, 0],
            ]
        },
    },
    { 
        type: "overlay",
        start: 340,
        duration: 84,
        config: {
            source: 'mikucomsat',
            alpha: [
                [0, 0],
                [2, 1],
                [78, 1],
                [82, 0],
            ]
        },
    },
    { 
        type: "overlay",
        start: 340,
        duration: 84,
        config: {
            sources: ['rewind', ''],
            alpha: [
                [0, 0],
                [2, 1],
                [78, 1],
                [82, 0],
            ]
        }
    },
    // -------------------- outro dot cube screen --------------------
    {
        type: 'scene',
        name: 'dot cube scene outro',
        start: 424,
        duration: 50,
        enabled: true,
        children: [
            {
                type: 'brightSpot',
                config: {
                    brightness: [
                        [0, 0.75],
                        [48, 0.0],
                    ]
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: [
                        [0, 130],
                        [52, 180],
                    ],
                    fov: 60,
                    lookAt: [0, 0, 0],
                    rotation: [
                        [0, 90, 'easeOutSine'],
                        [50, 0]
                    ],
                }
            },
            {
                type: 'dotCube',
                config: {
                    width: 8,
                    spacing: 5,
                    brightness: 0.5,
                    dotSize: [
                        [0, 0],
                        [8, 2.0],
                    ],
                    warpPos: [
                        [0, [ 4,  9,  -5]],
                        [50, [12, 13, -13]],
                    ]
                },
                syncs: {
                    brightness: [
                        ['kick', 1.5],
                        ['snare', 2.0]
                    ],
                    size: [
                        ['snare', 1.5]
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2
                }
            },
            {
                type: 'zoom',
                enabled: true,
                config: {
                    repeats: 3,
                    zoom: 1.5,
                    blend: [
                        [0, 0.125],
                        [44, 0],
                    ],
                }
            },
            {
                type: 'noise',
                config: {
                    strength: 0.125,
                    mode: 'additive'
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 1
                }
            },
            {
                type: 'overlay',
                enabled: false,
                config: {
                    source: 'shadowlay',
                    alpha: 0.5
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    mode: 'multiply',
                    alpha: [
                        [0, 1, 'easeInSine'],
                        [12, 0],
                        [44, 0, 'easeInSine'],
                        [50, 1],
                    ]
                }
            }
        ]
    },
    // -------------------- gradient test scene --------------------
    {
        type: 'scene',
        name: 'gradient test scene',
        start: 999,
        duration: 48,
        enabled: false,
        children: [
            {
                type: 'clear',
                config: {
                    value: 1.0
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 2
                }
            },
        ]
    },
    // -------------------- music part name overlays --------------------
    {
        type: 'debugText',
        name: 'music part name overlays',
        enabled: false,
        config: {
            text: [
                [0, 'intro'],
                [76, 'pre'],
                [124, 'part'],
                [172, 'break'],
                [184, 'bridge'],
                [244, 'second part'],
                [340, 'break outro'],
                [352, 'mad outro'],
                [424, 'back to the beginning'],
            ]
        }
    }
]
