; pestis 32b:
; - reuse cl as width; doing the loop 52 times does not matter


org 100h
    mov     al, 0x13            ; Setup video mode
    int     0x10
    push    0xa000 - 2          ; Video segment (slightly shifted)
    pop     es
M:  mov     ax, 0xCCCD + 0x105  ; On first round, skew Rrrola trick to left
    mov     cl, 52
L:  mul     di                  ; Rrrola trick
    cmp     dl, cl              ; If (skewed) x is less than line width
    jb      S                   ; ...then jump to setting white pixel
    mov     ax, 0xCCCD - 0x105  ; On following round(s), skew right
    loop    L
    mov     al, 1               ; Otherwise, pixel is blue
    db      0x3D                ; (skip following instruction, this is some cmp)
S:  mov     al, 15
    stosb                       ; Put pixel on screen
    jmp     M
