; Hellmood 24b:
; - les ax, [bx] sets up segment AND puts 0xCD to al
; - compute color depending on carry when loop is exited
; - sbb al compiles to 0x1C = 28, use that as width [si]
org 100h
    sbb     al, -0x13           ; sbb al compiles to 0x1C = 28
    int     0x10
M:  mov     ax, 0xCBCD          ; On first round, skew Rrrola trick to right
L:  mul     di                  ; Rrrola trick
    les     ax, [bx]            ; Video segment (slightly shifted)
    mov     ah, 0xCD            ; On following round(s), skew left
    cmp     dl, [si]            ; If (skewed) x is less than line width
    jb      S                   ; ...then jump to setting white pixel
    loop    L
S:  sbb     al, -32 + 0xCD      ; carry 1 => 31, carry 0 => 32
    stosb                       ; Put pixel on screen
    jmp     M
