#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform float time = 1.0;
uniform vec4 color = vec4(1,1,1,1);

uniform float fade = 1.0;

vec2 pixelate(vec2 coord)
{
    vec2 d = vec2(1.0,1.0)/(vec2(1920.0,1080.0)*0.02);
    coord.s = floor(coord.s/d.s)*d.s;
    coord.t = floor(coord.t/d.t)*d.t;
    return coord;    
}

void main()
{
	vec2 coord=texCoord;
	coord = pixelate(coord);

	fragColor = texture2D(texture0, coord) * color;
}
