#!/usr/bin/env -S 64tass -o 'tree.prg'

; Copyright (C) 2021 by Krill/Plush

; Permission to use, copy, modify, and/or distribute this software for any
; purpose with or without fee is hereby granted.

; THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
; REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
; AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
; INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
; LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
; OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
; PERFORMANCE OF THIS SOFTWARE.

GOCR  = $aad7
BSOUT = $ffd2

PNTR  = $d3; cursor X position

I     = $02; assumed to be 0 at start
N     = $84; assumed to be $38 at start

            * = $032c ; CLALL vector, executed when closing loaded file

            .word main; entry pointer

loopi       ldx #3    ; initialise tree segment character row counter
            lda #20   ; centre of character row
loopj      ;clc       ; carry is always clear here (subtract one more)
            sbc I     ; calculate horizontal start position
trunk       sta PNTR  ; set cursor horizontal position
            pha       ; buffer horizontal start position
            lda #38   ; approximate right-hand end of character screen
           ;sec       ; carry is always set here
            sbc PNTR  ; calculate horizontal end position
            tay       ; set compare value for horizontal end position
loopk       lda #'*'  ; tree character
            jsr BSOUT ; output to screen
            cpy PNTR  ; end of tree row reached?
            bcs loopk ; branch if not
            jsr GOCR  ; next character row
            pla       ; restore horizontal start position
            dex       ; tree segment done?
            bpl loopj ; if not, branch to next character row in tree segment
            inc I     ; next tree segment
            lda #18   ; trunk horizontal start position
main        lsr N     ; on entry, N = %00111000 for 3 tree segments, then 2 rows trunk, then exit
            bcc loopi ; branch to tree segment 3 times
            bne trunk ; branch to trunk row 2 times, no branch to loopj tree segment output
            rts       ; exit to BASIC prompt. I, N, CLALL, LOAD and SAVE vectors clobbered
