; Vintage Computing Christmas Challenge 2021
; 
; Author: Alanna Kelly (Twitter: @alannakelly_ie)
; System: Commodore 64
; Language used: 6502 Assembly (ACME)
; Length of source code: 67 lines including comments.
; Length of executable: 76 bytes
; Length of executed code: 62 bytes
; How to run: Drag the PRG file into VICE.
!to "vccc2021.prg",cbm
COLUMN=$d3 ; Cursor 
CHROUT=$f1ca
i = $fb
t = $fc
*=$0801
!16 $080c, $000a
!08 $9e,$32,$30,$36,$31,$00
!16 $0000
; Init
outer_loop:
ldx #0
inner_loop:
; Generate Odd Numbers
txa ; A=X
sec
rol ; A=(2*X)+1
; Save A for additions
sta t ; t=A
; Figure out number of stars to draw
ldy i
beq skip  ; if(i==0) goto skip
-         ; for(Y=i;Y>0;--Y) 
sec
adc t ; A+=t+1
dey   ; --Y
bne - ; if(Y!=0) goto -
; Print Some Stars!
skip:
jsr star    ; draw A stars
inx         ; ++X
cpx #4
bne inner_loop    ; if(X!=4) goto inner_loop
dex         ; X=3
inc i       ; i++
cpx i       ; Compare X to i
bne outer_loop     ; if(X!=3) goto outer_loop
; Draw Trunk/Pot
txa         ; A=3
jsr star    ; draw A stars
txa         ; A=3
jsr star    ; draw A stars
rts         ; Back to BASIC
; Subroutine to draw a line of stars
star:
tay         ; Y=A
;Center: 20-A/2
lsr         ; A=A/2
eor #$ff    
adc #20     ; A=(-A)+20
sta COLUMN  ; Set cursor position
-           ; for(Y;Y>0;--Y)
; Print a star
lda #42 
jsr CHROUT
dey         ; --Y
bne -       ; if(Y!=0) goto -
; Print a <CR>
lda #13 
jmp CHROUT ; jmp to avoid an rts