;	Main file to run from 128*8k = 1MB Atarimax cartridge (cartridge type 42).
;
;	@com.wudsn.ide.asm.outputfileextension=.rom

;d:\asm\mads\mads game_ram.s -o:game_ram.dat -hm:game-ram.inc -l:game-ram.lst
;d:\asm\mads\mads game_rom.s -o:game_rom.dat -hm:game-rom.inc -l:game-rom.lst
;so the -hm is like a label file but you can include it in another source file to get the addresses






;
; Code equates
;
	icl "SystemEquates.asm"
;	icl "oxygene_old_blitter.inc"

l1000	= $1000-$0800
l3000	= $3000-$0800
l5000	= $5000-$0800
la000	= $a000
main	= $0800 ;1091 needs to be adapted!!!!

;
; Start of code
;
	opt h-f+
	org $a000

	.proc boot_start

	ldx #$00
loop1	lda rom_start,x
	sta ram_start,x
	inx
	bne loop1
loop2	lda rom_start+$100,x
	sta ram_start+$100,x
	inx
	bne loop2
	jmp ram_start

rom_start

	.proc ram_start,$700

	lda consol
	and #$04
	bne no_coldstart
	sta carctl+$80
	jmp coldsv

no_coldstart
	lda rtclok+2
wait	cmp rtclok+2
	bne wait
	lda #$00
	sta nmien
	sta dmactl
	sei
	ldy #$fe
	sty portb

	sta carctl+1 ;bank 1
	lda #>la000
	sta copy_8k.from+1
	lda #>l1000
	sta copy_8k.to+1
	jsr copy_8k

	sta carctl+2 ;bank 2
	lda #>la000
	sta copy_8k.from+1
	lda #>l3000
	sta copy_8k.to+1
	jsr copy_8k
	sta carctl+$80

;	sta carctl+3 ;bank 3
;	lda #>la000
;	sta copy_8k.from+1
;	lda #>l5000
;	sta copy_8k.to+1
;	jsr copy_8k
;	sta carctl+$80

;	sta carctl+4 ;bank 4
;	lda #>la000
;	sta copy_8k.from+1
;	lda #>l5000
;	sta copy_8k.to+1
;	jsr copy_8k
;	sta carctl+$80

	lda trig3
	sta gintlk
	lda #$00
	sta audctl
	lda #$03
	sta skctl
	jmp main

	.proc copy_8k
	ldy #$20
	ldx #$00
loop
	lda la000,x
from	= *-2
	sta l1000,x
to	= *-2
	inx
	bne loop
	inc from+1
	inc to+1
	dey
	bne loop
	rts
	.endp
  	
  	.endp
  	
  	.endp
  
  	.align $bff4,0
  	org $bff4
cart_init
  	sta carctl
  	jmp la000

  	.word la000
  	.byte $00,$04
  	.word cart_init

	ins "oxygene_old_blitter.xex",+6 ;$1000-$2fff 1 bank + bank 2

:(((*+$3fff)&$1FC00)-*-$1000+$0400) .byte 0	
	ins "old_scene.bin",0,38*8192 ;bank 3
	ins "EmptyCart.bin",0,1048576-358400+5120+256+768+6144+$0800
