;***********************************
; SG8 CHESSBOARD for 256byte 
; lovebyte compo
;
; (c) 2021 Simon Jonassen
; AKA The Invisble Man (DESIRE)
;
; This will run on a coco 1,2,3
; and also Dragon32/64
; (and various brazilian coco clones) 
;
; Free for all, use as you see fit
; just give credit where it's due..
;
;***********************************
	org	$2200
sgtab1	equ	$2300			;page aligned char table (4 bytes)
funky	equ	$2400			;page aligned plotter (gets written below)

start	orcc	#$50			;kill irq's (irq/firq)
	lda	#8
	sta	$ff9c			;coco3 cludge for sg8
	sta	$ffc3			;enable SG8 (64*64) - uses 2048 bytes

	lda	#$22			;DP SETUP FOR SPEED
	tfr	a,dp			;DP is like zeropage on 6502 (except you can move it)
					;DP adressing is 1 cycle faster and 1 byte smaller
					;AS the 6809 *automagically* fills in the MSB for 16bits
;***********************************
; SOME SELFWRITING STUFF
;***********************************
	ldd	#$8f8a			;WRITE SG TABLE 
	std	sgtab1			;these are semigfx characters 
	ldd	#$8580
	std	sgtab1+2
;***********************************
; WRITE FUNK CODE (2 SECTIONS)
; ODD/EVEN (SPACED 128 BYTES APART)
; THIS GOES LIKE THIS:
;
; LDD #NNNN	(our semigfx entries)	;funky+1 will hit the NNNN (eg selfmod)
; STD <0,x	(store to screen word)
; LDD #NNNN	(next semigfx)
; STD <2,x	(store to next word)
; ETC (upto 30,x) - (eg. 32 chars)
;
; this could be made smaller if
; you used 5bit offsets and +/-
;***********************************
	ldx	#funky
	ldy	#$8800			;8 bit offset (prebyte + offset)
	ldb	#$ed			;std instruction (extended)
	lda	#$cc			;LDD #$6060 
	ldu	#$6060			;STD <$nn,x (0,2,4,6,8 etc)
clp	sta	$80,x
	sta	,x+
	stu	$80,x			
	stu	,x++		
	stb	$80,x
	stb	,x+
	sty	$80,x
	sty	,x++	
	leay	2,y
	cmpy	#$881e
	ble	clp
	lda	#$7e			;JMP instruction (cheaper than RTS in this case)
	ldu	#eveny			;address to jump back to
	sta	$80,x
	sta	,x+
	stu	$80,x
	stu	,x
		

yloop
;*******************************	
; center board and zoom using 
; fudge value
;*******************************	
fudge	ldb	#0			;our zoom factor
	bpl	ok			;+ve ?
	negb				;negate - so we go the other way
ok	stb	<yscale+2		;store to fixed point scales
	stb	<xscale+2
	stb	<xsc1+2
	stb	<xsc2+2
	stb	<xsc3+2
;********************************
; CENTER THE BOARD
;********************************
	lda	#64			;64 scanlines/pixels on X (it's square you know)
	mul				;we have B (scale in above code) - so lets MUL and get a 16bit # (fixed point)
	negb				;negate 
	sbca	#0
	lsra				;D reg / 2 to get centerpoint
	rorb
	std	<yscan+1
	std	<xscan+1

	lda	<fudge+1
	suba	#3			;in/out (do our movement (speed))
	sta	<fudge+1

chess	ldx	#funky+1		;adress of our plot routine (written above)
nextx	ldy	#16			;16 words (32bytes) - try and change to 8		
xloop					;you will get half a screen (left half)


;*******************************
;first half
;*******************************
xscan	ldd	#0			; populated by above code
xscale	addd	#0			; xsc1,2,3		
	anda	#1			; odd or even ????
	lsla				; *2
	sta	<tmya+1			; store into immediate statement
	lsra				; restore
xsc1	addd	#0
	sta	<fff+1			; only need to store A
tmya	ora	#0
	sta	<mya+2
;*******************************
;second half
;*******************************
fff	lda	#0			; only need to load A
xsc2	addd	#0
	anda	#1			; odd or even ????
	lsla	
	sta	tmyb+1			; store into immediate statement
	lsra
xsc3	addd	#0
	std	<xscan+1		; need to store D this time
tmyb	ora	#0
	sta	<myb+2

;*******************************
; 0,1,2,3 dependant upon position
; least significant byte
; gets modded by above code
;*******************************
mya	lda	sgtab1			;use our character lookup table
myb	ldb	sgtab1			
	std	,x			;store to the address provided (the funky routine)
	eora	#$f			;flip for even/odd
	eorb	#$f
	std	>$80,x			;store to the *opposite* plot routine (SELFMOD)
	leax	6,x			;next set of pixels please !!!
	leay	-1,y			;done what we need ??
	bne	xloop

ystuff	

;*******************************
; Y AXIS STUFF
;*******************************
	ldx	#$400			;screen pointer
;*******************************
yscan	ldd	#0			
yscale	addd	#0			;gets populated by above code
	std	<yscan+1
	anda	#1			;check odd/even
	beq	oddy
	jmp	>funky+$80		;odd routine (as in chessboard)
oddy	jmp	>funky			;even routine
eveny	leax	32,x			;next line
	cmpx	#$400+32*64		;done ??
	blo	yscan			;nope - go again
	jmp	yloop			;now start over


	end	start