; OutRoad 256b intro by LBi/Bitbandit - 2021.09.10
; emulation: DOSBox-X, CPU cycles 30000

        org 0x100

; assume ax=0, si=0x100, black screen

        push 0xa000               ; set es to VGA screen segment
        pop es

        mov al, 0x13              ; set gfx mode to 320x200, 256 color
        int 0x10

        fldl2t                    ; [3.32]
        fidiv word [si]           ; [incr=3.32/104=0.032]
        fild word [byte si+i191]  ; [200] [inc]
        fldz                      ; [cnt=0] [200] [inc]
Main:   fadd st2                  ; [cnt++] [200] [inc]

i191 equ $
f5 equ $+1
        mov di, 32000             ; screen start
ploop:
        mov cx, 320               ; 3b
        mov ax, di                ; 2b
        xor dx, dx                ; 2b
        div cx                    ; 2b  AX=Y, DX=X
i160 equ $+2
        sub dx, 160               ; 4b  X-160
        sub ax, 80                ; 3b  Y-80

; bx must be zero, used as a pointer to stack, read out pushed registers - thanks to Rrrola,Hellmood

        pusha                     ; -18:di -16:si -14:bp -12:sp -10:bx -8:dx -6:cx -4:ax -2:0
        fild word [bx-4]          ; [Y] [cnt] [200] [inc]
        fdivr st2                 ; [qy=200/Y] [cnt] [200] [inc]
        fild word [bx-8]          ; [X] [qy] [cnt] [200] [inc]
        fdiv st3                  ; [qx=X/200] [qy] [cnt] [200] [inc]
        fmul st1                  ; [qx=qx*qy] [qy] [cnt] [200] [inc]

; road effect idea from https://www.shadertoy.com/view/XtlGW4 - thanks to mattz

        fldlg2                    ; [0.3] [qx] [qy] [cnt] [200] [inc]
        fmul st3                  ; [0.3*cnt] [qx] [qy] [cnt] [200] [inc]
        fsin                      ; [k=sin(0.2*cnt)] [qx] [qy] [cnt] [200] [inc]
        fldlg2                    ; [0.3] [k] [qx] [qy] [cnt] [200] [inc]
        fmul st1                  ; [0.3*k] [k] [qx] [qy] [cnt] [200] [inc]
        fmul st1                  ; [0.3*k*k] [k] [qx] [qy] [cnt] [200] [inc]
        fmulp st1                 ; [0.3*k*k*k] [qx] [qy] [cnt] [200] [inc]
        fmul st2                  ; [0.3*k*k*k*qy] [qx] [qy] [cnt] [200] [inc]
        fmul st2                  ; [0.3*k*k*k*qy*qy] [qx] [qy] [cnt] [200] [inc]
        fsubrp st1                ; [qx=qx-0.3*k*k*k*qy*qy] [qy] [cnt] [200] [inc]
        fmul st0                  ; [qx=qx*qx] [qy] [cnt] [200] [inc]
        fimul word [si]           ; [qx=qx*104] [qy] [cnt] [200] [inc]
        fistp word [bx-8]         ; [qy] [cnt] [200] [inc]
        popa

        mov al, 16                ; default, road is black
        test dx, dx
        jnz .1
        dec ax                    ; dashed line is white 
.1:
        cmp dx, [byte si+i160]
        jbe .2
        mov al, 30                ; sides are white
.2:
        cmp dx, [byte si+i191]
        jbe .3
        mov al, 116               ; grass is green-ish
.3: 
        fldl2t                    ; [3.32] [cnt] [200] [inc]
        fmulp st1                 ; [qy*3.32] [cnt] [200] [inc]
        fld st1                   ; [cnt] [qy*3.32] [cnt] [200] [inc]
        fdiv st4                  ; [cnt*31] [qy*3.32] [cnt] [200] [inc]
        faddp st1                 ; [qy*3.32+cnt*31] [cnt] [200] [inc]
        fsin                      ; [sin(qy*3.32+cnt*31)] [cnt] [200] [inc]
        fldz                      ; [0] [sin(qy*3.32+cnt*31)] [cnt] [200] [inc]
        fucomip                   ; [sin(qy*3.32+cnt*31)] [cnt] [200] [inc]
        jc .4

        inc ax                    ; alternate two consecutive colors

.4:
        stosb                     ; put pixel

        fstp st0                  ; [cnt] [200] [inc]

        test di, di               ; A000-FFFF a bit offscreen but simplifies the loop
        jnz ploop

music:  pusha
        inc byte [si-1]           ; pattern pos
        mov bl, [si-1]
        rcr bl, 1                 ; limit tempo /2
        jnc .2
        mov si, midi
        mov cx, bx
        shr cx, 3                 ; pattern byte pos
        and bx, 7                 ; bit pos within pattern byte
        and cx, 7

        mov dx, 0x331             ; MIDI status/command port
        outsb
        dec dx                    ; MIDI data port

        outsb                     ; 0x99 drums channel
        mov al, [si+bx+(drums-midi-2)]
        out dx, al                ; instrument
        outsb                     ; 0x7f max. volume

        xchg bx, cx               ; swap bytepos <-> bitpos
        bt [si+bx+(pat-notepos)], cx
        jnc .2                    ; 0=skip, 1=note
        mov bl, [si]              ;
        inc bx                    ; step note pos
        cmp bl, 21
        jna .0
        xor bx, bx                ; reset note pos
.0:     mov [si], bl
        inc si
        mov bl, [si+bx+notes-chn]
        mov [si+6], bl
        mov cl, 8                 ; send 8 bytes to MPU
        rep outsb
        mov [si-5], bl
.2:     popa

        jmp Main                  ; sorry, no room to clean exit

midi:   db 0x3f, 0x99, 0x7f
notepos: db 21
chn:    db 0xc0, 0x2b, 0x80, 0x00, 0x7f, 0x90, 0x00, 0x3f
pat:    db 0x01, 0x44, 0x01, 0x11, 0x01, 0x00, 0x00, 0xC9
notes:  db 66,69,71,68,66,64,66,69,68,66,64,66,68,69,71,73,76,78,0,0,0,0
drums:  db 35,69,69,35,40,69,69,69

; Original music: outrun-1914.mod

; MIDI instruments: https://en.wikipedia.org/wiki/General_MIDI
; Programming MIDI: http://www.piclist.com/techref/io/serial/midi/mpu.html
; MIDI Specification: http://www.gweep.net/~prefect/eng/reference/protocol/midispec.html