#version 450 core

// inputs 
in vec2 texCoord;

// outputs
out vec4 fragColor;

// uniforms
uniform sampler2D   t_texture0;
uniform float       g_time;
uniform float       g_whiteblend;
uniform float       g_glvel;

float rand(vec2 co){
    return 2.*(fract(sin(dot(co, vec2(12.9898, 78.233))) * 43758.5453)-.5);
}

float t = g_time;
float it = (int((t + .4*sin(t*0.3) + .2*sin(t*0.9)) * 3.)) * .33;

#define BLUR_SAMPLES 16
void main(void) {
    vec2 uv = texCoord-.5;
  	float radius = dot(uv,uv);
  	uv *= (0.9 + 0.3*radius);

    float glx = g_glvel*sin(it*7.2)*rand(vec2(sin(g_time*0.6)))*0.02*mod(float(int(uv.y * 20)), 0.4);
 	float gly = g_glvel*cos(it*7.2)*rand(vec2(sin(g_time*0.1)))*0.02*mod(float(int(uv.x * 110)), 0.4);
 	uv.x += glx;
	uv.y += gly;

    vec3 acc  = vec3(0.0);
	vec3 zoom = vec3(1.0, 1.0, 1.0);
	
	for (int i = 0 ; i < BLUR_SAMPLES; i++) {
		zoom *= vec3(0.999, .998, .997);
		acc.r += texture(t_texture0, (uv*zoom.r + 0.5)).r;
		acc.g += texture(t_texture0, (uv*zoom.g + 0.5)).g;
		acc.b += texture(t_texture0, (uv*zoom.b + 0.5)).b;
	}

    // add vingette
	float dim = clamp(1.0 - 1.1*pow(dot(uv, uv), 0.9), 0.0, 1.0);
	
    fragColor = vec4(pow(mix((acc.rgb / BLUR_SAMPLES) * dim + 0*rand(uv), vec3(1.0), g_whiteblend), vec3(1.0/2.2)), 1.0);
}
