#version 450 core

// varying inputs
in vec2 texCoord;

// outputs
//out vec4 outColor;

// uniforms
uniform sampler2D t_source;

uniform vec2  g_srcResolution;
uniform vec2  g_dstResolution;
uniform vec2  g_direction;
uniform float g_scale;

// shamelessly taken from https://software.intel.com/content/www/us/en/develop/blogs/an-investigation-of-fast-real-time-gpu-based-image-blur-algorithms.html
vec3 GaussianBlur( sampler2D tex0, vec2 centreUV, vec2 halfPixelOffset, vec2 pixelOffset )                         
{                                                                                                                  
    vec3 colOut = vec3( 0, 0, 0 );                                                                                 
                                                                                                                   
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Kernel width 35 x 35
    //
    const int stepCount = 9;
    //
    const float gWeights[stepCount] ={
       0.10855,
       0.13135,
       0.10406,
       0.07216,
       0.04380,
       0.02328,
       0.01083,
       0.00441,
       0.00157
    };
    const float gOffsets[stepCount] ={
       0.66293,
       2.47904,
       4.46232,
       6.44568,
       8.42917,
       10.41281,
       12.39664,
       14.38070,
       16.36501
    };
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                   
    for( int i = 0; i < stepCount; i++ )                                                                           
    {                                                                                                              
        vec2 texCoordOffset = gOffsets[i] * pixelOffset * g_scale;                                                           
        vec3 col = texture( tex0, centreUV + texCoordOffset ).xyz + texture( tex0, centreUV - texCoordOffset ).xyz;
        colOut += gWeights[i] * col;                                                                               
    }                                                                                                              
                                                                                                                   
    return colOut;                                                                                                 
}                                                                                                                  


void main() {

	vec2 texOfs = 1.0 / g_srcResolution;
	vec3 outColor = GaussianBlur(t_source, texCoord, vec2(0.0), texOfs * g_direction);

	gl_FragColor = vec4(outColor, 1.0);
};