#version 450 core

const vec2 corners[4] = { 
    vec2(0.0, 1.0), vec2(0.0, 0.0), vec2(1.0, 1.0), vec2(1.0, 0.0) };

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

uniform float g_spriteSize;
uniform float g_aspectRatio;

out vec2 texCoord;
in  vec4 color[];
out vec4 fragColor;

void main()
{
    for(int i=0; i<4; ++i)
    {
        vec4 eyePos = gl_in[0].gl_Position;
        eyePos.xy += g_spriteSize * (corners[i] - vec2(0.5)) / vec2(g_aspectRatio, 1.);
        gl_Position = eyePos;
        texCoord = corners[i];
        EmitVertex();
        fragColor = color[0] * (1. - smoothstep(1., 0.5, eyePos.z)) * (smoothstep(0.1, 0.8, pow(eyePos.z, 0.5)));
    }
}
