;                       /|
;                      //|.
;                     //_| .
;                 __ // /| .
;                /_ \/\__|. 
;                \\_/  _/|_
;                .g.e.n.d.a.
;
;______________________________________________________
;
;
;              filla! (256b intro)
;
;______________________________________________________
;
;	CODE:	        svoy
;______________________________________________________
;
;         Lost Party 2020
;         256b intro (compo filler)
;	  stable illegals: LAX, SAX. 
;______________________________________________________
; tomaswoj@gmail.com
; http://pl.linkedin.com/in/tomaswoj
; Cracow

; good illegal opcodes cheatsheet:
; https://xxl.atari.pl/sally-6502c/?fbclid=IwAR3OzILLYZpJnamVOBDI--wNp4vY2LQcgmczaggsgr0E0glVCs9L9vWFS88

	opt h+	
	
	org $2000

SUNBASE	equ $8000 ; 2K boundary
;SUNBASE	equ $2c00 ; 2K boundary
SCRDAT	equ $4000

FRMSKIP	equ $3 ; this is also used to setup PMG
PMGSKIP	equ $3
FRMDEN	equ $91 ; frame skip counter
PMGDEN	equ $92
FRMCNT	equ $93
FILL_L	equ $94
FILL_H	equ $95

; OS, etc.
VCOUNT	equ $D40B
WSYNC	equ $D40a
PCOL1	equ $D017;
PCOL2	equ $D018;
AUDF1	equ $D200
AUDC1	equ $D201
AUDF2	equ $D202
AUDC2	equ $D203
AUDF3	equ $D204
AUDC3	equ $D205
AUDF4	equ $D206
AUDC4	equ $D207
AUDCTL 	equ $D208 ;
SKCTL	equ $D20f;




	lda #$fe  ; OS DISABLE, lets rock! 
	sta $d301 

	lda <(rtibyte+2)
	sta $fffa	
	lda >(rtibyte+2)
	sta $fffb


; create display list		
crdlist:

; DL header and ending
	ldy #10		
dlhedlp:
	lda DLHED,y
	sta $c8fd,y
	lda DLEND,y 
	sta $D401,y ; DL set ($D402/$D403)
	sta $c900+3*201,y
	lda PMGICO,y	
	sta SUNBASE+512+83,y	
	dey
;	bne dlhedlp
	bpl dlhedlp
	
	
; DL contents (lines)
	ldx #201;
	;ldx #$c9; FILL_L = $00, FILL_H=$C9, so DList start would be $c8fd
	stx FILL_H 
	;reuse from the upper dey
	;ldy #0
dlist_l:
	ldy #0
	;lda #($80+$4F) ; F + DLI + LMS		
	lda #($4F) ; F + DLI + LMS
	sta (FILL_L),y	
	txa	
	and #%00100000
	lsr
	lsr
	lsr
	; fill it with either 0 or 4 (depending on the 5th bit above)
	iny	
	sta (FILL_L),y	
	lda #>SCRDAT
	iny 
	sta (FILL_L),y	
	; move target addr by 3 bytes
	lda FILL_L
	adc #3
	bcc skipbcc3
	inc FILL_H
skipbcc3
	sta FILL_L	
	

; as a side effect in this loop - populate chessboard table
	txa
	and #%00000100
	bne datf ; data full
	beq date ; data empty
datf	
	lda #$ff
date	
	sta SCRDAT-1,x	
	
	dex
	bne dlist_l


	; color for cbeckers
	stx $D017
	
			
	lda #>SUNBASE
	sta $D407; set PMBASE, needs to be at 1K boundary for double resoultuon and 2K boundary for single resolution sprites (Every line)
	;sta $D407; set PMBASE, needs to be at 1K boundary for double resoultuon and 2K boundary for single resolution sprites (Every line)
						
	lda #%00 10 11 10
	sta $d400
	
	lda #3
	sta $D01D ; GRACTL -set both players and missles - done below, with nice 'surprise' flow
	sta SKCTL ; sound init
	
	ldx #64
	stx $D01B
	dex
	; sprite pos
	;lda #63	
	;sta $D000
	stx $D000

	ldy #255
	; use X=0, to generate 2 pages of content
randpat:
	lda $D20a
	sta $3000,y
	;sta $3100,y
	dey
	bne randpat	

	; sprite color
	lda #$9e
	sta $D012
	
					
frame

	
; play very simple sound:		
	;dec NOTELEN ; no need for that, we just use FRMCNT	
	lax FRMCNT
	and #%01111111 ; take up to 32	 
	sta AUDC3
	ldy #$3a
	sty AUDF3

	; now blink the background
	;txa
	and #%00011111
	lsr			
	sta $D01a

; wait for frame
	lax VCOUNT ; X=0 used in several effects reached by jsr
	bne frame ; wait for new frame

	lda FRMCNT ; 2b
	lsr
	tay
	;ldy #255 ; 2b
fxloop:
	;lda $c000,y ; 3b
	lda $3000,y
colfilter:	
	and #%00001111	
	sta WSYNC ; 3b
	sta PCOL2 ; 3b
	iny ; 1b
	dex ; 1b
	bne fxloop ;2b	
	 	
 	;jsr nmi
	dec FRMCNT
;update twister and background chessboard
	bne skipcolrand
	
	; set gprior to 0
	stx $D01B
	
	; randomize color filters
	lda $D20a
	and #%00000011
	tax
	lda COLFLTS,x
	sta colfilter+1
	
	 
skipcolrand	 	
	dec FRMDEN
	bne skp	; do not move the background

; now update background pattern

	ldx #128
rtibyte:	
	ldy SCRDAT
movelp
	; upgrade background pattern (that extends to 201 bytes, so gr8!)
	tya	
	rol
	rol SCRDAT-1,x
	ldy SCRDAT-1,x
	dex	
	bne movelp
	
	lda #FRMSKIP
	sta FRMDEN		
			
skp	 	
	bne frame		

;justrti	
;	rti ; SCRDAT above has the rti byte we need

DLHED	dta b(16,$50,$F0);
DLEND	dta b($41,$fd,$c8);
PMGICO	dta b(34,74,98,74,75,0,65,89,77,84,109);
;			V	   V			V
COLFLTS	dta b(%10011111,%00101111,%010011111,%00011111);

	run $2000
	end	
		
	