#version 430


layout (location=0) in vec3 vertexPosition;
layout (location=1) in vec3 vertexNormal;
layout (location=2) in vec2 vertexUV;
layout (location=3) in vec3 vertexTangent;
//layout (location=4) in float vertexBright;

out vec3 normal;
out vec2 uv;
out vec3 tangent;
out vec4 origPos;
out float bright;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float g_bright = 1.0;
uniform float g_uvScale = 1.0;


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  vec3 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}
vec3 rotateYZ3(vec3 p, float a) {
  vec3 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}


uniform float g_genUV = 0.0;


void main() {
  gl_Position = vec4(vertexPosition*0.20, 1.0);
  vec4 pos = gl_Position;
  origPos = pos;
  normal = vertexNormal;
  tangent = vertexTangent;
  bright = g_bright;
  if (g_genUV > 0.01) {
    uv = vec2(pos.x+pos.z, pos.y+pos.z)*g_genUV;
  } else {
    uv = vertexUV;
  }
}
