#version 430

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNorm;
layout(binding=2) uniform sampler2D texEnv;
layout(binding=3) uniform sampler2D texPrevFrame;
layout(binding=4) uniform sampler2D texPrevBlurFrame;
layout(binding=5) uniform sampler2D texPrevNorm;
layout(binding=6) uniform sampler2D texMul;
layout(binding=7) uniform sampler2D texDepth;

layout(binding=0, rgba16f) uniform image2D velBuf;

// layout(early_fragment_tests) in;

in vec4 posG;
in vec4 prevPosG;
in vec3 normalG;
in vec3 normalWSG;
in vec3 velG;
in vec2 uvG;
in vec3 tangentG;
in vec3 colorG;
in vec4 posW;
// in vec4 posInst;
in vec3 randG;


layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;
layout(location = 2) out vec4 frag3; // emitBuf

uniform float g_time;


uniform float g_uvOfsX = 0.0;
uniform float g_uvOfsY = 0.0;
uniform vec4 g_uvScale = vec4(1.0, 1.0, 1.0, 1.0);

uniform float g_texBrightness = 1.0;

uniform float g_emitNew = 0.0;

uniform float g_prevAmount = 0.0;
uniform float g_prevBlurAmount = 0.0;

uniform float g_genUV = 0.0;


uniform mat4 modelViewMatrix;
uniform mat4 modelViewInvMatrix;
uniform mat4 viewInvMatrix;
uniform mat4 viewMatrix;
uniform mat4 projectionMatrix;
uniform mat4 projectionInvMatrix;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;


uniform float g_prevBlurType = 1.0;


uniform float g_bump = 0.0;

const float zFar = 1.0;
const float zNear = 0.0;

uniform float g_mulTexAmp;


uniform vec4 g_animInfo = vec4(0.0, 0.0, 0.0, 0.0); // .x=anim cols, .y=anim frames, .z=anim rows, .w=anim frame int
uniform float g_animLoopFadeFrames = 0.0;

vec4 CalcEyeFromWindow(in vec3 windowSpace) {
    vec3 ndcPos;
    vec4 viewport = vec4(0.0, 0.0, g_windowWidth, g_windowHeight);
    ndcPos.xy = ((2.0 * windowSpace.xy) - (2.0 * viewport.xy)) / (viewport.zw) - 1;
//    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
    vec4 clipPos;
    clipPos.w = projectionMatrix[3][2]/(ndcPos.z-(projectionMatrix[2][2]/projectionMatrix[2][3]));
    clipPos.xyz = ndcPos * clipPos.w;
    return projectionInvMatrix * clipPos;
}

#define PI 3.1415926

vec2 latlong(vec3 v) {
  v = normalize(v);
  float theta = acos(v.z); // +z is up
  float phi = atan(v.y, v.x) + PI;
  return vec2(phi, theta)*vec2(.1591549, .6366198);
}


vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}


uniform float g_texAmbient;

uniform float g_alpha = 1.0;

uniform float g_emitThr = 0.0;
uniform float g_emitAmp = 1.0;

uniform float g_alphaSub = 0.0;

void main() {

  vec3 normal = normalG;
  vec2 uv = uvG;
  vec3 tangent = tangentG;
  vec3 color = colorG;

  vec2 myUv;
  if (g_genUV < 0.5) {
    myUv = uv*g_uvScale.xy;
  } else {
    myUv = posW.xy*g_uvScale.xy;
  }
//  myUv += randG.yz;
  myUv.y *= -1.0;
  myUv.x += g_uvOfsX;
  myUv.y += g_uvOfsY;

  if (g_animInfo.y > 1.0) { // if anim frames
      float animFramesPerRow = g_animInfo.x;
      float animFrames = g_animInfo.y;
      float animRows = g_animInfo.z;
      float animFrameInt = g_animInfo.w;

      float animWidth = 1.0/animFramesPerRow;
      float animHeight = 1.0/animRows;

      myUv *= vec2(animWidth, animHeight);
      myUv.x += fract(animFrameInt/animFramesPerRow)*animFramesPerRow*animWidth;
      myUv.y += floor(animFrameInt/animFramesPerRow)*animHeight;
  }

 vec4 diffuse = texture2D(tex, myUv.xy);
 diffuse.rgb *= diffuse.rgb;
 diffuse.rgb *= g_texBrightness;

 diffuse.rgb += vec3(g_texAmbient);

  vec3 lightPos = vec3(0.0*cos(g_time*2.0), 0.0, 5.0);
  vec3 surfPos = vec3(0.0f, 0.0f, 0.0f);
  vec3 lightDir = lightPos-surfPos;

  float lightDist = sqrt(dot(lightDir, lightDir));

  vec3 myNormal = normal;
  vec3 biTangent = cross(myNormal, tangent);


  vec4 normFromTex = texture2D(texNorm, myUv*1.0);
  float bumpX = -(normFromTex.x-0.5)*g_bump;
  float bumpY = -(normFromTex.y-0.5)*g_bump;

  myNormal += tangent*bumpX + biTangent*bumpY;
  myNormal = normalize(myNormal);


  float normalLen = sqrt(dot(myNormal, myNormal));

  float d = dot(lightDir, myNormal)/(lightDist*normalLen);
  d = clamp(d, 0.0, 1.0);


  float specPow = 320.0;

  frag = diffuse*0.50;

  vec4 c = frag;


  c.rgb *= 0.20+vec3(clamp(myNormal.x, 0.0, 1.0))*0.80;
  frag3.rgb = clamp(c.rgb-g_emitThr, 0.0, 1000.0)*g_emitAmp; // emitBuf


  if (g_prevBlurType < 0.5) {
      vec2 norkor = vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight);
      vec2 paske = (norkor.xy)-0.1*myNormal.xy;
      paske = clamp(paske, 0.0, 1.0);
      vec3 prevb = texture2D(texPrevBlurFrame, paske).rgb;
      c.rgb += g_prevBlurAmount*pow(clamp(prevb-vec3(0.01), 0.0, 8.0),vec3(2.0));

  } else {
      vec3 normalB = (projectionMatrix*viewMatrix*vec4(myNormal, 0.0)).xyz;
      normalB /= normalB.z;
      vec2 norkor = vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight);
      vec2 paske = (norkor.xy)-0.025*(normalB.xy);
      paske = clamp(paske, 0.0, 1.0);
      float kk = 1.0;

      vec3 jorge = texture2D(texPrevNorm, paske).rgb*1.0;
      vec4 efe = CalcEyeFromWindow(vec3(paske.x*g_windowWidth, paske.y*g_windowHeight, jorge.r));
      vec3 seze = (viewInvMatrix*vec4(efe.xyz, 1.0)).xyz*1.0;

      vec3 jorgeC = texture2D(texPrevNorm, norkor).rgb*1.0;
      vec4 efeC = CalcEyeFromWindow(vec3(norkor.x*g_windowWidth, norkor.y*g_windowHeight, jorgeC.r));
      vec3 sezeC = (viewInvMatrix*vec4(efeC.xyz, 1.0)).xyz*1.0;

      vec3 sp = seze-sezeC;
      float kx = (dot(sp, sp));
      float dok = 1.0/(clamp(kx, 0.0, 10000.0)*0.0+1.0);
      // if (kx > 100.0) dok = 0.0;
      dok = clamp(dok, 0.0, 100.0);

      sp/=sqrt(kx);
      float dok2 = dot(sp, -normal)+0.0;
      dok2 = clamp(dok2, 0.0, 1.0);

      float dok2a = 0.30;
      dok *= (dok2*dok2a+1.0-dok2a);

   //   dok = 1.0;

      vec3 prevb = texture2D(texPrevBlurFrame, paske).rgb*clamp(dok*kk, 0.0, 1.0);
      c.rgb += (0.0+1.0*g_prevBlurAmount*(pow(clamp(prevb-vec3(0.0), 0.0, 8.0),vec3(2.0))-vec3(0.0)));


      //c.rgb = seze*0.01;
      //c.rgb = vec3(dok);
  }

  c.rgb = clamp(c.rgb, 0.0, 10.0);

  c.a = diffuse.a*g_alpha;

  c.a -= g_alphaSub;

  vec4 dep = texelFetch(texDepth, ivec2(gl_FragCoord.xy), 0);
  if (gl_FragCoord.z > dep.x) {
    discard;
  }

  frag = c;

  if (c.a < 0.001) {
      discard;
  }

  //frag.rgb = clamp(frag.rgb, 0.0, 1.0);


  if (g_mulTexAmp > 0.001) {
    vec4 mu = texture2D(texMul, myUv);
    float gee = clamp(g_mulTexAmp, 0.0, 1.0);
    frag = frag*(1.0-gee)+gee*frag*dot(vec3(0.3333), mu.rgb);
  }


 // inster = posInst.x;
 // frag.rgb = vec3(inster*0.01);// vec3(float(int(fract((inster)*0.1)*5.0))*0.2);
//  frag.a = c.a;

  frag = pow(frag, vec4(0.5));


  vec2 vel = 25.0*(prevPosG.xy/prevPosG.w - posG.xy/posG.w);

  vec4 velVal = vec4(vel, 0.0, 0.0);

//  vec4 dep = texelFetch(texDepth, ivec2(gl_FragCoord.xy), 0);
//  if (gl_FragCoord.z <= dep.x) {
 // if (1==1) {
    //  velVal = vec4(dep.x-gl_FragCoord.z);
    imageStore(velBuf, ivec2(gl_FragCoord.xy), velVal);
//  }


 // frag.rg
  //frag.rgb = 0.1*posG.xyz;
  //frag.rgb = 0.1*prevPosG.xyz;
 // frag.b = 0.0;

 // frag.rgb = vec3(inster)*0.5;

//  frag.a = 1.0;

  frag2.rgb = normalize(normalWSG).xyz;
  frag2 = clamp(frag2, -1.0, 1.0);
  frag2.a = 1.0;

//  frag3 = pow(frag3, vec4(0.5));
  frag3.rgb = clamp(frag.rgb-g_emitThr, 0.0, 1000.0)*g_emitAmp; // emitBuf
  frag3.a = frag.a;

}

