#version 430

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texBump;
layout(binding=2) uniform sampler2D texEnv;
layout(binding=3) uniform sampler2D texPrevFrame;
layout(binding=4) uniform sampler2D texPrevBlurFrame;
layout(binding=5) uniform sampler2D texPrevNorm;
layout(binding=6) uniform sampler2D texRep2;
layout(binding=7) uniform sampler2D texRep3;
layout(binding=8) uniform sampler2D pardexPos;



in vec4 posG;
in vec3 normalG;
in vec3 normalWSG;
in vec2 uvG;
in vec3 tangentG;
in vec3 colorG;
in vec4 posW;
in vec4 posInst;
in vec4 randG;
in vec3 mirrorG;


layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;
layout(location = 2) out vec4 frag3; // emitBuf


uniform float g_instLayer = 0.0;
uniform float g_time;

uniform float g_uvOfsX = 0.0;
uniform float g_uvOfsY = 0.0;
uniform vec4 g_uvScale = vec4(1.0);

uniform float g_texBrightness = 1.0;

uniform float g_emitNew = 0.0;

uniform float g_prevAmount = 0.0;
uniform float g_prevBlurAmount = 0.0;


uniform float g_cubesDiv = 16.0;
uniform float g_spread = 8.0;
uniform float g_worldPos = 1.0;

uniform float g_genUV = 0.0;


uniform mat4 modelViewMatrix;
uniform mat4 modelViewInvMatrix;
uniform mat4 viewInvMatrix;
uniform mat4 viewMatrix;
uniform mat4 projectionMatrix;
uniform mat4 projectionInvMatrix;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;


uniform float g_prevBlurType = 1.0;


uniform float g_bump = 0.0;

uniform float g_animHeight = 0.0;

const float zFar = 1.0;
const float zNear = 0.0;

vec4 CalcEyeFromWindow(in vec3 windowSpace) {
    vec3 ndcPos;
    vec4 viewport = vec4(0.0, 0.0, g_windowWidth, g_windowHeight);
    ndcPos.xy = ((2.0 * windowSpace.xy) - (2.0 * viewport.xy)) / (viewport.zw) - 1;
//    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
    vec4 clipPos;
    clipPos.w = projectionMatrix[3][2]/(ndcPos.z-(projectionMatrix[2][2]/projectionMatrix[2][3]));
    clipPos.xyz = ndcPos * clipPos.w;
    return projectionInvMatrix * clipPos;
}

#define PI 3.1415926

vec2 latlong(vec3 v) {
  v = normalize(v);
  float theta = acos(v.z); // +z is up
  float phi = atan(v.y, v.x) + PI;
  return vec2(phi, theta)*vec2(.1591549, .6366198);
}


vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
  return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

uniform vec4 g_mirrorX = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorX on/off, .y: mirrorXPos, .z: mirrorXClip
uniform vec4 g_mirrorY = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorY on/off, .y: mirrorYPos, .z: mirrorYClip
uniform vec4 g_mirrorZ = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorZ on/off, .y: mirrorZPos, .z: mirrorZClip


uniform float g_texAmbient;

uniform float g_alpha;

uniform vec4 g_uvRandom;

uniform mat4 modelMatrix;
uniform float g_timeStep;


// pala flow emit stuff
uniform float g_emitThr = 0.0;
uniform float g_emitAmp = 1.0;





// BUMPERS begin
uniform float texSub = 0.0;
uniform float texMult = 1.0;
vec3 texOp(vec3 t) {
    t.rgb -= vec3(texSub);
    t.rgb = clamp(t.rgb, 0.0, 10000.0);
    t.rgb *= texMult;
    return t;
}

uniform float bumpTexInd = 0.0;
uniform float bumpStrength = 1.0;
uniform float bumpTexDelta = 1.0;
uniform float bumpUvScale = 1.0;
vec2 getBumpG(sampler2D s, vec2 uv) {
    if (abs(bumpUvScale) < 0.0001) {
        uv.xy *= g_uvScale.xy;
    } else {
        uv *= bumpUvScale;
    }
    vec2 d = vec2(bumpTexDelta)/textureSize(s, 0);
    return vec2(texOp(texture2D(s, uv+d.xy).rgb).g-texOp(texture2D(s, uv-d.xy).rgb).g,
                texOp(texture2D(s, uv+d.yx).rgb).g-texOp(texture2D(s, uv-d.yx).rgb).g)*bumpStrength;
}
// BUMPERS end







// BEGIN NOISE
// TODO #include "noise.h"

uniform float noiseOct = 6.0;
uniform float noiseOctMul = 2.0;
uniform float noiseOctAmp = 0.5;
uniform float noiseSplineEnabled = 1.0;

// from pouet raymarching thread by las of mercury
float perlin(vec3 p) {
    vec3 i = floor(p);
    vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
    vec3 f = cos((p-i)*3.14159265)*(-.5)+.5;
    a = mix(sin(cos(a)*a),sin(cos(1.+a)*(1.+a)), f.x);
    a.xy = mix(a.xz, a.yw, f.y);
    return mix(a.x, a.y, f.z)-0.0;
}
float turb3(vec3 c) {
        float r=0.0;
        float s=0.5;
        for (int i=0;i<noiseOct;i++) {
                r+=s*(perlin(c));
                c*=noiseOctMul;
                s*=noiseOctAmp;
        }
        return r;
}

vec3 posd(float pw) {
    return vec3(sin(pw)*17.0, cos(pw*1.7)*13.0, sin(pw*0.78+cos(pw*0.4))*11.0)*32.0;
}

float getSplineValue(float t, float p0, float pt0, float p1, float pt1) {
    float t2 = t*t;
    float t3 = t*t*t;
    float p = (2.0*t3-3.0*t2+1.0)*p0+(t3-2.0*t2+t)*pt0+(-2.0*t3+3.0*t2)*p1+(t3-t2)*pt1;
    return p;
}

float perlin4(vec4 p) {
//    vec4 pf1 = floor(p);
//    vec4 pf2 = floor(p+vec4(1.0));

    float p1 = perlin(p.xyz+posd(floor(p.w)+1.0));
    float p2 = perlin(p.xyz+posd(floor(p.w)+2.0));

    if (noiseSplineEnabled > 0.5) {
        float p0 = perlin(p.xyz+posd(floor(p.w)));
        float p3 = perlin(p.xyz+posd(floor(p.w)+3.0));
        float ki = fract(p.w);
        return getSplineValue(ki, p1, p2-p0, p2, p3-p1);
    } else {
        float ki = smoothstep(0.0, 1.0, fract(p.w));
        return p1*(1.0-ki)+p2*(ki);
    }
}

float turb4(vec4 c) {
        float r=0.0;
        float s=0.5;
        for (int i=0;i<int(noiseOct);i++) {
                r+=s*(perlin4(c));
                c*=noiseOctMul;
                s*=noiseOctAmp;
        }
        return r;
}

// end of "noise.h"


uniform float noisePos = 0.0;
uniform float noiseOfsX = 0.0;
uniform float noiseOfsY = 0.0;
uniform float noiseFreq = 0.50;

uniform float dispAmp = 0.15;
uniform float dispExp = 5.0;


void applyDisp(inout float no) {
    no = (sign(no)*pow(abs(no), dispExp));
}

// END NOISE











// TEXREPE begins

vec2 rotateXY2(vec2 p, float a) {
  vec2 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

uniform float g_repTex1 = 0.0;
uniform float g_repUVBase1 = 1.0;
uniform float g_repUVOp1 = 0.0;
uniform float g_repUVAmp1 = 0.0;
uniform float g_repUVSca1 = 1.0;
uniform float g_repUVOfsX1 = 0.0;
uniform float g_repUVOfsY1 = 0.0;
uniform float g_repUVRot1 = 0.0;

uniform float g_repTex2 = 0.0;
uniform float g_repUVBase2 = 0.0;
uniform float g_repUVOp2 = 0.0;
uniform float g_repUVAmp2 = 0.0;
uniform float g_repUVSca2 = 1.0;
uniform float g_repUVOfsX2 = 0.0;
uniform float g_repUVOfsY2 = 0.0;
uniform float g_repUVRot2 = 0.0;

uniform float g_repTex3 = 0.0;
uniform float g_repUVBase3 = 0.0;
uniform float g_repUVOp3 = 0.0;
uniform float g_repUVAmp3 = 0.0;
uniform float g_repUVSca3 = 1.0;
uniform float g_repUVOfsX3 = 0.0;
uniform float g_repUVOfsY3 = 0.0;
uniform float g_repUVRot3 = 0.0;

uniform float g_repPow = 1.0;



vec4 texRepe(sampler2D tRep1, sampler2D tRep2, sampler2D tRep3, vec2 uv) {
   vec4 r = vec4(0.0);
   vec2 uvr;
   vec4 rep;

   //     float repLum = dot(vec3(0.299, 0.587, 0.114), rep.rgb);
   //     if (repLum > 0.001) {
   //       r.rgb /= repLum;
   //       repLum = pow(repLum, 1.0);
   //       r.rgb *= repLum;
   //     }

   float hp = 0.5*3.141592;

   if (g_repUVOp1 > 0.5) {
     uvr = rotateXY2(uv, hp*g_repUVRot1/90.0)+vec2(g_repUVOfsX1, g_repUVOfsY1);
     if (g_repTex1 < -0.5) {
       rep = vec4(1.0, 0.0, 0.0, 1.0);


       float evo = 0.0;
       float movex = 0.0;
       vec4 pp = posW;
       float no = turb4(vec4(pp.xyz*noiseFreq+vec3(noiseOfsX, noiseOfsY+g_time*movex, 0.0), noisePos+g_time*evo));
       float no2 = turb4(vec4(pp.zxy*noiseFreq*1.32+vec3(noiseOfsX+0.76, noiseOfsY+1.23+g_time*movex, 0.0), noisePos+1.72+g_time*evo));
       float no3 = turb4(vec4(pp.yzx*noiseFreq*1.92+vec3(noiseOfsX+1.26, noiseOfsY+0.53+g_time*movex, 0.0), noisePos+0.32+g_time*0.5*evo));

       applyDisp(no);
       applyDisp(no2);
       applyDisp(no3);


       vec3 noi = vec3(no, no2, no3);
       float noiAmp = dot(noi, vec3(0.333))+0.5;
       rep.rgba *= noiAmp;


     } else if (g_repTex1 < 0.5) {
       rep = texture2D(tRep1, uvr*g_repUVSca1);
     } else {
       rep = texture2D(tRep1, uvr*g_repUVSca1);
     }
     if (g_repUVOp1 < 1.5) {
      r.rgb += vec3(g_repUVBase1)+rep.rgb*rep.a*g_repUVAmp1;
     } else {
      r.rgb += (r.rgb+vec3(g_repUVBase1))*rep.rgb*rep.a*g_repUVAmp1;
     }
   }

   if (g_repUVOp2 > 0.5) {
     uvr = rotateXY2(uv, hp*g_repUVRot2/90.0)+vec2(g_repUVOfsX2, g_repUVOfsY2);
     if (g_repTex2 < 0.5) {
       rep = texture2D(tRep1, uvr*g_repUVSca2);
     } else {
       rep = texture2D(tRep2, uvr*g_repUVSca2);
     }
     if (g_repUVOp2 < 1.5) {
      r.rgb += vec3(g_repUVBase2)+rep.rgb*rep.a*g_repUVAmp2;
     } else {
      r.rgb *= vec3(g_repUVBase2)+rep.rgb*rep.a*g_repUVAmp2;
     }
   }
   if (g_repUVOp3 > 0.5) {
     uvr = rotateXY2(uv, hp*g_repUVRot3/90.0)+vec2(g_repUVOfsX3, g_repUVOfsY3);
     if (g_repTex3 < 0.5) {
       rep = texture2D(tRep1, uvr*g_repUVSca3);
     } else {
       rep = texture2D(tRep3, uvr*g_repUVSca3);
     }
     if (g_repUVOp3 < 1.5) {
      r.rgb += vec3(g_repUVBase3)+rep.rgb*rep.a*g_repUVAmp3;
     } else {
      r.rgb *= vec3(g_repUVBase3)+rep.rgb*rep.a*g_repUVAmp3;
     }
   }
   r = clamp(r, 0.0, 10000.0);
   r = pow(r, vec4(g_repPow));
   r.a = 1.0;
   return r;
}
// TEXREPE ends



uniform float normalAlpha = 1.0;





void main() {

  vec3 normal = normalG;
  vec2 uv = uvG;
  vec3 tangent = tangentG;
  vec3 color = colorG;

  float mmz = g_mirrorZ.z;
  if (mmz > 1.5 && mirrorG.z < 0.0) {
    mmz *= -1.0;
  }

  if (mirrorG.x*(posW.x-g_mirrorX.y)*g_mirrorX.z > 0.0 ||
      mirrorG.y*(posW.y-g_mirrorY.y)*g_mirrorY.z > 0.0 ||
      mirrorG.z*(posW.z-g_mirrorZ.y)*mmz > 0.0) {
        discard;
  }

//  if (posW.x-g_mirrorX.y < 0.0) discard;

  vec2 randUv = g_uvScale.xy+vec2(randG.x);
  randUv = min(max(randUv, vec2(g_uvRandom.y)), vec2(g_uvRandom.z));

  vec2 myUv = posInst.xy*randUv+vec2(0.5, 0.5);
  if (g_genUV < 0.5) {
    myUv = uv*randUv;
  }
  myUv += randG.yz;
  myUv.y *= -1.0;
  myUv.x += g_uvOfsX;
  myUv.y += g_uvOfsY+g_animHeight*floor(fract((floor(randG.w/1.0-0.5)/4.0)+0.01)*4.0);

// vec4 diffuse = texture2D(tex, myUv.xy);
 vec4 diffuse = texRepe(tex, texRep2, texRep3, myUv);
 diffuse.rgb *= diffuse.rgb;
 diffuse.rgb *= g_texBrightness;

 diffuse.rgb += vec3(g_texAmbient);


 //diffuse.rgb *= diffuse.rgb;
// vec4 diffuse = 10.1*vec4(1.0);


 //diffuse += 4.0*texture2D(tex, myUv.xy*10.0)+0.1*vec4(1.0);


 // diffuse.r = pow(diffuse.r, 2.5);
 // diffuse.g = pow(diffuse.g, 1.10);
 // diffuse.b = pow(diffuse.b, 0.70);

  vec3 lightPos = vec3(0.0*cos(g_time*2.0), 0.0, 5.0);
  vec3 surfPos = vec3(0.0f, 0.0f, 0.0f);
  vec3 lightDir = lightPos-surfPos;

  float lightDist = sqrt(dot(lightDir, lightDir));

  vec3 myNormal = normal;
  vec3 biTangent = cross(myNormal, tangent);

//  float bumpX = 0.0*(texture2D(tex, myUv.xy+vec2(1.0/512.0, 0.0)).g-texture2D(tex, myUv.xy+vec2(-1.0/512.0, 0.0)).g);
//  float bumpY = 0.0*(texture2D(tex, myUv.xy+vec2(0.0, 1.0/512.0)).g-texture2D(tex, myUv.xy+vec2(0.0, -1.0/512.0)).g);


//  vec4 normFromTex = texture2D(texNorm, myUv*1.0);
//  float bumpX = -(normFromTex.x-0.5)*g_bump;
//  float bumpY = -(normFromTex.y-0.5)*g_bump;

////  bumpX = 0.0;
////  bumpY = 0.0;

//  myNormal += tangent*bumpX + biTangent*bumpY;

  vec2 bu = vec2(0.0);
  if (bumpTexInd > 0.5) {
    bu = getBumpG(texBump, myUv.xy)*g_bump;
  } else {
    bu = getBumpG(tex, myUv.xy)*g_bump;
  }
  myNormal += tangent*bu.x + biTangent*bu.y;


  myNormal = normalize(myNormal);


  float normalLen = sqrt(dot(myNormal, myNormal));

  float d = dot(lightDir, myNormal)/(lightDist*normalLen);
  d = clamp(d, 0.0, 1.0);

  //d = d*0.35+pow(d, 128.0f);
  //frag = vec4(d, d, d, d);

 // frag = (diffuse+0.4)*d*0.35 + pow(d, 128.0f)+0.03;

  float specPow = 320.0;

  // frag = 1.0*diffuse*(d*0.0+0.20) + 0.50*pow(d, specPow);
  frag = diffuse*0.50;



//  c.r = pow(c.r, 0.85);
//  c.g = pow(c.g, 0.55);
//  c.b = pow(c.b, 0.45);

//  c.r = pow(c.r, 1.20);
//  c.g = pow(c.g, 0.80);
//  c.b = pow(c.b, 1.10);

 // frag.rgb *= pow(dot(myNormal, vec3(0.0, 1.0, 0.0))*0.5+0.5, 6.0);

 // diffuse.a = dot(vec3(0.3330), diffuse.rgb);


  frag.a = diffuse.a*g_alpha;
  //frag.a = 0.1;

  frag.a = clamp(frag.a, 0.0, 1.0);

 // emitParticles(myNormal);


  vec4 c = frag;


 // c.rgb *= 0.20+vec3(clamp(myNormal.x, 0.0, 1.0))*0.80;

  frag3.rgb = clamp(c.rgb-g_emitThr, 0.0, 1000.0)*g_emitAmp; // emitBuf


  if (g_prevBlurType < 0.5) {
//      vec2 norkor = posG.xy/posG.z;
//      norkor.xy *= 0.8;
//      norkor.xy = norkor.xy*0.5+0.5;
      vec2 norkor = vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight);

     // vec3 prev = texture2D(texPrevFrame, (norkor.xy)+0.2*normal.xy).rgb;
     // prev = pow(prev, vec3(2.0));
     // c.rgb += g_prevAmount*pow(clamp(prev, 0.0, 2.0),vec3(1.0));
      vec2 paske = (norkor.xy)-0.1*myNormal.xy;
      paske = clamp(paske, 0.0, 1.0);
      vec3 prevb = texture2D(texPrevBlurFrame, paske).rgb;
      //prevb = pow(prevb, vec3(2.20));

      c.rgb += g_prevBlurAmount*pow(clamp(prevb-vec3(0.01), 0.0, 8.0),vec3(2.0));

  } else {

      vec3 normalB = (projectionMatrix*viewMatrix*vec4(myNormal, 0.0)).xyz;
      normalB /= normalB.z;
      vec2 norkor = vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight);
      vec2 paske = (norkor.xy)-0.025*(normalB.xy);
      paske = clamp(paske, 0.0, 1.0);
      float kk = 1.0;

   //   if (paske.x < 0.01 || paske.y < 0.01 || paske.x > 0.99 || paske.y > 0.99) kk = 0.0;

      vec3 jorge = texture2D(texPrevNorm, paske).rgb*1.0;
      vec4 efe = CalcEyeFromWindow(vec3(paske.x*g_windowWidth, paske.y*g_windowHeight, jorge.r));
      vec3 seze = (viewInvMatrix*vec4(efe.xyz, 1.0)).xyz*1.0;

      vec3 jorgeC = texture2D(texPrevNorm, norkor).rgb*1.0;
      vec4 efeC = CalcEyeFromWindow(vec3(norkor.x*g_windowWidth, norkor.y*g_windowHeight, jorgeC.r));
      vec3 sezeC = (viewInvMatrix*vec4(efeC.xyz, 1.0)).xyz*1.0;

      vec3 sp = seze-sezeC;
      float kx = (dot(sp, sp));
      float dok = 1.0/(clamp(kx, 0.0, 10000.0)*0.0+1.0);
      // if (kx > 100.0) dok = 0.0;
      dok = clamp(dok, 0.0, 100.0);

      sp/=sqrt(kx);
      float dok2 = dot(sp, -normal)+0.0;
      dok2 = clamp(dok2, 0.0, 1.0);

      float dok2a = 0.30;
      dok *= (dok2*dok2a+1.0-dok2a);

   //   dok = 1.0;

      vec3 prevb = texture2D(texPrevBlurFrame, paske).rgb*clamp(dok*kk, 0.0, 1.0);
      c.rgb += (0.0+1.0*g_prevBlurAmount*(pow(clamp(prevb-vec3(0.0), 0.0, 8.0),vec3(2.0))-vec3(0.0)));


      //c.rgb = seze*0.01;
      //c.rgb = vec3(dok);
  }

  c.rgb = clamp(c.rgb, 0.0, 10.0);


  frag = c;


 // frag = vec4(1.0);

  //frag.rgb = clamp(frag.rgb, 0.0, 1.0);


 // inster = posInst.x;
 // frag.rgb = vec3(inster*0.01);// vec3(float(int(fract((inster)*0.1)*5.0))*0.2);
 // frag.a = 1.0;

  frag = pow(frag, vec4(0.5));

  if (c.a < 0.001) discard;


   // frag.rgb = vec3(inster)*0.5;

//  frag.a = 1.0;

  frag2.rgb = -normalize(normalWSG).xyz;
  frag2 = clamp(frag2, -1.0, 1.0);
  frag2.a = normalAlpha;

  frag3 = pow(frag3, vec4(0.5));
  frag3.a = frag.a;

}

