#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  vec3 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

vec3 rotateYZ3(vec3 p, float a) {
  vec3 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 24) out;
//layout(line_strip, max_vertices = 15) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];
in int inInst[3];

//in vec3 instVel[3];
//in float instAge[3];
//in float instRec[3];

out vec4 posG;
out vec3 normalG;
out vec3 normalWSG;
out vec2 uvG;
out vec3 tangentG;
out vec3 colorG;
out vec4 posW;
out vec4 posView;
out vec4 posInst;
out vec4 randG;
out vec3 mirrorG;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

uniform float furLength = 1.0;


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNorm;
layout(binding=2) uniform sampler2D texEnv;
layout(binding=3) uniform sampler2D texPrevFrame;
layout(binding=4) uniform sampler2D texDepth;

//layout(binding=0, offset=0) uniform atomic_uint ac;
//layout(binding=0, rgba32f) uniform image2D voxPosComp;
//layout(binding=1, rgba32f) uniform image2D voxNorComp;

uniform float g_instLayer = 0.0;

uniform float g_voxelAreaSize;

uniform float zNear = 0.1;
uniform float zFar = 1000.0;
// convert from 0.0 to 1.0 depth sample ds to linear depth
float linearDepth(float ds) {
    ds = 2.0*ds-1.0;
    float zLinear = 2.0*zNear*zFar/(zFar+zNear-ds*(zFar-zNear));
    return zLinear;
}

float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}

vec3 rotAroundAxis(vec3 vec, vec3 axis, float alpha) {
  float ca = cos(alpha);
  float sa = sin(alpha);
  float u = axis.x;
  float v = axis.y;
  float w = axis.z;
  vec3 rot;
  rot.x = u*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.x*ca+(-w*vec.y+v*vec.z)*sa;
  rot.y = v*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.y*ca+(w*vec.x-u*vec.z)*sa;
  rot.z = w*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.z*ca+(-v*vec.x+u*vec.y)*sa;
  return rot;
}

vec3 cross(vec3 a, vec3 b) {
  vec3 r;
  r.x = a.y*b.z - a.z*b.y;
  r.y = a.z*b.x - a.x*b.z;
  r.z = a.x*b.y - a.y*b.x;
  return r;
}

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}



uniform float g_voxelDim;

uniform vec4 g_cen;
uniform vec4 g_rot;
uniform vec4 g_rotDel;

uniform vec4 g_rotSingle = vec4(45.0, 13.0, 0.0, 0.0);
uniform float g_centroOfs = 0.0;
uniform vec4 g_centroAmpFreq = vec4(8.5, 1.3, 0.24, 0.143);
uniform float g_radRotDel = 0.0;
uniform float g_radDel = 0.0;

uniform float g_delOfs = 0.0;

uniform vec4 g_pos; // model matrix contains instanced model transform so this overall pos comes separated


uniform vec4 g_uvRandom;
uniform vec4 g_uvOfsRand;


uniform vec4 g_globalRot = vec4(0.0, 0.0, 0.0, 0.0); // .x: rotX, .y: rotY, .z: rotZ
uniform vec4 g_globalScale = vec4(1.0, 1.0, 1.0, 1.0);

uniform vec4 g_mirrorX = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorX on/off, .y: mirrorXPos, .z: mirrorXClip
uniform vec4 g_mirrorY = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorY on/off, .y: mirrorYPos, .z: mirrorYClip
uniform vec4 g_mirrorZ = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorZ on/off, .y: mirrorZPos, .z: mirrorZClip

uniform vec4 g_circularCen = vec4(0.0, 0.0, 0.0, 0.0);
uniform vec4 g_circularDist = vec4(0.0, 0.0, 0.0, 0.0);
uniform vec4 g_circularRot = vec4(0.0, 0.0, 0.0, 0.0);


uniform float g_mode = 1.0;
// modes
// 0.0 normal
// 1.0 point to target from breakin center




void main(void) {

        vec3 controlBase = vec3(0.0);

        float times = g_time*0.1;
       vec3 faceNormal = vec3(0.0);
        vec4 facePos = vec4(0.0);

        float vd2 = g_voxelDim*g_voxelDim;
        int vd3 = int(vd2*g_voxelDim);

           uint counter = inInst[0];

           float cf = float(counter)+g_delOfs;

           uint cy = counter/(vd3);
           uint cx = counter-uint(cy*vd3);
           ivec2 listCoord = ivec2(cx,cy);
           vec3 myInstPos = vec3(0.0);

         //  instG = myInstPos.x*1.0;
        float pMul = 2.0*3.141592/360.0;

        vec3 rot = ((g_rot+g_rotDel*cf).xyz)*pMul;
        vec3 rotSingle = g_rotSingle.xyz*cf*pMul;
        vec3 rotCirc = g_circularRot.xyz*pMul;


        float mirrorSX = 1.0;
        float mirrorSY = 1.0;
        float mirrorSZ = 1.0;

        float mirrorsOn = clamp(g_mirrorX.x, 0.0, 1.0)+clamp(g_mirrorY.x, 0.0, 1.0)+clamp(g_mirrorZ.x, 0.0, 1.0);
        int mirrorCount = 1+int(mirrorsOn*mirrorsOn);

        for (int mi = 0; mi < mirrorCount; mi++) {
            float fmi = float(mi);
            if (g_mirrorX.x > 0.5) { // x on
                mirrorSX = 1.0-fract(fmi*0.5)*4.0;
                if (g_mirrorY.x > 0.5) { // at least x & y on
                     mirrorSY = 1.0-fract(floor(fmi*0.5)*0.5)*4.0;
                    if (g_mirrorZ.x > 0.5) { // all x, y & z on
                        mirrorSZ = 1.0-fract(floor(floor(fmi*0.5)*0.5)*0.5)*4.0;
                    }
                } else {
                    if (g_mirrorZ.x > 0.5) { // x & z mirror
                        mirrorSZ = 1.0-fract(floor(fmi*0.5)*0.5)*4.0;
                    }
                }
            } else { // x off
                if (g_mirrorY.x > 0.5) { // y on
                    mirrorSY = 1.0-fract(fmi*0.5)*4.0;
                    if (g_mirrorZ.x > 0.5) { // also z on?
                        mirrorSZ = 1.0-fract(floor(fmi*0.5)*0.5)*4.0;
                    }
                } else { // only z mirror on?
                    if (g_mirrorZ.x > 0.5) {
                        mirrorSZ = 1.0-fract(fmi*0.5)*4.0;
                    }
                }
            }
            for (int i = 0; i < gl_in.length(); ++i) {
                    gl_Position = gl_in[i].gl_Position;

                    posInst = gl_Position+vec4(myInstPos, 1.0);
                    gl_Position = modelMatrix*gl_Position;
                    normalG = normal[i];
                    normalG = normalize((modelMatrix*(vec4(normalG, 0.0))).xyz);

                    //posMod = gl_Position;


                    posW = vec4(myInstPos, 1.0);


//                    posW.xyz -= g_circularCen.xyz;
//                    posW.xyz = rotateXY3(posW.xyz, rotCirc.x);
//                    posW.zxy = rotateXY3(posW.zxy, rotCirc.y);
//                    posW.yzx = rotateXY3(posW.yzx, rotCirc.z);
//                    posW.xyz += g_circularCen.xyz;
//                    posW.xyz += g_circularDist.xyz;

                    posW.xyz -= g_cen.xyz;

                    posW.xyz *= (1.0+cf*g_radRotDel*0.01);

                    posW.xyz = rotateXY3(posW.xyz, rot.x);
                    posW.zxy = rotateXY3(posW.zxy, rot.y);
                    posW.yzx = rotateXY3(posW.yzx, rot.z);

                    posW.xyz += g_cen.xyz;

                    posW.xyz *= g_centroOfs+g_centroAmpFreq.x*sin(cf*g_centroAmpFreq.z+g_centroAmpFreq.y*cos(cf*g_centroAmpFreq.w));
                    posW.xyz *= (1.0+cf*g_radDel*0.01);

                    vec3 posMod = gl_Position.xyz;

                    normalWSG = posW.xyz;

                    if (g_mode < 0.5) {
                      posMod.xyz -= g_circularCen.xyz;
                      posMod.xyz = rotateXY3(posMod.xyz, rotCirc.x);
                      posMod.zxy = rotateXY3(posMod.zxy, rotCirc.y);
                      posMod.yzx = rotateXY3(posMod.yzx, rotCirc.z);
                      posMod.xyz += g_circularCen.xyz;
                      posMod.xyz += g_circularDist.xyz;

                      posMod.xyz = rotateXY3(posMod.xyz, rotSingle.x);
                      posMod.zxy = rotateXY3(posMod.zxy, rotSingle.y);
                      posMod.yzx = rotateXY3(posMod.yzx, rotSingle.z);

                      posMod.xyz -= g_cen.xyz;
                      posMod.xyz = rotateXY3(posMod.xyz, rot.x);
                      posMod.zxy = rotateXY3(posMod.zxy, rot.y);
                      posMod.yzx = rotateXY3(posMod.yzx, rot.z);
                      posMod.xyz += g_cen.xyz;

                      posW.xyz += posMod;
                    } else if (g_mode < 1.5) {

                      vec3 posTar = posW.xyz;

                      float an1 = atanSafe(posTar.y, posTar.x);
                      float an2 = acos(posTar.z);

                      posMod.xyz -= g_circularCen.xyz;
                      posMod.xyz = rotateXY3(posMod.xyz, an1);
                      posMod.xzy = rotateXY3(posMod.xzy, an2);
                      posW.xyz = vec3(0.0)+posMod;

                      normalWSG.xyz = vec3(0.0, -1.0, 0.0);
                      normalWSG.xyz = rotateXY3(normalWSG.xyz, an1);
                      normalWSG.xzy = rotateXY3(normalWSG.xzy, an2);


                    }

                    posW.xyz += g_pos.xyz;

                    normalG.xyz = rotateXY3(normalG.xyz, rotCirc.x);
                    normalG.zxy = rotateXY3(normalG.zxy, rotCirc.y);
                    normalG.yzx = rotateXY3(normalG.yzx, rotCirc.z);

                    normalG.xyz = rotateXY3(normalG.xyz, rot.x+rotSingle.x);
                    normalG.zxy = rotateXY3(normalG.zxy, rot.y+rotSingle.y);
                    normalG.yzx = rotateXY3(normalG.yzx, rot.z+rotSingle.z);


    //                vec3 zVec = vec3(0.0, 0.0, 1.0);
    //                float dotsi = dot(vnc.rgb, zVec);
    //                //   if (abs(dotsi)>0.005) {
    //                        vec3 rotAxis = normalize(cross(vnc.rgb, zVec));
    //                        //rotAxis = normalize(rotAxis);
    //                        float angle = acos(dotsi)+3.14*1.0;
    //                        //float length = sqrt(dot(vPosTrans.xyz, vPosTrans.xyz));
    //                        //vPosTrans.xyz/=length;
    //                        gl_Position.xyz = rotAroundAxis(gl_Position.xyz, rotAxis, -angle*1.0);
    //                        normalG = rotAroundAxis(normalG, rotAxis, -angle*1.0);
    //                //   }

                  //  vec4 modpos = gl_Position + vec4(myInstPos, 1.0);
                  //  modpos.xyz *= g_voxelAreaSize;

                    posW.xyz -= g_pos.xyz;
                    posW = rotateYZ(posW, g_globalRot.x);
                    posW = rotateXZ(posW, g_globalRot.y);
                    posW = rotateXY(posW, g_globalRot.z);

                    normalWSG = rotateYZ(vec4(normalWSG, 0.0), g_globalRot.x).xyz;
                    normalWSG = rotateXZ(vec4(normalWSG, 0.0), g_globalRot.y).xyz;
                    normalWSG = rotateXY(vec4(normalWSG, 0.0), g_globalRot.z).xyz;


                    posW.xyz *= g_globalScale.x;

                    posW.xyz += g_pos.xyz;

                    posW.xyz -= vec3(g_mirrorX.y, g_mirrorY.y, g_mirrorZ.y);
                    posW.x *= mirrorSX;
                    posW.y *= mirrorSY;
                    posW.z *= mirrorSZ;
                    posW.xyz += vec3(g_mirrorX.y, g_mirrorY.y, g_mirrorZ.y);

                    mirrorG = vec3(mirrorSX, mirrorSY, mirrorSZ);

                    normalG = rotateYZ3(normalG, g_globalRot.x);
                    normalG = rotateXZ3(normalG, g_globalRot.y);
                    normalG = rotateXY3(normalG, g_globalRot.z);

                    gl_Position = viewMatrix*(posW);

                    posView = gl_Position;

                    //colorG = vec3(vnc.rgb);
                    colorG = vec3(1.0);

                    gl_Position.xyz -= normal[i]*0.0;
                    facePos += origPos[i];

                    float depu = 0.0;
                    vec3 ssNormal = vec3(0.0);

                 //   normalWSG = (vec4(normalG, 0.0)).xyz;
                    normalG = (viewMatrix * vec4(normalG, 0.0)).xyz;

                    gl_Position = projectionMatrix*gl_Position;

                    posG = gl_Position;

                    faceNormal += normal[i];
                    uvG = uv[i];
                    tangentG = tangent[i];

                    float inste = inInst[0];
                    randG.x = g_uvRandom.x*rand(vec2(inste*0.73, 0.5+inste*0.216));
                    randG.y = g_uvOfsRand.x*rand(vec2(inste*0.123, 0.25+inste*1.216));
                    randG.z = g_uvOfsRand.y*rand(vec2(inste*0.543, 0.65+inste*0.332));
                    randG.w = inste;

                    // posG = vec4(instG);
                    EmitVertex();
            }
            EndPrimitive();
        }
        facePos /= 3.0;



}
