import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


Group {
    id: waterPartikles
    name: "waterPart"
    property string forceName: "waterForce"
    property int particleCount: 0
    property bool drawEnabled: true

    property int maxParticles: 1000*1000
    property int drawParticles: 10

    property string emitShader: "smEmitter"

    enabled: syncRoot(waterPartikles.name+".ON")

    onParticleCountChanged: {
        root.setCustomText("WaterPartikles", "WaterPartikles: "+waterPartikles.name, "Particle count:"+particleCount);
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "emittedPartPos"
            format: "RGBA16F"
            width: windowWidth*2
            height: windowHeight*2
        }
    }
    ShaderAtomicCounter { name: "sac1"; clear: true }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }

    Shader { file: sceneDir+emitShader }



    TextureImage {
        textureUnit: 0
        file: "../../images/gas1.png"
    }

    // draw the given meshes (as given by the WaterPartikles parameters!)
    property alias emitMesh: dm.delegate
    Repeater {
        id: dm
        model: 1
    }

    Blit {
        enabled: drawEnabled
        textureRT: "bg"
        blitRT: 0
    }

    ShaderAtomicCounter { name: "sac1" }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }

    PartSim {
        name: waterPartikles.name
        forceName: waterPartikles.forceName
        simShader: "simPart"
        //drawShader: "partBalls"
        //drawBlendMode: "off"
        drawEnabled: waterPartikles.drawEnabled
        drawShader: "partWater"
        drawBlendMode: "add"

        onParticleCountChanged: {
            waterPartikles.particleCount = particleCount;
        }

        // max particles count is gridDimension*gridDimension
        // CHANGE PROPOSAL: make a new parameter maxPoints instead...
        gridDimension: Math.sqrt(maxParticles)

        // This is actually the number of points drawn for the first frame
        // of the simulation (or when reset).
        // As after that, the simulation will continue with own number of particles
        // as some particles might die and others might emit new ones...
        // CHANGE PROPOSAL: because of the above explanation, change this variable name to
        // initNumPoints instead ...
        drawNumPoints: drawParticles

        partSize: sync(waterPartikles.name+".partSize")
        //  partEmitShapeImage: "../../images/black.png"
        //partEmitShapeImage: "../../images/PinkMedusa.png"
    }

    Group {
        enabled: waterPartikles.drawEnabled
        Blit {
            textureRT: "prevFrame"
        }
        Blit {
            textureRT: "prevFrame2"
            blitRT: 1
        }
        Texture {
            textureUnit: 0
            textureRT: "prevFrame"
        }
        Texture {
            textureUnit: 1
            textureRT: "bg"
            //textureRT: "depth"
        }
        Texture {
            textureUnit: 2
            textureRT: "prevFrame2"
        }
        Shader {
            //file: sceneDir+"mixBalls"
            file: sceneDir+"mixWater"
        }
        DrawVB {
            ShaderParam {
                paramName: "flip"
                paramValue: 0.0
            }
            ShaderParam {
                paramName: "g_bgAmount"; paramValue: sync(waterPartikles.name+".bgAmount")
            }
            ShaderParam {
                paramName: "g_lightAmount"; paramValue: sync(waterPartikles.name+".lightAmount")
            }
            ShaderParam {
                paramName: "g_waterClip"; paramValue: sync(waterPartikles.name+".waterClip")
            }
            ShaderParam {
                paramName: "g_bumpStrength"; paramValue: sync(waterPartikles.name+".bumpStrength")
            }
            type: "quad"
            depthTest: false
            depthWrite: false
            drawBuffers: 2
        }
    }
}

