import QtQuick 2.3
import "../"
import AdaptDemoSystem 1.0

Group {
    name: "TextureImage"
    id: blit
    property string file
	property int textureUnit: 0
    effectDetails: file

    property alias texWidth: texture.tw
    property alias texHeight: texture.th

    property string textureWrap: "repeat"

    property alias textureRT: texture.textureRT

    Texture {
        id: texture
        textureUnit: blit.textureUnit
        textureItem: tekstuuri
        textureWrap: blit.textureWrap

        property int tw: textureRT === "" ? tekstuuri.sourceSize.width : texture.textureWidth
        property int th: textureRT === "" ? tekstuuri.sourceSize.height : texture.textureHeight

        Image {
            id: tekstuuri
            enabled: texture.textureRT === ""
         //   asynchronous: true
            visible: false
            source: blit.file
            cache: true
          //  cache: root.bReleaseVer
            onSourceChanged: {
                parent.textureItem = null;
                parent.textureItem = tekstuuri;
            }
        }
    }

}

