import QtQuick 2.3
import "../" // to import RocketScene
import AdaptDemoSystem 1.0

Camera {
    id: kamera
    property string name: "camera"
    effectName: "ShakyCamera"

    property real camShakePosAmp: 0.0
    property real camShakeLookAtAmp: 0.0
    property real camShakeFreq: 0.0

    property real camUpSign: 1.0

    property real time: 0.0
    Component.onCompleted: {
        time = 10000.0
    }
    Behavior on time {
        NumberAnimation { duration: 10000*1000 }
    }
    onTimeChanged: {
        if (!rocket.isPaused) {
            kamera.shakeTime += 0.001*kamera.camShakeFreq*rocket.timeStep;
        }
    }
    property real shakeTime: 0.0

    x: sync(name + ".x")+camShakePosAmp*0.10*Math.sin(kamera.shakeTime)
    y: (sync(name + ".y")+camShakePosAmp*0.10*Math.cos(kamera.shakeTime*2.30))*camUpSign
    z: sync(name + ".z")
    lookAtX: sync(name + ".lookAtX")+camShakeLookAtAmp*0.30*Math.cos(kamera.shakeTime*0.312)
    lookAtY: (sync(name + ".lookAtY")+camShakeLookAtAmp*0.20*Math.sin(kamera.shakeTime*0.10))*camUpSign
    lookAtZ: sync(name + ".lookAtZ")


    pitchLA: sync(name + ".pitchLA")
    yawLA: sync(name + ".yawLA")

    property real camUpX: sync(name+".upX")
    property real camUpY: sync(name+".upY")


    property real camRoll: sync(name+".roll")
    upX: Math.sin(camRoll)*camUpY+Math.cos(camRoll)*camUpX
    upY: (Math.cos(camRoll)*camUpY-Math.sin(camRoll)*camUpX)*camUpSign
    upZ: sync(name+".upZ")

}
