import QtQuick 2.3
import "../"
import AdaptDemoSystem 1.0

Group {
    id: variClock
    property real time: resetTime
    property real clockSpeed: 1.0
    property real resetTime: 0.0

    signal resetDone()

    Connections {
        target: demo; onFrameRendered: {
            variClock.time += (rocket.timeStep*0.001)*clockSpeed;
        }
    }

    property real reset: -999999.0
    onResetChanged: {
      //  if (reset) {
      time = resetTime;
        resetDone();
      //  }
    }

    property bool triggerReset: false
    onTriggerResetChanged: {
        if (triggerReset) {
            time = resetTime;
        }
    }

}

