import QtQuick 2.4
import AdaptDemoSystem 1.0

Group {
    id: box
    name: "gen"
    property string bn: box.name
    enabled: syncRoot(box.name+".ON")

    property string shaderVaryings: "
        vec3 posG;
        vec3 normalG;
        vec2 uvG;
        vec3 tangentG;"

    VariClockTrigger {
        id: animFrame
        clockSpeed: sync(box.name+".anim.FPS", 0.0)
        reset: syncTrigger(box.name+".anim.reset")
    }
    property real animFramesPerRow: sync(box.name+".anim.numCols", 1.0)
    property real animRows: sync(box.name+".anim.numRows", 1.0)
    property int animFrames: Math.max(1.0, sync(box.name+".anim.frames", 1.0))
    property int animLoopFadeFrames: sync(box.name+".anim.loopFadeFrames", 1.0)
    property int animFrameInt: (animFrame.time.toFixed(0)/animFrames-Math.floor(animFrame.time.toFixed(0)/animFrames))*(animFrames-1)
//    property real animFrameUVX: (animFrameInt/animFramesPerRow-Math.floor(animFrameInt/animFramesPerRow))*animFramesPerRow*sync(box.name+".anim.width", 1.0/6.0)
//    property real animFrameUVY: Math.floor(animFrameInt/animFramesPerRow)*sync(box.name+".anim.height", 1.0/6.0)

    property real uvScale: sync(box.name+".uvScale", 1.0);

    Texture { textureUnit: 0; imageUnit: 0; textureRT: "velBuf" }

    TextureSel { name: box.name }
    TextureSel { name: box.name; textureUnit: 1 }
    TextureSel { name: box.name; textureUnit: 6 }

    Texture { textureUnit: 7;  textureRT: "mainDepth" }
    TextureImage { textureUnit: 8;  file: "../../images/system/random16.png" }
    Shader { file: {
            var v = sync(box.name+".shaderIndex");
            if (v===0) return "smGen";
         //   if (v===2) return "smGen";
            return "smGen"
        }
    }

  //  property int gWidth: 1000

/*
    DrawVB {
 //   DrawMesh {
        property string name: box.name
      //  file: meshSel(box.name)
        depthTest: sync(box.name+".depthEnabled", 1.0) > 0.5
        depthWrite: depthTest
        blendMode: blendSel(box.name)

        type: "pointGridDraw"
        primType: "triangles"
        vboId: sceneName+box.name
        tfVaryings: box.shaderVaryings
        gridWidth: 100; gridHeight: 1000
        drawNumPoints: gridWidth*gridHeight

     //   cull: false; cullBack: false


    //    smoothNormals: true; normalSmoothAngle: 80;

        Pos { x: syncOsc(box.name+".posX"); y: syncOsc(box.name+".posY"); z: syncOsc(box.name+".posZ")}
        Rot { d: sync(box.name+".rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync(box.name+".rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sync(box.name+".rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync(box.name+".scale"); x: sync(box.name+".scaX"); y: sync(box.name+".scaY"); z: sync(box.name+".scaZ") }

        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(box.name+".bright", 1.0) }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync(box.name+".ambient", 0.1) }
      //  ShaderParam { paramName: "g_uvScale"; paramValue: sync(box.name+".uvScale", 1.0) }
        ShaderParam { paramName: "g_uvScale"; paramValueVec4: (uvScale*sync(box.name+".uvScaleX", 1.0))+","+(uvScale*sync(box.name+".uvScaleY", 1.0))}
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(box.name+".prevBlur", 0.5) }
        ShaderParam { paramName: "g_prevBlurType"; paramValue: sync(box.name+".prevBlurType") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(box.name+".bump", 0.25) }
        ShaderParam { paramName: "g_genUV"; paramValue: sync(box.name+".genUV", 1.0) }
        ShaderParam { paramName: "g_alpha"; paramValue: sync(box.name+".alpha", 1.0) }
        ShaderParam { paramName: "g_alphaSub"; paramValue: sync(box.name+".alphaSub", 0.0) }

        ShaderParam { paramName: "g_mulTexAmp"; paramValue: sync(box.name+".mulTexAmp") }

        ShaderParam { paramName: "g_emitThr"; paramValue: sync(box.name+".palaEmitThr", 0.0) }
        ShaderParam { paramName: "g_emitAmp"; paramValue: syncFFT(box.name+".palaEmitAmp", 1.0) }

        ShaderParam { paramName: "g_uvOfsX"; paramValue: sync(box.name+".uvOfsX", 0.0) }
        ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(box.name+".uvOfsY", 0.0) }


        ShaderParam { paramName: "g_animInfo"; paramValueVec4: animFramesPerRow+","+animFrames+","+animRows+","+animFrameInt }
        ShaderParam { paramName: "g_animLoopFadeFrames"; paramValue: animLoopFadeFrames }
        //ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(box.name+".uvOfsY", 0.0) }

//        SavePoint {
//            target: meshInst.name+"_SP"
//            x: meshInst.posX+sync(meshInst.name+".spx")/meshInst.sca; y: meshInst.posY/meshInst.sca+sync(meshInst.name+".spy"); z: meshInst.posZ/(meshInst.sca*meshInst.scaZ)+sync(meshInst.name+".spz");
//        }

    }



*/
    property int objMirror: sync(bn+".obj.mirror")+1.0

    DrawMesh {
        property string name: box.name
        file: meshSel(box.name)
        depthTest: sync(box.name+".depthEnabled", 1.0) > 0.5
        depthWrite: depthTest
        blendMode: blendSel(box.name)

        smoothNormals: true; normalSmoothAngle: 80;

        Pos { x: syncOsc(box.name+".posX"); y: syncOsc(box.name+".posY"); z: syncOsc(box.name+".posZ")}
        Rot { d: sync(box.name+".rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync(box.name+".rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sync(box.name+".rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync(box.name+".scale"); x: sync(box.name+".scaX"); y: sync(box.name+".scaY"); z: sync(box.name+".scaZ") }

        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(box.name+".bright", 1.0) }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync(box.name+".ambient", 0.1) }
      //  ShaderParam { paramName: "g_uvScale"; paramValue: sync(box.name+".uvScale", 1.0) }
        ShaderParam { paramName: "g_uvScale"; paramValueVec4: (uvScale*sync(box.name+".uvScaleX", 1.0))+","+(uvScale*sync(box.name+".uvScaleY", 1.0))}
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(box.name+".prevBlur", 0.5) }
        ShaderParam { paramName: "g_prevBlurType"; paramValue: sync(box.name+".prevBlurType") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(box.name+".bump", 0.25) }
        ShaderParam { paramName: "g_genUV"; paramValue: sync(box.name+".genUV", 1.0) }
        ShaderParam { paramName: "g_alpha"; paramValue: sync(box.name+".alpha", 1.0) }
        ShaderParam { paramName: "g_alphaSub"; paramValue: sync(box.name+".alphaSub", 0.0) }

        ShaderParam { paramName: "g_mulTexAmp"; paramValue: sync(box.name+".mulTexAmp") }

        ShaderParam { paramName: "g_emitThr"; paramValue: sync(box.name+".palaEmitThr", 0.0) }
        ShaderParam { paramName: "g_emitAmp"; paramValue: syncFFT(box.name+".palaEmitAmp", 1.0) }

        ShaderParam { paramName: "g_uvOfsX"; paramValue: sync(box.name+".uvOfsX", 0.0) }
        ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(box.name+".uvOfsY", 0.0) }


        ShaderParam { paramName: "g_animInfo"; paramValueVec4: animFramesPerRow+","+animFrames+","+animRows+","+animFrameInt }
        ShaderParam { paramName: "g_animLoopFadeFrames"; paramValue: animLoopFadeFrames }


        ShaderParam { paramName: "rsty_xz"; paramValueVec4: sync(bn+".rotStatic.xz")+","+sync(bn+".rotTime.xz")+","+sync(bn+".rotY.xz")+","+sync(bn+".rotY.xz.phase") }
        ShaderParam { paramName: "rsty_yz"; paramValueVec4: sync(bn+".rotStatic.yz")+","+sync(bn+".rotTime.yz")+","+sync(bn+".rotY.yz")+","+sync(bn+".rotY.yz.phase") }
        ShaderParam { paramName: "rsty_xy"; paramValueVec4: sync(bn+".rotStatic.xy")+","+sync(bn+".rotTime.xy")+","+sync(bn+".rotY.xy")+","+sync(bn+".rotY.xy.phase") }
        ShaderParam { paramName: "rcObj"; paramValueVec4: sync(bn+".obj.rows")+","+sync(bn+".obj.cols")+","+sync(bn+".obj.index")+","+sync(bn+".draw.texHeight") }
        ShaderParam { paramName: "scale"; paramValueVec4: sync(bn+".obj.scaleX")+","+sync(bn+".obj.scaleY")+","+sync(bn+".obj.scaleZ")+","+sync(bn+".obj.scale") }
        ShaderParam { paramName: "scale"; paramValueVec4: sync(bn+".obj.scaleX")+","+sync(bn+".obj.scaleY")+","+sync(bn+".obj.scaleZ")+","+sync(bn+".obj.scale") }
        ShaderParam { paramName: "objParams"; paramValueVec4: objMirror+","+sync(bn+".obj.mirrorX")+","+sync(bn+".obj.mirrorY")+","+sync(bn+".obj.mirrorZ") }
        ShaderParam { paramName: "objParams2"; paramValueVec4: sync(bn+".obj.mirrorClipX")+","+sync(bn+".obj.mirrorClipY")+","+sync(bn+".obj.mirrorClipZ")+","+sync(bn+".obj.mirrorStartAxis") }
        ShaderParam { paramName: "walker"; paramValueVec4: sync(bn+".obj.walker.legLen1")+","+sync(bn+".obj.walker.legLen2")+","+sync(bn+".obj.walker.legDist")+","+sync(bn+".obj.walker.legLift") }
        ShaderParam { paramName: "walker2"; paramValueVec4: sync(bn+".obj.walker.legRad1")+","+sync(bn+".obj.walker.legRad2")+","+sync(bn+".obj.walker.bodyLift")+","+sync(bn+".obj.walker.bodyLiftVar") }
        ShaderParam { paramName: "walker3"; paramValueVec4: sync(bn+".obj.walker.bodyLiftVFreq1")+","+sync(bn+".obj.walker.bodyLiftVar2")+","+sync(bn+".obj.walker.bodyLiftVFreq2")+","+sync(bn+".obj.walker.bodyLiftRepVar") }
        ShaderParam { paramName: "walker4"; paramValueVec4: sync(bn+".obj.walker.legPhaseFreq")+",0.0,0.0,0.0" }

        ShaderParam { paramName: "repMov"; paramValueVec4: sync(bn+".repX")+","+sync(bn+".repZ")+","+sync(bn+".repMoveX")+","+sync(bn+".repMoveZ") }
        ShaderParam { paramName: "repGroup"; paramValueVec4: sync(bn+".repGroupCount")+","+sync(bn+".repGroupGap")+",0.0,0.0" }

        ShaderParam { paramName: "repRand"; paramValueVec4: sync(bn+".repRand.posX")+","+sync(bn+".repRand.posY")+","+sync(bn+".repRand.posZ")+","+sync(bn+".repRand.scaleY") }
        ShaderParam { paramName: "repRand2"; paramValueVec4: sync(bn+".repRand.rotX")+","+sync(bn+".repRand.rotY")+","+sync(bn+".repRand.scale")+",0.0" }

        ShaderParam { paramName: "genCurve"; paramValueVec4: sync(bn+".curve.mode")+","+sync(bn+".curve.rad1")+","+sync(bn+".curve.rad2")+","+sync(bn+".curve.freq") }
        ShaderParam { paramName: "genCurve2"; paramValueVec4: sync(bn+".curve.freq2")+","+sync(bn+".curve.straightMix")+",0.0,0.0" }

        ShaderParam { paramName: "genHeight"; paramValueVec4: sync(bn+".draw.heightClamp")+","+sync(bn+".draw.heightOffset")+","+sync(bn+".draw.heightMin")+","+sync(bn+".draw.heightMax") }
        ShaderParam { paramName: "genHeight2"; paramValueVec4: sync(bn+".draw.heightPow")+","+"0.0,0.0,0.0" }

        ShaderParam { paramName: "pos"; paramValueVec4: sync(bn+".obj.posX")+","+sync(bn+".obj.posY")+","+sync(bn+".obj.posZ")+",0.0" }
        ShaderParam { paramName: "prePos"; paramValueVec4: sync(bn+".obj.prePosX")+","+sync(bn+".obj.prePosY")+","+sync(bn+".obj.prePosZ")+",0.0" }

        //ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(box.name+".uvOfsY", 0.0) }

//        SavePoint {
//            target: meshInst.name+"_SP"
//            x: meshInst.posX+sync(meshInst.name+".spx")/meshInst.sca; y: meshInst.posY/meshInst.sca+sync(meshInst.name+".spy"); z: meshInst.posZ/(meshInst.sca*meshInst.scaZ)+sync(meshInst.name+".spz");
//        }

    }


}
