import QtQuick 2.3
import AdaptDemoSystem 1.0

import Qt.labs.settings 1.0

Group {
  id: camera
  name: "camera"
  effectName: "Camera"
  enabled: syncRootOn(name, effectName, 1.0);

  property bool hasCamOverride: false
  onHasCamOverrideChanged: {
    updateCamOverrideDisplay();
  }
  property vector3d camOfs: Qt.vector3d(0.0, 0.0, 0.0)

  property vector3d camPos: Qt.vector3d(0.0, 0.0, 0.0)
  property vector3d camPosOrig: Qt.vector3d(0.0, 0.0, 0.0)
  property vector3d camLookAt: Qt.vector3d(0.0, 0.0, 0.0)
  property vector3d camUp: Qt.vector3d(0.0, 0.0, 0.0)
  property vector3d camUpOrig: Qt.vector3d(0.0, 0.0, 0.0)
  property vector3d camLookDir: Qt.vector3d(0.0, 0.0, 0.0)
  property vector3d camLookDirOrig: Qt.vector3d(0.0, 0.0, 0.0)
  property vector3d camRotAxis: Qt.vector3d(0.0, 0.0, 0.0)

  property vector3d camRightNorm: Qt.vector3d(0.0, 0.0, 0.0)
  property vector3d camUpNorm: Qt.vector3d(0.0, 0.0, 0.0)

  property bool smoothInited: false
  property vector3d camPosSmooth: Qt.vector3d(0.0, 0.0, 0.0)
  property vector3d camLookAtSmooth: Qt.vector3d(0.0, 0.0, 0.0)
  property vector3d camUpSmooth: Qt.vector3d(0.0, 0.0, 0.0)

  property vector3d camPosCache: Qt.vector3d(0.0, 0.0, 0.0)
  property bool camPosCacheDirty: true
  property vector3d camLookAtCache: Qt.vector3d(0.0, 0.0, 0.0)
  property bool camLookAtCacheDirty: true
  property vector3d camUpCache: Qt.vector3d(0.0, 0.0, 0.0)
  property bool camUpCacheDirty: true



  Settings {
    property alias flyCamSpeed: camera.flyCamSpeed
    property alias hasCamOverride: camera.hasCamOverride
    property alias camPos: camera.camPos
    property alias camUp: camera.camUp
    property alias camLookAt: camera.camLookAt
  }



  property real camMoveStep: 0.1*flyCamSpeed
  property real camMoveStepBase: 0.1*flyCamSpeed
  property real rotSpeed: 0.5
  property real rotSpeedBase: 0.5

  property bool camAutoUpdate: false

  property bool bFlyCamActive: true
  property bool bFlyCamFromIndexActive: false

  property bool keepCamUp: false

  property bool bAltDown: false
  property bool bShiftDown: false
  property bool bCtrlDown: false
  property bool bIDown: false
  property bool bFDown: false

  property bool bMinusDown: false
  property bool bPlusDown: false

  property bool bLeftPressed: false
  property bool bRightPressed: false
  property bool bUpPressed: false
  property bool bDownPressed: false

  property int mousePressX: 0
  property int mousePressY: 0
  property bool mousePressed: false


  property real resX: 0.0
  property real resY: 0.0


  property bool bDisplayInited: false


  property int flyCamMode: 1

  //    onBFDownChanged: {
  //        if (bFDown) {
  //            flyCamMode++;
  //            if (flyCamMode>3) {
  //                flyCamMode = 0;
  //            }
  //            if (flyCamMode == 0) {
  //                bFlyCamActive = false;
  //            } else {
  //                bFlyCamActive = true;
  //            }

  //            root.setFlyCamMode(flyCamMode);

  //            root.setCustomText("fly camera", "fly camera active", "<b>F</b>: mode="+flyCamMode);
  //        }
  //    }

  property real flyCamSpeed: 1.0

  onBMinusDownChanged: {
    if (bMinusDown) {
      if (flyCamSpeed > 0.1) {
        flyCamSpeed *= 0.5;
        updateSpeedDisplay();
      }
    }
  }
  onBPlusDownChanged: {
    if (bPlusDown) {
      if (flyCamSpeed < 20.0) {
        flyCamSpeed *= 2.0;
        updateSpeedDisplay();
      }
    }
  }

  function updateSpeedDisplay() {
    if (flyCamSpeed < 1.0) {
      root.setCustomText("fly camera", "fly camera speed", "<b>+/-</b>: Speed "+flyCamSpeed.toFixed(2)+"x");
    } else if (flyCamSpeed < 0.2) {
      root.setCustomText("fly camera", "fly camera speed", "<b>+/-</b>: Speed "+flyCamSpeed.toFixed(3)+"x");
    } else {
      root.setCustomText("fly camera", "fly camera speed", "<b>+/-</b>: Speed "+flyCamSpeed.toFixed(0)+"x");
    }
  }

  function updateUpModeDisplay() {
    if (keepCamUp) {
      root.setCustomText("fly camera", "fly camera up", "<b>U</b>: Up vector force ON");
    } else {
      root.setCustomText("fly camera", "fly camera up", "<b>U</b>: Up vector force OFF");
    }
  }
  function updateCamOverrideDisplay() {
    if (hasCamOverride) {
      root.setCustomText("fly camera", "fly camera active", "<br>Camera override active<br><b>R</b>: Sync to rocket<br><b>C</b>: Clear modifications");
    } else {
      root.setCustomText("fly camera", "fly camera active", "");
    }
  }

  onEffectRender: {
    if (hasCamOverride) {
      if (!smoothInited) {
        camPosSmooth = camPos;
        camLookAtSmooth = camLookAt;
        camUpSmooth = camUp;
        smoothInited = true;
      }
      camPosCache = camPosSmooth;
      camLookAtCache = camLookAtSmooth;

      camPosCache.x = (camPosCache.x-camLookAtCache.x)*camDist+camLookAtCache.x;
      camPosCache.y = (camPosCache.y-camLookAtCache.y)*camDist+camLookAtCache.y;
      camPosCache.z = (camPosCache.z-camLookAtCache.z)*camDist+camLookAtCache.z;

      camUpCache = camUpSmooth;
    } else {
      camPosCache = getCamPos();
      camLookAtCache = getCamLookAt();

      camPosCache.x = (camPosCache.x-camLookAtCache.x)*camDist+camLookAtCache.x;
      camPosCache.y = (camPosCache.y-camLookAtCache.y)*camDist+camLookAtCache.y;
      camPosCache.z = (camPosCache.z-camLookAtCache.z)*camDist+camLookAtCache.z;

      camUpCache = getCamUp();
    }
  }

  Connections {
    target: demo;
    onFrameRendered: {


      if (bFlyCamActive || bFlyCamFromIndexActive) {

        if (flyCamMode == 3 || (bFlyCamFromIndexActive && flyCamMode !== 1)) { // follow mode!
          activateCamOverride();
          var cd = Qt.vector3d(followPX, followPY, followPZ);
          cd = cd.minus(camLookAt);
          cd = cd.plus(getCamLookAtRocket());
          camLookAt = camLookAt.plus(cd.times(camMoveStep));

          cd = Qt.vector3d(followPX*1.05, followPY*1.05, followPZ*1.05);
          cd = cd.minus(camPos);
          cd = cd.plus(getCamPosRocket());
          camPos = camPos.plus(cd.times(camMoveStep));

          updateCam();
        }

        if (flyCamMode == 1) {

          if (bLeftPressed) {
            activateCamOverride();
            if (bShiftDown) {
              if (bCtrlDown) {
                camUp = rotateAxis(camUp, camLookDir, 1.0*rotSpeed);
              } else {
                camUp = rotateAxis(camUp, camLookDir, 5.0*rotSpeed);
              }
            } else {
              camPos = camPos.minus(camRightNorm.times(camMoveStep));
              camLookAt = camLookAt.minus(camRightNorm.times(camMoveStep));
            }
            updateCam();
          }
          if (bRightPressed) {
            activateCamOverride();
            if (bShiftDown) {
              if (bCtrlDown) {
                camUp = rotateAxis(camUp, camLookDir, -1.0*rotSpeed);
              } else {
                camUp = rotateAxis(camUp, camLookDir, -5.0*rotSpeed);
              }
            } else {
              camPos = camPos.plus(camRightNorm.times(camMoveStep));
              camLookAt = camLookAt.plus(camRightNorm.times(camMoveStep));
            }
            updateCam();
          }
          if (bUpPressed) {
            activateCamOverride();
            if (bShiftDown) {
              camPos = camPos.plus(camUpNorm.times(camMoveStep));
              camLookAt = camLookAt.plus(camUpNorm.times(camMoveStep));
            } else {
              camPos = camPos.plus(camLookDir.times(camMoveStep));
              camLookAt = camLookAt.plus(camLookDir.times(camMoveStep));
            }
            updateCam();
          }
          if (bDownPressed) {
            activateCamOverride();
            if (bShiftDown) {
              camPos = camPos.minus(camUpNorm.times(camMoveStep));
              camLookAt = camLookAt.minus(camUpNorm.times(camMoveStep));
            } else {
              camPos = camPos.minus(camLookDir.times(camMoveStep));
              camLookAt = camLookAt.minus(camLookDir.times(camMoveStep));
            }
            updateCam();
          }
        }
      }

      if (!bDisplayInited) {
        root.setCustomText("fly camera", "fly camera title", "<br>------------------------------------<br>Fly camera settings (<b>F2</b> hide)");
        updateUpModeDisplay();
        updateCamOverrideDisplay();
        updateSpeedDisplay();
        root.setCustomText("fly camera", "fly camera footer", "------------------------------------<br>");
        bDisplayInited = true;
      }

      var camMoveMult = rocket.getFrameTimeSmooth()/16.67;
      camMoveStep = camMoveStepBase*camMoveMult;
      rotSpeed = rotSpeedBase*camMoveMult;

      // var smoothMult = (1.0-Math.min(rocket.timeStepReal, 900)*0.001)*0.5;
      var smoothMult = Math.pow((1.0-0.01667)*0.5, 16.67/rocket.getFrameTimeSmooth());
      camPosSmooth = camPosSmooth.plus(camPos.minus(camPosSmooth).times(smoothMult));
      camLookAtSmooth = camLookAtSmooth.plus(camLookAt.minus(camLookAtSmooth).times(smoothMult));
      camUpSmooth = camUpSmooth.plus(camUp.minus(camUpSmooth).times(smoothMult));

//      camPosCacheDirty = true;
//      camLookAtCacheDirty = true;
//      camUpCacheDirty = true;
    }
  }


  function rotateXY(x, y, a) {
    resX = Math.cos(a)*x - Math.sin(a)*y;
    resY = Math.sin(a)*x + Math.cos(a)*y;
  }

  /// Rotate position p around given axis ax for given angle a degrees.
  /// The axis has to be normalized.
  function rotateAxis(p, ax, a) {
    var result = Qt.vector3d(0.0, 0.0, 0.0);
    a = a*Math.PI/180.0;

    var cosa = Math.cos(a);
    var sina = Math.sin(a);
    var mcosa = 1.0-cosa;

    var x = p.x; var y = p.y; var z = p.z;
    var u = ax.x; var v = ax.y; var w = ax.z;
    var dot = p.dotProduct(ax);

    result.x = u*dot*mcosa+x*cosa+(-w*y+v*z)*sina;
    result.y = v*dot*mcosa+y*cosa+(w*x-u*z)*sina;
    result.z = w*dot*mcosa+z*cosa+(-v*x+u*y)*sina;

    return result;
  }

  function updateCamVecs() {
    camLookDir = camLookAt.minus(camPos);
    camLookDir = camLookDir.normalized();
    camRightNorm = camLookDir.crossProduct(camUp);
    camRightNorm = camRightNorm.normalized();
    if (!keepCamUp) {
      camUp = camRightNorm.crossProduct(camLookDir);
    }
    camUpNorm = camRightNorm.crossProduct(camLookDir).normalized();
  }

  function activateCamOverride() {
    rocket.markUpdateFrequent();
    if (!hasCamOverride) {
      camPos = getCamPos();
      camLookAt = getCamLookAt();
      camUp = getCamUp();
      hasCamOverride = true;
    }
    updateCamVecs();
  }

  function updateCam() {
    if (camAutoUpdate) {
      saveCamToRocket();
    }
  }

  function saveCamToRocket() {
//    rocket.setTrackValue(sceneName+".camera.x", camPos.x);
//    rocket.setTrackValue(sceneName+".camera.y", camPos.y);
//    rocket.setTrackValue(sceneName+".camera.z", camPos.z);
//    rocket.setTrackValue(sceneName+".camera.lookAtX", camLookAt.x);
//    rocket.setTrackValue(sceneName+".camera.lookAtY", camLookAt.y);
//    rocket.setTrackValue(sceneName+".camera.lookAtZ", camLookAt.z);
//    rocket.setTrackValue(sceneName+".camera.upX", camUp.x);
//    rocket.setTrackValue(sceneName+".camera.upY", camUp.y);
//    rocket.setTrackValue(sceneName+".camera.upZ", camUp.z);

    var tracks = [];
    var values = [];

    tracks.push(sceneName+camera.name+".x"); values.push(camPos.x);
    tracks.push(sceneName+camera.name+".y"); values.push(camPos.y);
    tracks.push(sceneName+camera.name+".z"); values.push(camPos.z);

    tracks.push(sceneName+camera.name+".lookAtX"); values.push(camLookAt.x);
    tracks.push(sceneName+camera.name+".lookAtY"); values.push(camLookAt.y);
    tracks.push(sceneName+camera.name+".lookAtZ"); values.push(camLookAt.z);

    tracks.push(sceneName+camera.name+".upX"); values.push(camUp.x);
    tracks.push(sceneName+camera.name+".upY"); values.push(camUp.y);
    tracks.push(sceneName+camera.name+".upZ"); values.push(camUp.z);

    rocket.setTrackValues(tracks, values);


  }

  property var followAPX: []
  property var followAPY: []
  property var followAPZ: []

  property int followIndex0: sync(camera.name+".followIndex0")
  property int followIndex1: sync(camera.name+".followIndex1")
  property real followFade: sync(camera.name+".followFade")


  property real followPX: 0.0
  property real followPY: 0.0
  property real followPZ: 0.0

  Connections {
    target: root
    onKeyC: {
      if (bCtrlDown) {
        return;
      }
      rocket.markUpdateFrequent();
      hasCamOverride = false;
      smoothInited = false;
    }
    onKeyR: {
      if (bCtrlDown) {
        return;
      }
      rocket.markUpdateFrequent();
      if (hasCamOverride) {
        saveCamToRocket();
      }
      hasCamOverride = false;
    }

    onFollowEntity: {
      if (fi < 0) fi = 0;
      if (fi > 999) fi = 999;

      followAPX[fi] = px;
      followAPY[fi] = py;
      followAPZ[fi] = pz*0.0;

      console.log("followAPX:"+followAPX[1])

      followPX = 0.0;
      followPY = 0.0;
      followPZ = 0.0;

      //            followPX += px;
      //            followPY += py;
      //            followPZ += pz;

      if (followIndex0 > 0) {
        if (followAPX[followIndex0] !== undefined) {
          followPX += (1.0-followFade)*followAPX[followIndex0];
        }
        if (followAPY[followIndex0] !== undefined) {
          followPY += (1.0-followFade)*followAPY[followIndex0];
        }
        if (followAPZ[followIndex0] !== undefined) {
          followPZ += (1.0-followFade)*followAPZ[followIndex0];
        }
      }
      if (followIndex1 > 0) {
        if (followAPY[followIndex1] !== undefined) {
          followPY += (followFade)*followAPY[followIndex1];
        }
        if (followAPY[followIndex1] !== undefined) {
          followPY += (followFade)*followAPY[followIndex1];
        }
        if (followAPZ[followIndex1] !== undefined) {
          followPZ += (followFade)*followAPZ[followIndex1];
        }
      }
      if (followIndex0>0 || followIndex1>0) {
        bFlyCamFromIndexActive = true;
      } else {
        bFlyCamFromIndexActive = false;
      }

      console.log("follow:"+followPX+","+followPY+","+followPZ)
      console.log("followIndex0:"+followIndex0)
    }


    onKeyPressed: {
      // log(keyCode);
      if (keyCode === Qt.Key_Left) {
        bLeftPressed = true;
      } else if (keyCode === Qt.Key_Right) {
        bRightPressed = true;
      } else if (keyCode === Qt.Key_Up) {
        bUpPressed = true;
      } else if (keyCode === Qt.Key_Down) {
        bDownPressed = true;
      }

      if (keyCode === 16777251) {
        bAltDown = true;
      } else if (keyCode === 16777248) {
        bShiftDown = true;
      } else if (keyCode === 85) { // U
        keepCamUp = !keepCamUp;
        updateUpModeDisplay();
      } else if (keyCode === 73) { // I
        bIDown = true;
      } else if (keyCode === 70) { // F
        bFDown = true;
      } else if (keyCode === Qt.Key_F2) {
        // console.log("toggleCustomTextGroupShow");
        root.toggleCustomTextGroupShow("fly camera");
      }


      if (keyCode === Qt.Key_Control) {
        bCtrlDown = true;
      }
      if (keyCode === 45) {
        bMinusDown = true;
      }
      if (keyCode === 43) {
        bPlusDown = true;
      }

    }
    onKeyReleased: {
      if (keyCode === Qt.Key_Left) {
        bLeftPressed = false;
      } else if (keyCode === Qt.Key_Right) {
        bRightPressed = false;
      } else if (keyCode === Qt.Key_Up) {
        bUpPressed = false;
      } else if (keyCode === Qt.Key_Down) {
        bDownPressed = false;
      }

      if (keyCode === 16777251) {
        bAltDown = false;
      } else if (keyCode === 16777248) {
        bShiftDown = false;
      } else if (keyCode === 73) { // I
        bIDown = false;
      } else if (keyCode === 70) { // F
        bFDown = false;
      }

      if (keyCode === Qt.Key_Control) {
        bCtrlDown = false;
      }

      if (keyCode === 45) {
        bMinusDown = false;
      }
      if (keyCode === 43) {
        bPlusDown = false;
      }


    }
    property real prevX: 0.0
    property real prevY: 0.0
    property bool bMousePressHandled: false

    onMouseMove: {
      if (mousePressed) {
        rocket.markUpdateFrequent();
        if (!bMousePressHandled) {
          bMousePressHandled = true;
          activateCamOverride();
          camPosOrig.x = camPos.x;
          camPosOrig.y = camPos.y;
          camPosOrig.z = camPos.z;
          camLookDirOrig = camLookDir;
          if (!keepCamUp) {
            camUpOrig = camUp;
          }
          camRotAxis = camLookDir.crossProduct(camUp);
          camRotAxis = camRotAxis.normalized();
          prevX = mousePressX;
          prevY = mousePressY;
        }


        var dx = mouseX-prevX;
        var dy = mouseY-prevY;

        prevX = mouseX;
        prevY = mouseY;


        camRotAxis = rotateAxis(camRotAxis, camUp, -dx*rotSpeed);
        camLookDir = rotateAxis(camLookDir, camUp, -dx*rotSpeed);

        if (!keepCamUp) {
          camUp = rotateAxis(camUp, camRotAxis, dy*rotSpeed);
        }
        camLookDir = rotateAxis(camLookDir, camRotAxis, dy*rotSpeed);

        var camDistFromOrigo = camPos.length();

        camLookAt = camPos.plus(camLookDir.times(camDistFromOrigo));
      }
    }

    onMousePress: {
      rocket.markUpdateFrequent();
      mousePressX = mouseX;
      mousePressY = mouseY;
      mousePressed = true;
      bMousePressHandled = false;
      console.log("mouse pressed at:"+mouseX, mouseY);
    }
    onMouseRelease: {
      mousePressed = false;
      console.log("mouse released");
    }
  }

  function getCamPosRocket() {
    return Qt.vector3d(sync(camera.name+".x")+camOfs.x, sync(camera.name+".y")+camOfs.y, sync(camera.name+".z")+camOfs.x);
  }
  function getCamPos() {
    if (hasCamOverride) {
      return camPos;
    }
    return Qt.vector3d(sync(camera.name+".x")+camOfs.x, sync(camera.name+".y")+camOfs.y, sync(camera.name+".z")+camOfs.x);
  }


  function getCamPosSmooth() {
  //  if (!camPosCacheDirty) {
      return camPosCache;
   // }
//    if (hasCamOverride) {
//      if (!smoothInited) {
//        camPosSmooth = camPos;
//        camLookAtSmooth = camLookAt;
//        camUpSmooth = camUp;
//        smoothInited = true;
//      }
//      camPosCache = camPosSmooth;
//      camPosCacheDirty = false;
//      return camPosCache;
//    }
//    camPosCache = getCamPos();
//    camPosCacheDirty = false;
//    return camPosCache;
  }
  function getCamLookAtSmooth() {
  //  if (!camLookAtCacheDirty) {
      return camLookAtCache;
  //  }
//    if (hasCamOverride) {
//      camLookAtCache = camLookAtSmooth;
//      camLookAtCacheDirty = false;
//      return camLookAtCache;
//    }
//    camLookAtCache = getCamLookAt();
//    camLookAtCacheDirty = false;
//    return camLookAtCache;
  }
  function getCamUpSmooth() {
 //   if (!camUpCacheDirty) {
      return camUpCache;
  //  }
//    if (hasCamOverride) {
//      camUpCache = camUpSmooth;
//      camUpCacheDirty = false;
//      return camUpCache;
//    }
//    camUpCache = getCamUp();
//    camUpCacheDirty = false;
//    return camUpCache;
  }



  function getCamLookAtRocket() {
    return Qt.vector3d(sync(camera.name+".lookAtX"), sync(camera.name+".lookAtY"), sync(camera.name+".lookAtZ"));
  }
  function getCamLookAt() {
    if (hasCamOverride) {
      return camLookAt;
    }
    return Qt.vector3d(sync(camera.name+".lookAtX"), sync(camera.name+".lookAtY"), sync(camera.name+".lookAtZ"));
  }

  function getCamUp() {
    if (hasCamOverride) {
      return camUp;
    }
    return Qt.vector3d(sync(camera.name+".upX"), sync(camera.name+".upY"), sync(camera.name+".upZ"));
  }

  property real camDist: sync(camera.name+".dist", 1.0)
  property real camViewAngle: sync(camera.name+".viewAngle", 45.0)

  Camera {
    name: "camera"
    property vector3d pos: getCamPosSmooth()
    property vector3d lookAt: getCamLookAtSmooth()
    property vector3d up: getCamUpSmooth()
    x: pos.x;
    y: pos.y;
    z: pos.z;
    lookAtX: lookAt.x; lookAtY: lookAt.y; lookAtZ: lookAt.z
    upX: up.x; upY: up.y; upZ: up.z
    viewAngle: camViewAngle
  }
}
