import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "boxGrower"
  effectName: "BoxGrower"
  property BoxGrowerImpl impl
  Component {
    id: ec
    BoxGrowerImpl {}
  }


  enabled: syncRoot(effect.name+".ON");
  onEffectRender: {
    if (sceneName !== "") {
      if (enabled && !impl) {
        impl = ec.createObject(effect, { name: effect.name, effectName: effect.effectName } );
      }
      if (!enabled && impl) {
        impl.destroy();
        impl = undefined;
      }
    }
  }
}
