import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "blurRt"
  effectName: "BlurRt"
  property BlurRtImpl impl
  property string textureRT
  property string targetTextureRT: textureRT

  Component {
    id: ec
    BlurRtImpl {}
  }

  enabled: syncRootOn(effect.name, effectName);
  onEffectRender: {
    if (sceneName !== "") {
      if (enabled && !impl) {
        impl = ec.createObject(effect,
                               { name: effect.name,
                                 effectName: effect.effectName,
                                 textureRT: effect.textureRT,
                                 targetTextureRT: effect.targetTextureRT
                               });
      }
      if (!enabled && impl) {
        impl.destroy();
        impl = undefined;
      }
    }
  }
}
