import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: blur
    name: "glow"
    effectName: "BlurGlow"
    enabled: syncRoot(blur.name+".ON")
    property string shader: "blur"

    property string targetTextureRT

    property real posX: 0.0
    property real posY: 0.0
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
        textureWrap: "clamp"
    }
    Texture {
        textureUnit: 1
        textureRT: "depth"
    }

    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }

    Shader {
        file: "fx/_SharedQML/glowThr"
    }

    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: 0.0
        }
        ShaderParam { paramName: "g_thr"; paramValue: syncFFT(blur.name+".threshold") }
        ShaderParam { paramName: "g_amp"; paramValue: syncFFT(blur.name+".amp") }
        ShaderParam { paramName: "g_pow"; paramValue: sync(blur.name+".pow") }
        type: "quad"
        depthTest: false
        depthWrite: false
        drawBuffers: 1
    }
    Blit {
        textureRT: "screenBuffer1"
        blitRT: 0
    }

    BlurRtImpl {
        name: blur.name
        effectName: blur.effectName
        textureRT: "screenBuffer1"
        targetTextureRT: blur.targetTextureRT
    }

//    property real strengthAddPerLoop: sync(blur.name+".strength.addPerLoop")
//    property real strength: sync(blur.name+".strength")
//    property real kernelScaleX: sync(blur.name+".kernelScale.x")
//    property real kernelScaleY: sync(blur.name+".kernelScale.y")

//    Repeater {
//        model: sync(blur.name+".blurLoops")
//        delegate: Group {
//            Blit { textureRT: "screenBuffer"; blitRT: 0 }
//            Blit { textureRT: "screenBuffer"+index; blitRT: 0 }
//            Shader {
//                file: shader
//                ShaderParam {
//                    paramName: "g_blurStrength"
//                    paramValue: strength*(1.0+index*strengthAddPerLoop)
//                }
//                ShaderParam { paramName: "g_kernelScaleX"; paramValue: kernelScaleX }
//                ShaderParam { paramName: "g_kernelScaleY"; paramValue: kernelScaleY }
//            }
//            DrawVB {
//                type: "quad"
//                depthTest: false
//                depthWrite: false
//                drawBuffers: 1
//            }
//        }
//    }
}
