import QtQuick 2.4
import AdaptDemoSystem 1.0
import "./"
import "./_SharedQML"

GridView {
  id: gView
  property var meshList
  property string title
  property int baseIndex: 0

  property bool initUpdateReported: false

  header: Text {
    id: headerText
    text: title
    color: "white"
  }

  cellWidth: 88
  cellHeight: 100

  anchors.left: parent.left
  anchors.leftMargin: 5

  width: parent.width
  height: contentHeight
  model: meshList.length
  interactive: false
  delegate: Item {
    id: texItem
    width: 80
    height: 80+14
    Rectangle {
      anchors.fill: parent
      color: "black"
      border.width: 1
      border.color: "white"
    }
    Rectangle {
      anchors.fill: indexText
      color: "#444444"
      border.width: 1
      border.color: "white"
    }
    Text {
      id: indexText
      anchors.top: parent.top
      anchors.left: parent.left
      anchors.right: parent.right
      height: 14
      text: index+baseIndex
      color: "white"
      horizontalAlignment: Text.AlignHCenter
    }
    Rectangle {
      id: rector
      color: "blue"
      anchors.fill: parent
      anchors.topMargin: 14
    }
    function updateMeshInfos() {
      var gc = rector.mapToItem(null, 0, 0);
      var meshName = "mesh/"+meshList[index];
      if (meshThumbs === undefined) {
        meshThumbs = {};
      }
      meshThumbs[index+baseIndex] = { x: gc.x, y: gc.y+meshViewFlick.contentY, file: meshName };

      if (index === (meshList.length-1) && !initUpdateReported) {
        initUpdateReported = true;
        meshViewFlick.updateMeshThumbs();
      }

     // log("Rt tex:"+meshName+" "+gc.x+","+gc.y)
    }

    onXChanged: {
      updateMeshInfos();
    }
    onYChanged: {
      updateMeshInfos();
    }

    Component.onCompleted: {
      updateMeshInfos();
    }

    Connections {
      target: meshViewFlick
      onContentYChanged: {
        updateMeshInfos();
      }
    }

    Text {
      id: nameText
      //   visible: false
      anchors.fill: parent
      anchors.margins: 4
      anchors.topMargin: 14
      text: meshList[index]
      horizontalAlignment: Text.AlignHCenter
      color: "white"
      wrapMode: Text.Wrap
    }

    MouseArea {
      anchors.fill: parent
      onClicked: {
        log("clicked mesh:"+meshList[index])
      }
    }

  }

}
