import QtQuick 2.3
Item {
    id: cornerButton
    signal buttonPressed()
    property string buttonText
    property color buttonColor: "grey"

    width: rekti.width
    height: rekti.height+5
    Rectangle {
        anchors.top: parent.top
        anchors.right: parent.right
        width: 60
        height: 40

        id: rekti
        color: buttonColor
        Text {
            //anchors.centerIn: parent
            anchors.fill: parent

            width: rekti.width
            height: rekti.height
            color: "white"
            text: cornerButton.buttonText
            wrapMode: Text.WordWrap

            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
        }
        MouseArea {
            anchors.fill: parent
            onPressedChanged: {
                if (pressed) {
                    //rocket.remoteExportAll();
                    console.log("pressed on :"+cornerButton.buttonText)
                    buttonPressed();
                }
            }
        }
    }

}
