/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.shape.Composition;
import org.openrndr.svg.SVGDocument;
import org.openrndr.svg.SVGLoader;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\u00a8\u0006\u0007"}, d2={"loadSVG", "Lorg/openrndr/shape/Composition;", "svgString", "", "parseColor", "Lorg/openrndr/color/ColorRGBa;", "scolor", "openrndr-svg"})
public final class SVGLoaderKt {
    @NotNull
    public static final Composition loadSVG(@NotNull String svgString) {
        Intrinsics.checkParameterIsNotNull(svgString, "svgString");
        SVGDocument doc = new SVGLoader().loadSVG(svgString);
        return doc.composition();
    }

    @Nullable
    public static final ColorRGBa parseColor(@NotNull String scolor) {
        ColorRGBa colorRGBa;
        Intrinsics.checkParameterIsNotNull(scolor, "scolor");
        CharSequence charSequence = scolor;
        if (charSequence.length() == 0 || Intrinsics.areEqual(scolor, "none")) {
            colorRGBa = null;
        } else if (StringsKt.startsWith$default(scolor, "#", false, 2, null)) {
            ColorRGBa color;
            Long v = Long.decode(scolor);
            int vi = (int)v.longValue();
            int r = vi >> 16 & 0xFF;
            int g = vi >> 8 & 0xFF;
            int b = vi & 0xFF;
            colorRGBa = color = new ColorRGBa((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, 1.0, null, 16, null);
        } else if (Intrinsics.areEqual(scolor, "white")) {
            colorRGBa = ColorRGBa.Companion.getWHITE();
        } else if (Intrinsics.areEqual(scolor, "silver")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0xC0C0C0);
        } else if (Intrinsics.areEqual(scolor, "gray")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x808080);
        } else if (Intrinsics.areEqual(scolor, "black")) {
            colorRGBa = ColorRGBa.Companion.getBLACK();
        } else if (Intrinsics.areEqual(scolor, "red")) {
            colorRGBa = ColorRGBa.Companion.getRED();
        } else if (Intrinsics.areEqual(scolor, "maroon")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x800000);
        } else if (Intrinsics.areEqual(scolor, "yellow")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0xFFFF00);
        } else if (Intrinsics.areEqual(scolor, "olive")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x808000);
        } else if (Intrinsics.areEqual(scolor, "lime")) {
            colorRGBa = ColorRGBa.Companion.fromHex(65280);
        } else if (Intrinsics.areEqual(scolor, "green")) {
            colorRGBa = ColorRGBa.Companion.fromHex(32768);
        } else if (Intrinsics.areEqual(scolor, "aqua")) {
            colorRGBa = ColorRGBa.Companion.fromHex(65535);
        } else if (Intrinsics.areEqual(scolor, "teal")) {
            colorRGBa = ColorRGBa.Companion.fromHex(32896);
        } else if (Intrinsics.areEqual(scolor, "blue")) {
            colorRGBa = ColorRGBa.Companion.fromHex(255);
        } else if (Intrinsics.areEqual(scolor, "navy")) {
            colorRGBa = ColorRGBa.Companion.fromHex(128);
        } else if (Intrinsics.areEqual(scolor, "fuchsia")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0xFF00FF);
        } else if (Intrinsics.areEqual(scolor, "purple")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x800080);
        } else if (Intrinsics.areEqual(scolor, "orange")) {
            colorRGBa = ColorRGBa.Companion.fromHex(16753920);
        } else {
            throw (Throwable)new RuntimeException("could not parse color: " + scolor);
        }
        return colorRGBa;
    }
}

