/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import io.lacuna.artifex.Bezier2;
import io.lacuna.artifex.Curve2;
import io.lacuna.artifex.Line2;
import io.lacuna.artifex.Path2;
import io.lacuna.artifex.Region2;
import io.lacuna.artifex.Ring2;
import io.lacuna.artifex.Vec2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a5\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u0001H\u0007\u00a2\u0006\u0002\b\u0005\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0002\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0006\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0006\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006\u001a5\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u0001H\u0007\u00a2\u0006\u0002\b\t\u001a(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\u0002\u001a\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u001a5\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u0001H\u0007\u00a2\u0006\u0002\b\f\u001a(\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0006H\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0002H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0006H\u0002\u001a\f\u0010\u0016\u001a\u00020\u000f*\u00020\u000eH\u0002\u001a\f\u0010\u0017\u001a\u00020\u0006*\u00020\u0015H\u0002\u001a\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0013H\u0002\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002\u001a\f\u0010\u001c\u001a\u00020\u001b*\u00020\u001aH\u0002\u00a8\u0006\u001d"}, d2={"difference", "", "Lorg/openrndr/shape/Shape;", "from", "subtract", "differenceIterative", "Lorg/openrndr/shape/ShapeContour;", "intersection", "with", "intersectionIterative", "union", "add", "unionIterative", "toCurve2", "Lio/lacuna/artifex/Curve2;", "Lorg/openrndr/shape/Segment;", "toPath2", "Lio/lacuna/artifex/Path2;", "toRegion2", "Lio/lacuna/artifex/Region2;", "toRing2", "Lio/lacuna/artifex/Ring2;", "toSegment", "toShapeContour", "toShapes", "toVec2", "Lio/lacuna/artifex/Vec2;", "Lorg/openrndr/math/Vector2;", "toVector2", "openrndr-shape"})
public final class ShapeOperationsKt {
    private static final Vec2 toVec2(@NotNull Vector2 $receiver) {
        return new Vec2($receiver.getX(), $receiver.getY());
    }

    private static final Vector2 toVector2(@NotNull Vec2 $receiver) {
        return new Vector2($receiver.x, $receiver.y);
    }

    private static final Curve2 toCurve2(@NotNull Segment $receiver) {
        Curve2 curve2;
        switch ($receiver.getControl().length) {
            case 0: {
                Line2 line2 = Line2.line(ShapeOperationsKt.toVec2($receiver.getStart()), ShapeOperationsKt.toVec2($receiver.getEnd()));
                Intrinsics.checkExpressionValueIsNotNull(line2, "Line2.line(start.toVec2(), end.toVec2())");
                curve2 = line2;
                break;
            }
            case 1: {
                Curve2 curve22 = Bezier2.curve(ShapeOperationsKt.toVec2($receiver.getStart()), ShapeOperationsKt.toVec2($receiver.getControl()[0]), ShapeOperationsKt.toVec2($receiver.getEnd()));
                curve2 = curve22;
                Intrinsics.checkExpressionValueIsNotNull(curve22, "Bezier2.curve(start.toVe\u2026].toVec2(), end.toVec2())");
                break;
            }
            case 2: {
                Curve2 curve23 = Bezier2.curve(ShapeOperationsKt.toVec2($receiver.getStart()), ShapeOperationsKt.toVec2($receiver.getControl()[0]), ShapeOperationsKt.toVec2($receiver.getControl()[1]), ShapeOperationsKt.toVec2($receiver.getEnd()));
                curve2 = curve23;
                Intrinsics.checkExpressionValueIsNotNull(curve23, "Bezier2.curve(start.toVe\u2026].toVec2(), end.toVec2())");
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("unsupported control count " + $receiver.getControl().length);
            }
        }
        return curve2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Path2 toPath2(@NotNull ShapeContour $receiver) {
        void var3_3;
        Collection<Curve2> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getSegments();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Curve2 curve2 = ShapeOperationsKt.toCurve2((Segment)it);
            collection.add(curve2);
        }
        collection = (List)var3_3;
        Iterable iterable2 = collection;
        return new Path2(iterable2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Ring2 toRing2(@NotNull ShapeContour $receiver) {
        void var3_3;
        Collection<Curve2> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getSegments();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Curve2 curve2 = ShapeOperationsKt.toCurve2((Segment)it);
            collection.add(curve2);
        }
        collection = (List)var3_3;
        Iterable iterable2 = collection;
        return new Ring2(iterable2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Region2 toRegion2(@NotNull Shape $receiver) {
        void var3_3;
        Collection<Ring2> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getContours();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ShapeContour shapeContour = (ShapeContour)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Ring2 ring2 = ShapeOperationsKt.toRing2((ShapeContour)it);
            collection.add(ring2);
        }
        collection = (List)var3_3;
        Iterable iterable2 = collection;
        return new Region2(iterable2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Shape> toShapes(@NotNull Region2 $receiver) {
        Ring2[] ring2Array;
        List shapes = new ArrayList();
        Intrinsics.checkExpressionValueIsNotNull($receiver.rings, "rings");
        Ring2[] ring2Array2 = ring2Array = $receiver.rings;
        if (!(ring2Array2.length == 0)) {
            int n;
            List contours = new ArrayList();
            Intrinsics.checkExpressionValueIsNotNull($receiver.rings, "rings");
            Object $receiver$iv = $receiver.rings;
            for (Object element$iv : $receiver$iv) {
                Ring2 it = element$iv;
                boolean bl = false;
                Ring2 ring2 = it;
                Intrinsics.checkExpressionValueIsNotNull(ring2, "it");
                contours.add(ShapeOperationsKt.toShapeContour(ring2));
                if (it.isClockwise) continue;
                Collection collection = contours;
                if (!collection.isEmpty()) {
                    shapes.add(new Shape(CollectionsKt.reversed(contours)));
                }
                contours.clear();
            }
            $receiver$iv = contours;
            if (!$receiver$iv.isEmpty()) {
                shapes.add(new Shape(CollectionsKt.reversed(contours)));
            }
            $receiver$iv = shapes;
            int n2 = $receiver.rings.length;
            int sum$iv = 0;
            Iterator iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object element$iv;
                Object element$iv2 = iterator2.next();
                element$iv = (Shape)element$iv2;
                n = sum$iv;
                boolean bl = false;
                int n3 = it.getContours().size();
                sum$iv = n + n3;
            }
            n = sum$iv;
            if (n2 != n) {
                throw (Throwable)new RuntimeException("conversion broken");
            }
        }
        return shapes;
    }

    private static final Segment toSegment(@NotNull Curve2 $receiver) {
        Segment segment;
        Curve2 curve2 = $receiver;
        if (curve2 instanceof Line2) {
            Vec2 vec2 = $receiver.start();
            Intrinsics.checkExpressionValueIsNotNull(vec2, "this.start()");
            Vector2 vector2 = ShapeOperationsKt.toVector2(vec2);
            Vec2 vec22 = $receiver.end();
            Intrinsics.checkExpressionValueIsNotNull(vec22, "this.end()");
            segment = new Segment(vector2, ShapeOperationsKt.toVector2(vec22));
        } else if (curve2 instanceof Bezier2.QuadraticBezier2) {
            Vec2 vec2 = ((Bezier2.QuadraticBezier2)$receiver).p0;
            Intrinsics.checkExpressionValueIsNotNull(vec2, "this.p0");
            Vector2 vector2 = ShapeOperationsKt.toVector2(vec2);
            Vec2 vec23 = ((Bezier2.QuadraticBezier2)$receiver).p1;
            Intrinsics.checkExpressionValueIsNotNull(vec23, "this.p1");
            Vector2 vector22 = ShapeOperationsKt.toVector2(vec23);
            Vec2 vec24 = ((Bezier2.QuadraticBezier2)$receiver).p2;
            Intrinsics.checkExpressionValueIsNotNull(vec24, "this.p2");
            segment = new Segment(vector2, vector22, ShapeOperationsKt.toVector2(vec24));
        } else if (curve2 instanceof Bezier2.CubicBezier2) {
            Vec2 vec2 = ((Bezier2.CubicBezier2)$receiver).p0;
            Intrinsics.checkExpressionValueIsNotNull(vec2, "this.p0");
            Vector2 vector2 = ShapeOperationsKt.toVector2(vec2);
            Vec2 vec25 = ((Bezier2.CubicBezier2)$receiver).p1;
            Intrinsics.checkExpressionValueIsNotNull(vec25, "this.p1");
            Vector2 vector23 = ShapeOperationsKt.toVector2(vec25);
            Vec2 vec26 = ((Bezier2.CubicBezier2)$receiver).p2;
            Intrinsics.checkExpressionValueIsNotNull(vec26, "this.p2");
            Vector2 vector24 = ShapeOperationsKt.toVector2(vec26);
            Vec2 vec27 = ((Bezier2.CubicBezier2)$receiver).p3;
            Intrinsics.checkExpressionValueIsNotNull(vec27, "this.p3");
            segment = new Segment(vector2, vector23, vector24, ShapeOperationsKt.toVector2(vec27));
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        return segment;
    }

    /*
     * WARNING - void declaration
     */
    private static final ShapeContour toShapeContour(@NotNull Ring2 $receiver) {
        void var3_3;
        Collection<Segment> collection;
        void $receiver$iv$iv;
        Curve2[] $receiver$iv;
        Intrinsics.checkExpressionValueIsNotNull($receiver.curves, "this.curves");
        Curve2[] curve2Array = $receiver$iv = $receiver.curves;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        void var4_4 = $receiver$iv$iv;
        int n = ((void)var4_4).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var8_8 = item$iv$iv = var4_4[i];
            collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull(v0, "it");
            Segment segment = ShapeOperationsKt.toSegment((Curve2)v0);
            collection.add(segment);
        }
        collection = (List)var3_3;
        boolean bl = true;
        List list = collection;
        return new ShapeContour(list, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Region2 toRegion2(@NotNull List<Shape> $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Shape shape = (Shape)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = $receiver$iv2 = (Iterable)shape.getContours();
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                ShapeContour shapeContour = (ShapeContour)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Ring2 ring2 = ShapeOperationsKt.toRing2((ShapeContour)it);
                collection.add(ring2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List list = (List)var3_3;
        Iterable iterable3 = list;
        return new Region2(iterable3);
    }

    @NotNull
    public static final List<Shape> difference(@NotNull ShapeContour from, @NotNull ShapeContour subtract2) {
        Region2 result2;
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(subtract2, "subtract");
        Region2 region2 = result2 = ShapeOperationsKt.toRing2(from).region().difference(ShapeOperationsKt.toRing2(subtract2).region());
        Intrinsics.checkExpressionValueIsNotNull(region2, "result");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> difference(@NotNull Shape from, @NotNull ShapeContour subtract2) {
        Region2 result2;
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(subtract2, "subtract");
        Region2 region2 = result2 = ShapeOperationsKt.toRegion2(from).difference(ShapeOperationsKt.toRing2(subtract2).region());
        Intrinsics.checkExpressionValueIsNotNull(region2, "result");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> difference(@NotNull Shape from, @NotNull Shape subtract2) {
        Region2 result2;
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(subtract2, "subtract");
        Region2 region2 = result2 = ShapeOperationsKt.toRegion2(from).difference(ShapeOperationsKt.toRegion2(subtract2));
        Intrinsics.checkExpressionValueIsNotNull(region2, "result");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> difference(@NotNull List<Shape> from, @NotNull ShapeContour subtract2) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(subtract2, "subtract");
        Region2 region2 = ShapeOperationsKt.toRegion2(from).difference(ShapeOperationsKt.toRing2(subtract2).region());
        Intrinsics.checkExpressionValueIsNotNull(region2, "from.toRegion2().differe\u2026tract.toRing2().region())");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> difference(@NotNull List<Shape> from, @NotNull Shape subtract2) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(subtract2, "subtract");
        Region2 region2 = ShapeOperationsKt.toRegion2(from).difference(ShapeOperationsKt.toRegion2(subtract2));
        Intrinsics.checkExpressionValueIsNotNull(region2, "from.toRegion2().difference(subtract.toRegion2())");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> difference(@NotNull List<Shape> from, @NotNull List<Shape> subtract2) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(subtract2, "subtract");
        Region2 region2 = ShapeOperationsKt.toRegion2(from).difference(ShapeOperationsKt.toRegion2(subtract2));
        Intrinsics.checkExpressionValueIsNotNull(region2, "from.toRegion2().difference(subtract.toRegion2())");
        return ShapeOperationsKt.toShapes(region2);
    }

    @JvmName(name="differenceIterative")
    @NotNull
    public static final List<Shape> differenceIterative(@NotNull List<Shape> from, @NotNull List<? extends List<Shape>> subtract2) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(subtract2, "subtract");
        List<Shape> left = from;
        for (List<Shape> list : subtract2) {
            left = ShapeOperationsKt.difference(left, list);
        }
        return left;
    }

    @NotNull
    public static final List<Shape> union(@NotNull ShapeContour from, @NotNull ShapeContour add2) {
        Region2 result2;
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(add2, "add");
        Region2 region2 = result2 = ShapeOperationsKt.toRing2(from).region().union(ShapeOperationsKt.toRing2(add2).region());
        Intrinsics.checkExpressionValueIsNotNull(region2, "result");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> union(@NotNull Shape from, @NotNull ShapeContour add2) {
        Region2 result2;
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(add2, "add");
        Region2 region2 = result2 = ShapeOperationsKt.toRegion2(from).union(ShapeOperationsKt.toRing2(add2).region());
        Intrinsics.checkExpressionValueIsNotNull(region2, "result");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> union(@NotNull Shape from, @NotNull Shape add2) {
        Region2 result2;
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(add2, "add");
        Region2 region2 = result2 = ShapeOperationsKt.toRegion2(from).union(ShapeOperationsKt.toRegion2(add2));
        Intrinsics.checkExpressionValueIsNotNull(region2, "result");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> union(@NotNull List<Shape> from, @NotNull ShapeContour add2) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(add2, "add");
        Region2 region2 = ShapeOperationsKt.toRegion2(from).union(ShapeOperationsKt.toRing2(add2).region());
        Intrinsics.checkExpressionValueIsNotNull(region2, "from.toRegion2().union(add.toRing2().region())");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> union(@NotNull List<Shape> from, @NotNull Shape add2) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(add2, "add");
        Region2 region2 = ShapeOperationsKt.toRegion2(from).union(ShapeOperationsKt.toRegion2(add2));
        Intrinsics.checkExpressionValueIsNotNull(region2, "from.toRegion2().union(add.toRegion2())");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> union(@NotNull List<Shape> from, @NotNull List<Shape> add2) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(add2, "add");
        Region2 region2 = ShapeOperationsKt.toRegion2(from).union(ShapeOperationsKt.toRegion2(add2));
        Intrinsics.checkExpressionValueIsNotNull(region2, "from.toRegion2().union(add.toRegion2())");
        return ShapeOperationsKt.toShapes(region2);
    }

    @JvmName(name="unionIterative")
    @NotNull
    public static final List<Shape> unionIterative(@NotNull List<Shape> from, @NotNull List<? extends List<Shape>> add2) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(add2, "add");
        List<Shape> left = from;
        for (List<Shape> list : add2) {
            left = ShapeOperationsKt.union(left, list);
        }
        return left;
    }

    @NotNull
    public static final List<Shape> intersection(@NotNull ShapeContour from, @NotNull ShapeContour with) {
        Region2 result2;
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(with, "with");
        Region2 region2 = result2 = ShapeOperationsKt.toRing2(from).region().intersection(ShapeOperationsKt.toRing2(with).region());
        Intrinsics.checkExpressionValueIsNotNull(region2, "result");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> intersection(@NotNull Shape from, @NotNull ShapeContour with) {
        Region2 result2;
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(with, "with");
        Region2 region2 = result2 = ShapeOperationsKt.toRegion2(from).intersection(ShapeOperationsKt.toRing2(with).region());
        Intrinsics.checkExpressionValueIsNotNull(region2, "result");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> intersection(@NotNull ShapeContour from, @NotNull Shape with) {
        Region2 result2;
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(with, "with");
        Region2 region2 = result2 = ShapeOperationsKt.toRing2(from).region().intersection(ShapeOperationsKt.toRegion2(with));
        Intrinsics.checkExpressionValueIsNotNull(region2, "result");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> intersection(@NotNull Shape from, @NotNull Shape with) {
        Region2 result2;
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(with, "with");
        Region2 region2 = result2 = ShapeOperationsKt.toRegion2(from).intersection(ShapeOperationsKt.toRegion2(with));
        Intrinsics.checkExpressionValueIsNotNull(region2, "result");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> intersection(@NotNull List<Shape> from, @NotNull ShapeContour with) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(with, "with");
        Region2 region2 = ShapeOperationsKt.toRegion2(from).intersection(ShapeOperationsKt.toRing2(with).region());
        Intrinsics.checkExpressionValueIsNotNull(region2, "from.toRegion2().interse\u2026(with.toRing2().region())");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> intersection(@NotNull List<Shape> from, @NotNull Shape with) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(with, "with");
        Region2 region2 = ShapeOperationsKt.toRegion2(from).intersection(ShapeOperationsKt.toRegion2(with));
        Intrinsics.checkExpressionValueIsNotNull(region2, "from.toRegion2().intersection(with.toRegion2())");
        return ShapeOperationsKt.toShapes(region2);
    }

    @NotNull
    public static final List<Shape> intersection(@NotNull List<Shape> from, @NotNull List<Shape> with) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(with, "with");
        Region2 region2 = ShapeOperationsKt.toRegion2(from).intersection(ShapeOperationsKt.toRegion2(with));
        Intrinsics.checkExpressionValueIsNotNull(region2, "from.toRegion2().intersection(with.toRegion2())");
        return ShapeOperationsKt.toShapes(region2);
    }

    @JvmName(name="intersectionIterative")
    @NotNull
    public static final List<Shape> intersectionIterative(@NotNull List<Shape> from, @NotNull List<? extends List<Shape>> with) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(with, "with");
        List<Shape> left = from;
        for (List<Shape> list : with) {
            left = ShapeOperationsKt.intersection(left, list);
        }
        return left;
    }
}

