/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0014\u0010\u0005\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u001a\u0014\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a8\u0006\u000b"}, d2={"intersects", "", "a", "Lorg/openrndr/shape/Rectangle;", "b", "rectangleBounds", "rectangles", "", "vector2Bounds", "points", "Lorg/openrndr/math/Vector2;", "openrndr-shape"})
public final class RectangleKt {
    @NotNull
    public static final Rectangle vector2Bounds(@NotNull List<Vector2> points) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        double minX = DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        double minY = DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        double maxX = DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY();
        double maxY = DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY();
        Iterable $receiver$iv = points;
        for (Object element$iv : $receiver$iv) {
            Vector2 it = (Vector2)element$iv;
            boolean bl = false;
            minX = Math.min(minX, it.getX());
            maxX = Math.max(maxX, it.getX());
            minY = Math.min(minY, it.getY());
            maxY = Math.max(maxY, it.getY());
        }
        return new Rectangle(new Vector2(minX, minY), maxX - minX, maxY - minY);
    }

    @NotNull
    public static final Rectangle rectangleBounds(@NotNull List<Rectangle> rectangles) {
        Intrinsics.checkParameterIsNotNull(rectangles, "rectangles");
        double minX = DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        double minY = DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        double maxX = DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY();
        double maxY = DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY();
        Iterable $receiver$iv = rectangles;
        for (Object element$iv : $receiver$iv) {
            Rectangle it = (Rectangle)element$iv;
            boolean bl = false;
            minX = Math.min(minX, it.getX());
            maxX = Math.max(maxX, it.getX() + it.getWidth());
            minY = Math.min(minY, it.getY());
            maxY = Math.max(maxY, it.getY() + it.getHeight());
        }
        return new Rectangle(new Vector2(minX, minY), maxX - minX, maxY - minY);
    }

    public static final boolean intersects(@NotNull Rectangle a2, @NotNull Rectangle b) {
        Intrinsics.checkParameterIsNotNull(a2, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        boolean above = a2.getY() + a2.getHeight() < b.getHeight();
        boolean below = a2.getY() > b.getY() + b.getHeight();
        boolean rightOf = a2.getX() > b.getX() + b.getWidth();
        boolean leftOf = a2.getX() + a2.getWidth() < b.getX();
        return !above && !below && !leftOf && !rightOf;
    }
}

