/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0015\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR\u0011\u0010\u0015\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0017\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/math/CatmullRom3;", "", "p0", "Lorg/openrndr/math/Vector3;", "p1", "p2", "p3", "alpha", "", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;D)V", "getAlpha", "()D", "getP0", "()Lorg/openrndr/math/Vector3;", "getP1", "getP2", "getP3", "t0", "getT0", "t1", "getT1", "t2", "getT2", "t3", "getT3", "calculateT", "t", "position", "rt", "openrndr-math"})
public final class CatmullRom3 {
    private final double t0 = 0.0;
    private final double t1;
    private final double t2;
    private final double t3;
    @NotNull
    private final Vector3 p0;
    @NotNull
    private final Vector3 p1;
    @NotNull
    private final Vector3 p2;
    @NotNull
    private final Vector3 p3;
    private final double alpha;

    public final double getT0() {
        return this.t0;
    }

    public final double getT1() {
        return this.t1;
    }

    public final double getT2() {
        return this.t2;
    }

    public final double getT3() {
        return this.t3;
    }

    @NotNull
    public final Vector3 position(double rt) {
        double t = this.t1 + rt * (this.t2 - this.t1);
        Vector3 a1 = this.p0.times((this.t1 - t) / (this.t1 - this.t0)).plus(this.p1.times((t - this.t0) / (this.t1 - this.t0)));
        Vector3 a2 = this.p1.times((this.t2 - t) / (this.t2 - this.t1)).plus(this.p2.times((t - this.t1) / (this.t2 - this.t1)));
        Vector3 a3 = this.p2.times((this.t3 - t) / (this.t3 - this.t2)).plus(this.p3.times((t - this.t2) / (this.t3 - this.t2)));
        Vector3 b1 = a1.times((this.t2 - t) / (this.t2 - this.t0)).plus(a2.times((t - this.t0) / (this.t2 - this.t0)));
        Vector3 b2 = a2.times((this.t3 - t) / (this.t3 - this.t1)).plus(a3.times((t - this.t1) / (this.t3 - this.t1)));
        Vector3 c = b1.times((this.t2 - t) / (this.t2 - this.t1)).plus(b2.times((t - this.t1) / (this.t2 - this.t1)));
        return c;
    }

    private final double calculateT(double t, Vector3 p0, Vector3 p1) {
        double a2 = Math.pow(p1.getX() - p0.getX(), 2.0) + Math.pow(p1.getY() - p0.getY(), 2.0) + Math.pow(p1.getZ() - p0.getZ(), 2.0);
        double b = Math.pow(a2, 0.5);
        double c = Math.pow(b, this.alpha);
        return c + t;
    }

    @NotNull
    public final Vector3 getP0() {
        return this.p0;
    }

    @NotNull
    public final Vector3 getP1() {
        return this.p1;
    }

    @NotNull
    public final Vector3 getP2() {
        return this.p2;
    }

    @NotNull
    public final Vector3 getP3() {
        return this.p3;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    public CatmullRom3(@NotNull Vector3 p0, @NotNull Vector3 p1, @NotNull Vector3 p2, @NotNull Vector3 p3, double alpha) {
        Intrinsics.checkParameterIsNotNull(p0, "p0");
        Intrinsics.checkParameterIsNotNull(p1, "p1");
        Intrinsics.checkParameterIsNotNull(p2, "p2");
        Intrinsics.checkParameterIsNotNull(p3, "p3");
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.alpha = alpha;
        this.t1 = this.calculateT(this.t0, this.p0, this.p1);
        this.t2 = this.calculateT(this.t1, this.p1, this.p2);
        this.t3 = this.calculateT(this.t2, this.p2, this.p3);
    }

    public /* synthetic */ CatmullRom3(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            d = 0.5;
        }
        this(vector3, vector32, vector33, vector34, d);
    }
}

