/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL33C;
import org.openrndr.draw.IndexBuffer;
import org.openrndr.draw.IndexType;
import org.openrndr.internal.gl3.ErrorGL3Kt;
import org.openrndr.internal.gl3.IndexBufferGL3;
import org.openrndr.internal.gl3.IndexBufferGL3Kt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J!\u0010\u0011\u001a\u00020\u00102\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00100\u0013\u00a2\u0006\u0002\b\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0006\u0010\u001a\u001a\u00020\u0010J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/internal/gl3/IndexBufferGL3;", "Lorg/openrndr/draw/IndexBuffer;", "buffer", "", "indexCount", "type", "Lorg/openrndr/draw/IndexType;", "(IILorg/openrndr/draw/IndexType;)V", "getBuffer", "()I", "getIndexCount", "isDestroyed", "", "getType", "()Lorg/openrndr/draw/IndexType;", "bind", "", "bound", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "destroy", "read", "data", "Ljava/nio/ByteBuffer;", "offset", "unbind", "write", "Companion", "openrndr-gl3"})
public final class IndexBufferGL3
implements IndexBuffer {
    private boolean isDestroyed;
    private final int buffer;
    private final int indexCount;
    @NotNull
    private final IndexType type;
    public static final Companion Companion = new Companion(null);

    public final void bind() {
        if (this.isDestroyed) {
            throw (Throwable)new IllegalStateException("buffer is destroyed");
        }
        IndexBufferGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(this){
            final /* synthetic */ IndexBufferGL3 this$0;

            @NotNull
            public final String invoke() {
                return "binding vertex buffer " + this.this$0.getBuffer();
            }
            {
                this.this$0 = indexBufferGL3;
                super(0);
            }
        });
        GL33C.glBindBuffer(34963, this.buffer);
        ErrorGL3Kt.debugGLErrors$default(null, 1, null);
    }

    public final void unbind() {
        IndexBufferGL3Kt.access$getLogger$p().trace(unbind.1.INSTANCE);
        GL33C.glBindBuffer(34963, 0);
        ErrorGL3Kt.debugGLErrors$default(null, 1, null);
    }

    @Override
    public void write(@NotNull ByteBuffer data2, int offset2) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        this.bound((Function1<? super IndexBufferGL3, Unit>)new Function1<IndexBufferGL3, Unit>(offset2, data2){
            final /* synthetic */ int $offset;
            final /* synthetic */ ByteBuffer $data;

            public final void invoke(@NotNull IndexBufferGL3 $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                GL33C.glBufferSubData(34963, (long)this.$offset, this.$data);
            }
            {
                this.$offset = n;
                this.$data = byteBuffer;
                super(1);
            }
        });
        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
    }

    @Override
    public void read(@NotNull ByteBuffer data2, int offset2) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        if (this.isDestroyed) {
            throw (Throwable)new IllegalStateException("buffer is destroyed");
        }
        if (data2.isDirect()) {
            this.bound((Function1<? super IndexBufferGL3, Unit>)new Function1<IndexBufferGL3, Unit>(offset2, data2){
                final /* synthetic */ int $offset;
                final /* synthetic */ ByteBuffer $data;

                public final void invoke(@NotNull IndexBufferGL3 $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                    GL33C.glGetBufferSubData(34963, (long)this.$offset, this.$data);
                }
                {
                    this.$offset = n;
                    this.$data = byteBuffer;
                    super(1);
                }
            });
            ErrorGL3Kt.checkGLErrors$default(null, 1, null);
        } else {
            ByteBuffer temp;
            ByteBuffer byteBuffer = temp = BufferUtils.createByteBuffer(data2.capacity());
            Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "temp");
            this.read(byteBuffer, offset2);
            data2.put(temp);
        }
    }

    @Override
    public void destroy() {
        GL33C.glDeleteBuffers(this.buffer);
        this.isDestroyed = true;
    }

    private final void bound(Function1<? super IndexBufferGL3, Unit> f) {
        this.bind();
        f.invoke(this);
        this.unbind();
    }

    public final int getBuffer() {
        return this.buffer;
    }

    @Override
    public int getIndexCount() {
        return this.indexCount;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    public IndexBufferGL3(int buffer, int indexCount, @NotNull IndexType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, "type");
        this.buffer = buffer;
        this.indexCount = indexCount;
        this.type = type2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/internal/gl3/IndexBufferGL3$Companion;", "", "()V", "create", "Lorg/openrndr/internal/gl3/IndexBufferGL3;", "elementCount", "", "type", "Lorg/openrndr/draw/IndexType;", "openrndr-gl3"})
    public static final class Companion {
        @NotNull
        public final IndexBufferGL3 create(int elementCount, @NotNull IndexType type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, "type");
            int cb = GL33C.glGetInteger(34965);
            int buffer = GL33C.glGenBuffers();
            GL33C.glBindBuffer(34963, buffer);
            ErrorGL3Kt.checkGLErrors$default(null, 1, null);
            int sizeInBytes = type2.getSizeInBytes() * elementCount;
            GL33C.nglBufferData(34963, sizeInBytes, 0L, 35048);
            ErrorGL3Kt.checkGLErrors$default(null, 1, null);
            GL33C.glBindBuffer(34963, cb);
            return new IndexBufferGL3(buffer, elementCount, type2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

