/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extensions;

import java.io.File;
import java.time.LocalDateTime;
import java.time.Month;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Extension;
import org.openrndr.KeyEvent;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.extensions.CreateScreenshot;
import org.openrndr.extensions.Screenshots;
import org.openrndr.math.Matrix44;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010/\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/openrndr/extensions/Screenshots;", "Lorg/openrndr/Extension;", "()V", "createScreenshot", "Lorg/openrndr/extensions/CreateScreenshot;", "getCreateScreenshot$openrndr_extensions", "()Lorg/openrndr/extensions/CreateScreenshot;", "setCreateScreenshot$openrndr_extensions", "(Lorg/openrndr/extensions/CreateScreenshot;)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "key", "", "getKey", "()I", "setKey", "(I)V", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "getMultisample", "()Lorg/openrndr/draw/BufferMultisample;", "setMultisample", "(Lorg/openrndr/draw/BufferMultisample;)V", "quitAfterScreenshot", "getQuitAfterScreenshot", "setQuitAfterScreenshot", "resolved", "Lorg/openrndr/draw/ColorBuffer;", "scale", "", "getScale", "()D", "setScale", "(D)V", "target", "Lorg/openrndr/draw/RenderTarget;", "afterDraw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "program", "Lorg/openrndr/Program;", "beforeDraw", "setup", "openrndr-extensions"})
public class Screenshots
implements Extension {
    private boolean enabled = true;
    private double scale = 1.0;
    @NotNull
    private BufferMultisample multisample = BufferMultisample.Disabled.INSTANCE;
    private boolean quitAfterScreenshot;
    private int key = 32;
    @NotNull
    private CreateScreenshot createScreenshot = CreateScreenshot.None.INSTANCE;
    private RenderTarget target;
    private ColorBuffer resolved;

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final double getScale() {
        return this.scale;
    }

    public final void setScale(double d) {
        this.scale = d;
    }

    @NotNull
    public final BufferMultisample getMultisample() {
        return this.multisample;
    }

    public final void setMultisample(@NotNull BufferMultisample bufferMultisample) {
        Intrinsics.checkParameterIsNotNull(bufferMultisample, "<set-?>");
        this.multisample = bufferMultisample;
    }

    public final boolean getQuitAfterScreenshot() {
        return this.quitAfterScreenshot;
    }

    public final void setQuitAfterScreenshot(boolean bl) {
        this.quitAfterScreenshot = bl;
    }

    public final int getKey() {
        return this.key;
    }

    public final void setKey(int n) {
        this.key = n;
    }

    @NotNull
    public final CreateScreenshot getCreateScreenshot$openrndr_extensions() {
        return this.createScreenshot;
    }

    public final void setCreateScreenshot$openrndr_extensions(@NotNull CreateScreenshot createScreenshot) {
        Intrinsics.checkParameterIsNotNull(createScreenshot, "<set-?>");
        this.createScreenshot = createScreenshot;
    }

    @Override
    public void setup(@NotNull Program program2) {
        Intrinsics.checkParameterIsNotNull(program2, "program");
        program2.getKeyboard().getKeyDown().listen(new Function1<KeyEvent, Unit>(this, program2){
            final /* synthetic */ Screenshots this$0;
            final /* synthetic */ Program $program;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (it.getKey() == this.this$0.getKey()) {
                    this.this$0.setCreateScreenshot$openrndr_extensions(CreateScreenshot.AutoNamed.INSTANCE);
                    this.$program.getWindow().requestDraw();
                }
            }
            {
                this.this$0 = screenshots;
                this.$program = program2;
                super(1);
            }
        });
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        block6: {
            ColorBuffer colorBuffer;
            Intrinsics.checkParameterIsNotNull(drawer, "drawer");
            Intrinsics.checkParameterIsNotNull(program2, "program");
            if (!(Intrinsics.areEqual(this.createScreenshot, CreateScreenshot.None.INSTANCE) ^ true)) break block6;
            int targetWidth = (int)((double)program2.getWidth() * this.scale);
            int targetHeight = (int)((double)program2.getHeight() * this.scale);
            this.target = RenderTargetKt.renderTarget$default(targetWidth, targetHeight, 0.0, this.multisample, beforeDraw.1.INSTANCE, 4, null);
            Object object = this.multisample;
            if (Intrinsics.areEqual(object, BufferMultisample.Disabled.INSTANCE)) {
                colorBuffer = null;
            } else if (object instanceof BufferMultisample.SampleCount) {
                colorBuffer = ColorBufferKt.colorBuffer$default(targetWidth, targetHeight, 0.0, null, null, null, 60, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this.resolved = colorBuffer;
            RenderTarget renderTarget2 = this.target;
            if (renderTarget2 != null) {
                renderTarget2.bind();
            }
            ColorRGBa colorRGBa = program2.getBackgroundColor();
            if (colorRGBa != null) {
                Object it = object = colorRGBa;
                boolean bl = false;
                drawer.background((ColorRGBa)it);
            }
        }
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(program2, "program");
        afterDraw.1 z$ = afterDraw.1.INSTANCE;
        CreateScreenshot createScreenshot = this.createScreenshot;
        if (Intrinsics.areEqual(createScreenshot, CreateScreenshot.None.INSTANCE) ^ true) {
            drawer.setShadeStyle(null);
            RenderTarget renderTarget2 = this.target;
            if (renderTarget2 != null) {
                renderTarget2.unbind();
            }
            RenderTarget renderTarget3 = this.target;
            if (renderTarget3 != null) {
                String string;
                CharSequence charSequence;
                Object object;
                RenderTarget renderTarget4;
                RenderTarget it = renderTarget4 = renderTarget3;
                boolean bl = false;
                drawer.ortho();
                drawer.setView(Matrix44.Companion.getIDENTITY());
                drawer.setModel(Matrix44.Companion.getIDENTITY());
                LocalDateTime dt = LocalDateTime.now();
                CharSequence charSequence2 = program2.getClass().getSimpleName();
                if (StringsKt.isBlank(charSequence2)) {
                    CharSequence charSequence3;
                    boolean bl2 = false;
                    object = program2.getWindow().getTitle();
                    if (StringsKt.isBlank((CharSequence)object)) {
                        boolean bl3 = false;
                        charSequence3 = "untitled";
                    } else {
                        charSequence3 = object;
                    }
                    charSequence = (String)charSequence3;
                } else {
                    charSequence = charSequence2;
                }
                String basename = (String)charSequence;
                CreateScreenshot bl2 = createScreenshot;
                if (Intrinsics.areEqual(bl2, CreateScreenshot.None.INSTANCE)) {
                    throw (Throwable)new IllegalStateException("");
                }
                if (Intrinsics.areEqual(bl2, CreateScreenshot.AutoNamed.INSTANCE)) {
                    StringBuilder stringBuilder = new StringBuilder().append(basename).append('-');
                    LocalDateTime localDateTime = dt;
                    Intrinsics.checkExpressionValueIsNotNull(localDateTime, "dt");
                    StringBuilder stringBuilder2 = stringBuilder.append(afterDraw.1.INSTANCE.invoke(localDateTime.getYear(), 4)).append('-');
                    Month month = dt.getMonth();
                    Intrinsics.checkExpressionValueIsNotNull(month, "dt.month");
                    string = stringBuilder2.append(afterDraw.1.invoke$default(afterDraw.1.INSTANCE, month.getValue(), 0, 1, null)).append('-').append(afterDraw.1.invoke$default(afterDraw.1.INSTANCE, dt.getDayOfMonth(), 0, 1, null)).append('-').append(afterDraw.1.invoke$default(afterDraw.1.INSTANCE, dt.getHour(), 0, 1, null)).append('.').append(afterDraw.1.invoke$default(afterDraw.1.INSTANCE, dt.getMinute(), 0, 1, null)).append('.').append(afterDraw.1.invoke$default(afterDraw.1.INSTANCE, dt.getSecond(), 0, 1, null)).append(".png").toString();
                } else if (bl2 instanceof CreateScreenshot.Named) {
                    string = ((CreateScreenshot.Named)createScreenshot).getName();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String filename = string;
                ColorBuffer resolved2 = this.resolved;
                if (resolved2 == null) {
                    ColorBuffer.DefaultImpls.saveToFile$default(it.colorBuffer(0), new File(filename), null, 2, null);
                    drawer.image(it.colorBuffer(0), it.colorBuffer(0).getBounds(), drawer.getBounds());
                } else {
                    RenderTarget renderTarget5 = this.target;
                    if (renderTarget5 != null) {
                        Object it2 = object = renderTarget5;
                        boolean bl4 = false;
                        it2.colorBuffer(0).resolveTo(resolved2);
                        ColorBuffer.DefaultImpls.saveToFile$default(resolved2, new File(filename), null, 2, null);
                        drawer.image(resolved2, resolved2.getBounds(), drawer.getBounds());
                    }
                }
            }
            RenderTarget renderTarget6 = this.target;
            if (renderTarget6 != null) {
                renderTarget6.destroy();
            }
            ColorBuffer colorBuffer = this.resolved;
            if (colorBuffer != null) {
                colorBuffer.destroy();
            }
            this.createScreenshot = CreateScreenshot.None.INSTANCE;
            if (this.quitAfterScreenshot) {
                program2.getApplication().exit();
            }
        }
    }
}

