/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class KHRStreamFIFO {
    public static final int EGL_STREAM_FIFO_LENGTH_KHR = 12796;
    public static final int EGL_STREAM_TIME_NOW_KHR = 12797;
    public static final int EGL_STREAM_TIME_CONSUMER_KHR = 12798;
    public static final int EGL_STREAM_TIME_PRODUCER_KHR = 12799;

    protected KHRStreamFIFO() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglQueryStreamTimeKHR);
    }

    public static int neglQueryStreamTimeKHR(long dpy, long stream, int attribute, long value2) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamTimeKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(__functionAddress, dpy, stream, attribute, value2);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryStreamTimeKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLenum") int attribute, @NativeType(value="EGLTimeKHR *") LongBuffer value2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value2, 1);
        }
        return KHRStreamFIFO.neglQueryStreamTimeKHR(dpy, stream, attribute, MemoryUtil.memAddress(value2)) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryStreamTimeKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLenum") int attribute, @NativeType(value="EGLTimeKHR *") long[] value2) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamTimeKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
            Checks.check(value2, 1);
        }
        return JNI.callPPPI(__functionAddress, dpy, stream, attribute, value2) != 0;
    }
}

