/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Locale;
import org.jsoup.UncheckedIOException;
import org.jsoup.helper.Validate;

public final class CharacterReader {
    static final char EOF = '\uffff';
    private static final int maxStringCacheLen = 12;
    static final int maxBufferLen = 32768;
    private static final int readAheadLimit = 24576;
    private final char[] charBuf;
    private final Reader reader;
    private int bufLength;
    private int bufSplitPoint;
    private int bufPos;
    private int readerPos;
    private int bufMark;
    private final String[] stringCache = new String[512];

    public CharacterReader(Reader input, int sz) {
        Validate.notNull(input);
        Validate.isTrue(input.markSupported());
        this.reader = input;
        this.charBuf = new char[sz > 32768 ? 32768 : sz];
        this.bufferUp();
    }

    public CharacterReader(Reader input) {
        this(input, 32768);
    }

    public CharacterReader(String input) {
        this(new StringReader(input), input.length());
    }

    private void bufferUp() {
        if (this.bufPos < this.bufSplitPoint) {
            return;
        }
        try {
            this.reader.skip(this.bufPos);
            this.reader.mark(32768);
            int read2 = this.reader.read(this.charBuf);
            this.reader.reset();
            if (read2 != -1) {
                this.bufLength = read2;
                this.readerPos += this.bufPos;
                this.bufPos = 0;
                this.bufMark = 0;
                this.bufSplitPoint = this.bufLength > 24576 ? 24576 : this.bufLength;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int pos() {
        return this.readerPos + this.bufPos;
    }

    public boolean isEmpty() {
        this.bufferUp();
        return this.bufPos >= this.bufLength;
    }

    private boolean isEmptyNoBufferUp() {
        return this.bufPos >= this.bufLength;
    }

    public char current() {
        this.bufferUp();
        return this.isEmptyNoBufferUp() ? (char)'\uffff' : this.charBuf[this.bufPos];
    }

    char consume() {
        this.bufferUp();
        char val = this.isEmptyNoBufferUp() ? (char)'\uffff' : this.charBuf[this.bufPos];
        ++this.bufPos;
        return val;
    }

    void unconsume() {
        --this.bufPos;
    }

    public void advance() {
        ++this.bufPos;
    }

    void mark() {
        this.bufMark = this.bufPos;
    }

    void rewindToMark() {
        this.bufPos = this.bufMark;
    }

    int nextIndexOf(char c) {
        this.bufferUp();
        for (int i = this.bufPos; i < this.bufLength; ++i) {
            if (c != this.charBuf[i]) continue;
            return i - this.bufPos;
        }
        return -1;
    }

    int nextIndexOf(CharSequence seq) {
        this.bufferUp();
        char startChar = seq.charAt(0);
        for (int offset2 = this.bufPos; offset2 < this.bufLength; ++offset2) {
            if (startChar != this.charBuf[offset2]) {
                while (++offset2 < this.bufLength && startChar != this.charBuf[offset2]) {
                }
            }
            int i = offset2 + 1;
            int last2 = i + seq.length() - 1;
            if (offset2 >= this.bufLength || last2 > this.bufLength) continue;
            int j = 1;
            while (i < last2 && seq.charAt(j) == this.charBuf[i]) {
                ++i;
                ++j;
            }
            if (i != last2) continue;
            return offset2 - this.bufPos;
        }
        return -1;
    }

    public String consumeTo(char c) {
        int offset2 = this.nextIndexOf(c);
        if (offset2 != -1) {
            String consumed = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, offset2);
            this.bufPos += offset2;
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeTo(String seq) {
        int offset2 = this.nextIndexOf(seq);
        if (offset2 != -1) {
            String consumed = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, offset2);
            this.bufPos += offset2;
            return consumed;
        }
        return this.consumeToEnd();
    }

    public String consumeToAny(char ... chars) {
        this.bufferUp();
        int start = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        block0: while (this.bufPos < remaining) {
            for (char c : chars) {
                if (val[this.bufPos] == c) break block0;
            }
            ++this.bufPos;
        }
        return this.bufPos > start ? CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start) : "";
    }

    String consumeToAnySorted(char ... chars) {
        this.bufferUp();
        int start = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        while (this.bufPos < remaining && Arrays.binarySearch(chars, val[this.bufPos]) < 0) {
            ++this.bufPos;
        }
        return this.bufPos > start ? CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start) : "";
    }

    String consumeData() {
        char c;
        this.bufferUp();
        int start = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        while (this.bufPos < remaining && (c = val[this.bufPos]) != '&' && c != '<' && c != '\u0000') {
            ++this.bufPos;
        }
        return this.bufPos > start ? CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start) : "";
    }

    String consumeTagName() {
        char c;
        this.bufferUp();
        int start = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        while (this.bufPos < remaining && (c = val[this.bufPos]) != '\t' && c != '\n' && c != '\r' && c != '\f' && c != ' ' && c != '/' && c != '>' && c != '\u0000') {
            ++this.bufPos;
        }
        return this.bufPos > start ? CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start) : "";
    }

    String consumeToEnd() {
        this.bufferUp();
        String data2 = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, this.bufLength - this.bufPos);
        this.bufPos = this.bufLength;
        return data2;
    }

    String consumeLetterSequence() {
        char c;
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c))) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start);
    }

    String consumeLetterThenDigitSequence() {
        char c;
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c))) {
            ++this.bufPos;
        }
        while (!this.isEmptyNoBufferUp() && (c = this.charBuf[this.bufPos]) >= '0' && c <= '9') {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start);
    }

    String consumeHexSequence() {
        char c;
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start);
    }

    String consumeDigitSequence() {
        char c;
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength && (c = this.charBuf[this.bufPos]) >= '0' && c <= '9') {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start);
    }

    boolean matches(char c) {
        return !this.isEmpty() && this.charBuf[this.bufPos] == c;
    }

    boolean matches(String seq) {
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        for (int offset2 = 0; offset2 < scanLength; ++offset2) {
            if (seq.charAt(offset2) == this.charBuf[this.bufPos + offset2]) continue;
            return false;
        }
        return true;
    }

    boolean matchesIgnoreCase(String seq) {
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        for (int offset2 = 0; offset2 < scanLength; ++offset2) {
            char upTarget;
            char upScan = Character.toUpperCase(seq.charAt(offset2));
            if (upScan == (upTarget = Character.toUpperCase(this.charBuf[this.bufPos + offset2]))) continue;
            return false;
        }
        return true;
    }

    boolean matchesAny(char ... seq) {
        if (this.isEmpty()) {
            return false;
        }
        this.bufferUp();
        char c = this.charBuf[this.bufPos];
        for (char seek : seq) {
            if (seek != c) continue;
            return true;
        }
        return false;
    }

    boolean matchesAnySorted(char[] seq) {
        this.bufferUp();
        return !this.isEmpty() && Arrays.binarySearch(seq, this.charBuf[this.bufPos]) >= 0;
    }

    boolean matchesLetter() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c);
    }

    boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= '0' && c <= '9';
    }

    boolean matchConsume(String seq) {
        this.bufferUp();
        if (this.matches(seq)) {
            this.bufPos += seq.length();
            return true;
        }
        return false;
    }

    boolean matchConsumeIgnoreCase(String seq) {
        if (this.matchesIgnoreCase(seq)) {
            this.bufPos += seq.length();
            return true;
        }
        return false;
    }

    boolean containsIgnoreCase(String seq) {
        String loScan = seq.toLowerCase(Locale.ENGLISH);
        String hiScan = seq.toUpperCase(Locale.ENGLISH);
        return this.nextIndexOf(loScan) > -1 || this.nextIndexOf(hiScan) > -1;
    }

    public String toString() {
        return new String(this.charBuf, this.bufPos, this.bufLength - this.bufPos);
    }

    private static String cacheString(char[] charBuf, String[] stringCache, int start, int count2) {
        if (count2 > 12) {
            return new String(charBuf, start, count2);
        }
        if (count2 < 1) {
            return "";
        }
        int hash = 0;
        int offset2 = start;
        for (int i = 0; i < count2; ++i) {
            hash = 31 * hash + charBuf[offset2++];
        }
        int index = hash & stringCache.length - 1;
        String cached = stringCache[index];
        if (cached == null) {
            stringCache[index] = cached = new String(charBuf, start, count2);
        } else {
            if (CharacterReader.rangeEquals(charBuf, start, count2, cached)) {
                return cached;
            }
            stringCache[index] = cached = new String(charBuf, start, count2);
        }
        return cached;
    }

    static boolean rangeEquals(char[] charBuf, int start, int count2, String cached) {
        if (count2 == cached.length()) {
            int i = start;
            int j = 0;
            while (count2-- != 0) {
                if (charBuf[i++] == cached.charAt(j++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean rangeEquals(int start, int count2, String cached) {
        return CharacterReader.rangeEquals(this.charBuf, start, count2, cached);
    }
}

