/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import org.jetbrains.annotations.NotNull;

public final class StrictEqualityTypeChecker {
    public static final StrictEqualityTypeChecker INSTANCE;

    public final boolean strictEqualTypes(@NotNull UnwrappedType a2, @NotNull UnwrappedType b) {
        Intrinsics.checkParameterIsNotNull(a2, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        if (a2 == b) {
            return true;
        }
        if (a2 instanceof SimpleType && b instanceof SimpleType) {
            return this.strictEqualTypes((SimpleType)a2, (SimpleType)b);
        }
        if (a2 instanceof FlexibleType && b instanceof FlexibleType) {
            return this.strictEqualTypes(((FlexibleType)a2).getLowerBound(), ((FlexibleType)b).getLowerBound()) && this.strictEqualTypes(((FlexibleType)a2).getUpperBound(), ((FlexibleType)b).getUpperBound());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean strictEqualTypes(@NotNull SimpleType a2, @NotNull SimpleType b) {
        Intrinsics.checkParameterIsNotNull(a2, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        if (a2.isMarkedNullable() != b.isMarkedNullable() || SpecialTypesKt.isDefinitelyNotNullType(a2) != SpecialTypesKt.isDefinitelyNotNullType(b) || Intrinsics.areEqual(a2.getConstructor(), b.getConstructor()) ^ true || a2.getArguments().size() != b.getArguments().size()) {
            return false;
        }
        if (a2.getArguments() == b.getArguments()) {
            return true;
        }
        int n = 0;
        int n2 = ((Collection)a2.getArguments()).size();
        while (n < n2) {
            void i;
            TypeProjection aArg = a2.getArguments().get((int)i);
            TypeProjection bArg = b.getArguments().get((int)i);
            if (aArg.isStarProjection() != bArg.isStarProjection()) {
                return false;
            }
            if (!aArg.isStarProjection()) {
                if (aArg.getProjectionKind() != bArg.getProjectionKind()) {
                    return false;
                }
                if (!this.strictEqualTypes(aArg.getType().unwrap(), bArg.getType().unwrap())) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private StrictEqualityTypeChecker() {
    }

    static {
        StrictEqualityTypeChecker strictEqualityTypeChecker;
        INSTANCE = strictEqualityTypeChecker = new StrictEqualityTypeChecker();
    }
}

