/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.UtfEncodingKt;
import org.jetbrains.annotations.NotNull;

public class BitEncoding {
    private static final boolean FORCE_8TO7_ENCODING;

    private BitEncoding() {
    }

    private static void addModuloByte(@NotNull byte[] data2, int increment) {
        int n = data2.length;
        for (int i = 0; i < n; ++i) {
            data2[i] = (byte)(data2[i] + increment & 0x7F);
        }
    }

    @NotNull
    public static byte[] decodeBytes(@NotNull String[] data2) {
        if (data2.length > 0 && !data2[0].isEmpty()) {
            char possibleMarker = data2[0].charAt(0);
            if (possibleMarker == '\u0000') {
                return UtfEncodingKt.stringsToBytes(BitEncoding.dropMarker(data2));
            }
            if (possibleMarker == '\uffff') {
                data2 = BitEncoding.dropMarker(data2);
            }
        }
        byte[] bytes = BitEncoding.combineStringArrayIntoBytes(data2);
        BitEncoding.addModuloByte(bytes, 127);
        return BitEncoding.decode7to8(bytes);
    }

    @NotNull
    private static String[] dropMarker(@NotNull String[] data2) {
        String[] result2 = (String[])data2.clone();
        result2[0] = result2[0].substring(1);
        return result2;
    }

    @NotNull
    private static byte[] combineStringArrayIntoBytes(@NotNull String[] data2) {
        int resultLength = 0;
        for (String s2 : data2) {
            assert (s2.length() <= 65535) : "String is too long: " + s2.length();
            resultLength += s2.length();
        }
        byte[] result2 = new byte[resultLength];
        int p = 0;
        for (String s3 : data2) {
            int n = s3.length();
            for (int i = 0; i < n; ++i) {
                result2[p++] = (byte)s3.charAt(i);
            }
        }
        return result2;
    }

    @NotNull
    private static byte[] decode7to8(@NotNull byte[] data2) {
        int resultLength = 7 * data2.length / 8;
        byte[] result2 = new byte[resultLength];
        int byteIndex = 0;
        int bit = 0;
        for (int i = 0; i < resultLength; ++i) {
            int firstPart = (data2[byteIndex] & 0xFF) >>> bit;
            int secondPart = (data2[++byteIndex] & (1 << bit + 1) - 1) << 7 - bit;
            result2[i] = (byte)(firstPart + secondPart);
            if (bit == 6) {
                ++byteIndex;
                bit = 0;
                continue;
            }
            ++bit;
        }
        return result2;
    }

    static {
        String use8to7;
        try {
            use8to7 = System.getProperty("kotlin.jvm.serialization.use8to7");
        }
        catch (SecurityException e) {
            use8to7 = null;
        }
        FORCE_8TO7_ENCODING = "true".equals(use8to7);
    }
}

