/*
 * Decompiled with CFR 0.152.
 */
package kool.lib;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import kool.ConstructorsKt;
import kool.OperatorsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J8\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\""}, d2={"Lkool/lib/DualPivotQuicksort;", "", "()V", "COUNTING_SORT_THRESHOLD_FOR_BYTE", "", "getCOUNTING_SORT_THRESHOLD_FOR_BYTE", "()I", "COUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR", "getCOUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR", "INSERTION_SORT_THRESHOLD", "getINSERTION_SORT_THRESHOLD", "MAX_RUN_COUNT", "getMAX_RUN_COUNT", "MAX_RUN_LENGTH", "getMAX_RUN_LENGTH", "NUM_BYTE_VALUES", "getNUM_BYTE_VALUES", "QUICKSORT_THRESHOLD", "getQUICKSORT_THRESHOLD", "sort", "", "a", "Ljava/nio/ByteBuffer;", "left", "right", "a_", "Ljava/nio/IntBuffer;", "right_", "work_", "workBase_", "workLen", "left_", "leftmost", "", "build"})
public final class DualPivotQuicksort {
    private static final int MAX_RUN_COUNT = 67;
    private static final int MAX_RUN_LENGTH = 33;
    private static final int QUICKSORT_THRESHOLD = 286;
    private static final int INSERTION_SORT_THRESHOLD = 47;
    private static final int COUNTING_SORT_THRESHOLD_FOR_BYTE = 29;
    private static final int COUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR = 3200;
    private static final int NUM_BYTE_VALUES = 256;
    public static final DualPivotQuicksort INSTANCE;

    public final int getMAX_RUN_COUNT() {
        return MAX_RUN_COUNT;
    }

    public final int getMAX_RUN_LENGTH() {
        return MAX_RUN_LENGTH;
    }

    public final int getQUICKSORT_THRESHOLD() {
        return QUICKSORT_THRESHOLD;
    }

    public final int getINSERTION_SORT_THRESHOLD() {
        return INSERTION_SORT_THRESHOLD;
    }

    public final int getCOUNTING_SORT_THRESHOLD_FOR_BYTE() {
        return COUNTING_SORT_THRESHOLD_FOR_BYTE;
    }

    public final int getCOUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR() {
        return COUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR;
    }

    /*
     * WARNING - void declaration
     */
    public final void sort(@NotNull IntBuffer a_, int left, int right_, @Nullable IntBuffer work_, int workBase_, int workLen) {
        int ao;
        int bo;
        IntBuffer b;
        int blen;
        boolean odd;
        int k;
        int count2;
        int[] run2;
        int workBase;
        IntBuffer work;
        int right;
        IntBuffer a2;
        block29: {
            block28: {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull(a_, "a_");
                a2 = a_;
                right = right_;
                work = work_;
                workBase = workBase_;
                if (right - left < QUICKSORT_THRESHOLD) {
                    this.sort(a2, left, right, true);
                    return;
                }
                run2 = new int[MAX_RUN_COUNT + 1];
                count2 = 0;
                run2[0] = left;
                k = left;
                while (k < right) {
                    if (a2.get(k) < a2.get(k + 1)) {
                        while (++k <= right && a2.get(k - 1) <= a2.get(k)) {
                        }
                    } else if (a2.get(k) > a2.get(k + 1)) {
                        while (++k <= right && a2.get(k - 1) >= a2.get(k)) {
                        }
                        int lo = run2[count2] - 1;
                        int hi = k;
                        while (++lo < --hi) {
                            int t = a2.get(lo);
                            OperatorsKt.set(a2, lo, a2.get(hi));
                            OperatorsKt.set(a2, hi, t);
                        }
                    } else {
                        int m = MAX_RUN_LENGTH;
                        while (++k <= right && a2.get(k - 1) == a2.get(k)) {
                            if (--m != 0) continue;
                            this.sort(a2, left, right, true);
                            return;
                        }
                    }
                    if (++count2 == MAX_RUN_COUNT) {
                        this.sort(a2, left, right, true);
                        return;
                    }
                    run2[count2] = k;
                }
                if (run2[count2] == right++) {
                    run2[++count2] = right;
                } else if (count2 == 1) {
                    return;
                }
                odd = false;
                int n = 1;
                while (n << 1 < count2) {
                    n <<= 1;
                    odd ^= true;
                }
                blen = right - left;
                if (work == null || workLen < blen) break block28;
                Buffer buffer = work;
                int n2 = workBase + blen;
                int n3 = $receiver$iv.capacity();
                if (n2 <= n3) break block29;
            }
            work = ConstructorsKt.IntBuffer(blen);
            workBase = 0;
        }
        if (!odd) {
            int $receiver$iv = 0;
            int $i$f$getCap = blen;
            while ($receiver$iv < $i$f$getCap) {
                void i;
                OperatorsKt.set(work, workBase, a2.get(left));
                ++i;
            }
            b = a2;
            bo = 0;
            a2 = work;
            ao = workBase - left;
        } else {
            b = work;
            ao = 0;
            bo = workBase - left;
        }
        int last2 = 0;
        while (count2 > 1) {
            last2 = 0;
            for (k = last2 + 2; k <= count2; k += 2) {
                int i;
                int hi = run2[k];
                int mi = run2[k - 1];
                int p = i = run2[k - 2];
                int q = mi;
                while (i < hi) {
                    if (q >= hi || p < mi && a2.get(p + ao) <= a2.get(q + ao)) {
                        OperatorsKt.set(b, i + bo, a2.get(p++ + ao));
                    } else {
                        OperatorsKt.set(b, i + bo, a2.get(q++ + ao));
                    }
                    ++i;
                }
                run2[++last2] = hi;
            }
            if ((count2 & 1) != 0) {
                int i = right;
                int lo = run2[count2 - 1];
                while (--i >= lo) {
                    OperatorsKt.set(b, i + bo, a2.get(i + ao));
                }
                run2[++last2] = right;
            }
            IntBuffer t = a2;
            a2 = b;
            b = t;
            int o = ao;
            ao = bo;
            bo = o;
        }
        count2 = last2;
    }

    private final void sort(IntBuffer a2, int left_, int right_, boolean leftmost) {
        int t;
        int length = right_ - left_ + 1;
        int left = left_;
        int right = right_;
        if (length < INSERTION_SORT_THRESHOLD) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    int ai = a2.get(i + 1);
                    while (ai < a2.get(j)) {
                        OperatorsKt.set(a2, j + 1, a2.get(j));
                        if (j-- != left) continue;
                        break;
                    }
                    OperatorsKt.set(a2, j + 1, ai);
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a2.get(++left) >= a2.get(left - 1));
                int k = left;
                while (++left <= right) {
                    int a22;
                    int a1 = a2.get(k);
                    if (a1 < (a22 = a2.get(left))) {
                        a22 = a1;
                        a1 = a2.get(left);
                    }
                    while (a1 < a2.get(--k)) {
                        OperatorsKt.set(a2, k + 2, a2.get(k));
                    }
                    OperatorsKt.set(a2, ++k + 1, a1);
                    while (a22 < a2.get(--k)) {
                        OperatorsKt.set(a2, k + 1, a2.get(k));
                    }
                    OperatorsKt.set(a2, k + 1, a22);
                    k = ++left;
                }
                int last2 = a2.get(right);
                while (last2 < a2.get(--right)) {
                    OperatorsKt.set(a2, right + 1, a2.get(right));
                }
                OperatorsKt.set(a2, right + 1, last2);
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a2.get(e2) < a2.get(e1)) {
            t = a2.get(e2);
            OperatorsKt.set(a2, e2, a2.get(e1));
            OperatorsKt.set(a2, e1, t);
        }
        if (a2.get(e3) < a2.get(e2)) {
            t = a2.get(e3);
            OperatorsKt.set(a2, e3, a2.get(e2));
            OperatorsKt.set(a2, e2, t);
            if (t < a2.get(e1)) {
                OperatorsKt.set(a2, e2, a2.get(e1));
                OperatorsKt.set(a2, e1, t);
            }
        }
        if (a2.get(e4) < a2.get(e3)) {
            t = a2.get(e4);
            OperatorsKt.set(a2, e4, a2.get(e3));
            OperatorsKt.set(a2, e3, t);
            if (t < a2.get(e2)) {
                OperatorsKt.set(a2, e3, a2.get(e2));
                OperatorsKt.set(a2, e2, t);
                if (t < a2.get(e1)) {
                    OperatorsKt.set(a2, e2, a2.get(e1));
                    OperatorsKt.set(a2, e1, t);
                }
            }
        }
        if (a2.get(e5) < a2.get(e4)) {
            t = a2.get(e5);
            OperatorsKt.set(a2, e5, a2.get(e4));
            OperatorsKt.set(a2, e4, t);
            if (t < a2.get(e3)) {
                OperatorsKt.set(a2, e4, a2.get(e3));
                OperatorsKt.set(a2, e3, t);
                if (t < a2.get(e2)) {
                    OperatorsKt.set(a2, e3, a2.get(e2));
                    OperatorsKt.set(a2, e2, t);
                    if (t < a2.get(e1)) {
                        OperatorsKt.set(a2, e2, a2.get(e1));
                        OperatorsKt.set(a2, e1, t);
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a2.get(e1) != a2.get(e2) && a2.get(e2) != a2.get(e3) && a2.get(e3) != a2.get(e4) && a2.get(e4) != a2.get(e5)) {
            int ak;
            int pivot1 = a2.get(e2);
            int pivot2 = a2.get(e4);
            OperatorsKt.set(a2, e2, a2.get(left));
            OperatorsKt.set(a2, e4, a2.get(right));
            while (a2.get(++less) < pivot1) {
            }
            while (a2.get(--great) > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a2.get(k);
                if (ak < pivot1) {
                    OperatorsKt.set(a2, k, a2.get(less));
                    OperatorsKt.set(a2, less, ak);
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (a2.get(great) > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a2.get(great) < pivot1) {
                    OperatorsKt.set(a2, k, a2.get(less));
                    OperatorsKt.set(a2, less, a2.get(great));
                    ++less;
                } else {
                    OperatorsKt.set(a2, k, a2.get(great));
                }
                OperatorsKt.set(a2, great, ak);
                --great;
            }
            OperatorsKt.set(a2, left, a2.get(less - 1));
            OperatorsKt.set(a2, less - 1, pivot1);
            OperatorsKt.set(a2, right, a2.get(great + 1));
            OperatorsKt.set(a2, great + 1, pivot2);
            this.sort(a2, left, less - 2, leftmost);
            this.sort(a2, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a2.get(less) == pivot1) {
                    ++less;
                }
                while (a2.get(great) == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a2.get(k);
                    if (ak == pivot1) {
                        OperatorsKt.set(a2, k, a2.get(less));
                        OperatorsKt.set(a2, less, ak);
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a2.get(great) == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a2.get(great) == pivot1) {
                        OperatorsKt.set(a2, k, a2.get(less));
                        OperatorsKt.set(a2, less, pivot1);
                        ++less;
                    } else {
                        OperatorsKt.set(a2, k, a2.get(great));
                    }
                    OperatorsKt.set(a2, great, ak);
                    --great;
                }
            }
            this.sort(a2, less, great, false);
        } else {
            int pivot = a2.get(e3);
            int k = less;
            while (k <= great) {
                if (a2.get(k) == pivot) {
                    ++k;
                    continue;
                }
                int ak = a2.get(k);
                if (ak < pivot) {
                    OperatorsKt.set(a2, k, a2.get(less));
                    OperatorsKt.set(a2, less, ak);
                    ++less;
                } else {
                    while (a2.get(great) > pivot) {
                        --great;
                    }
                    if (a2.get(great) < pivot) {
                        OperatorsKt.set(a2, k, a2.get(less));
                        OperatorsKt.set(a2, less, a2.get(great));
                        ++less;
                    } else {
                        OperatorsKt.set(a2, k, pivot);
                    }
                    OperatorsKt.set(a2, great, ak);
                    --great;
                }
                ++k;
            }
            this.sort(a2, left, less - 1, leftmost);
            this.sort(a2, great + 1, right, false);
        }
    }

    public final int getNUM_BYTE_VALUES() {
        return NUM_BYTE_VALUES;
    }

    public final void sort(@NotNull ByteBuffer a2, int left, int right) {
        Intrinsics.checkParameterIsNotNull(a2, "a");
        if (right - left > COUNTING_SORT_THRESHOLD_FOR_BYTE) {
            int i;
            int[] count2 = new int[NUM_BYTE_VALUES];
            int n = left - 1;
            int n2 = right;
            if (n <= n2) {
                while (true) {
                    int n3 = a2.get(i) - -128;
                    int n4 = count2[n3];
                    count2[n3] = n4 + 1;
                    if (i == n2) break;
                    ++i;
                }
            }
            i = NUM_BYTE_VALUES;
            int k = right + 1;
            while (k > left) {
                while (count2[--i] == 0) {
                }
                byte value2 = (byte)(i + -128);
                int s2 = count2[i];
                do {
                    OperatorsKt.set(a2, --k, value2);
                } while (--s2 > 0);
            }
        } else {
            int i;
            int j = i = left;
            while (i < right) {
                byte ai = a2.get(i + 1);
                while (ai < a2.get(j)) {
                    OperatorsKt.set(a2, j + 1, a2.get(j));
                    if (j-- != left) continue;
                    break;
                }
                OperatorsKt.set(a2, j + 1, ai);
                j = ++i;
            }
        }
    }

    private DualPivotQuicksort() {
    }

    static {
        DualPivotQuicksort dualPivotQuicksort;
        INSTANCE = dualPivotQuicksort = new DualPivotQuicksort();
        MAX_RUN_COUNT = 67;
        MAX_RUN_LENGTH = 33;
        QUICKSORT_THRESHOLD = 286;
        INSERTION_SORT_THRESHOLD = 47;
        COUNTING_SORT_THRESHOLD_FOR_BYTE = 29;
        COUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR = 3200;
        NUM_BYTE_VALUES = 256;
    }
}

