/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass.utils.wav;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import jouvieje.bass.utils.FileIOUtils;
import jouvieje.bass.utils.wav.RiffChunk;

public class FmtChunk {
    public static final int SIZEOF_FMT_CHUNK = 24;
    private final RiffChunk chunk;
    private final short wFormatTag;
    private final short nChannels;
    private final int nSamplesPerSec;
    private final int nAvgBytesPerSec;
    private final short nBlockAlign;
    private final short wBitsPerSample;

    public FmtChunk(RiffChunk chunk, short wFormatTag, short nChannels, int nSamplesPerSec, int nAvgBytesPerSec, short nBlockAlign, short wBitsPerSample) {
        this.chunk = chunk;
        this.wFormatTag = wFormatTag;
        this.nChannels = nChannels;
        this.nSamplesPerSec = nSamplesPerSec;
        this.nAvgBytesPerSec = nAvgBytesPerSec;
        this.nBlockAlign = nBlockAlign;
        this.wBitsPerSample = wBitsPerSample;
    }

    public RiffChunk getChunk() {
        return this.chunk;
    }

    public int getNAvgBytesPerSec() {
        return this.nAvgBytesPerSec;
    }

    public short getNBlockAlign() {
        return this.nBlockAlign;
    }

    public short getNChannels() {
        return this.nChannels;
    }

    public int getNSamplesPerSec() {
        return this.nSamplesPerSec;
    }

    public short getWBitsPerSample() {
        return this.wBitsPerSample;
    }

    public short getWFormatTag() {
        return this.wFormatTag;
    }

    public void write(RandomAccessFile file, FileIOUtils io) throws IOException {
        this.chunk.write(file, io);
        io.writeShort(file, this.wFormatTag);
        io.writeShort(file, this.nChannels);
        io.writeInt(file, this.nSamplesPerSec);
        io.writeInt(file, this.nAvgBytesPerSec);
        io.writeShort(file, this.nBlockAlign);
        io.writeShort(file, this.wBitsPerSample);
    }

    public void put(ByteBuffer buffer) {
        this.chunk.put(buffer);
        buffer.putShort(this.wFormatTag);
        buffer.putShort(this.nChannels);
        buffer.putInt(this.nSamplesPerSec);
        buffer.putInt(this.nAvgBytesPerSec);
        buffer.putShort(this.nBlockAlign);
        buffer.putShort(this.wBitsPerSample);
    }
}

