/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass;

import jouvieje.bass.exceptions.BassException;
import org.jouvieje.libloader.LibLoader;
import org.jouvieje.libloader.LibraryConfig;
import org.jouvieje.libloader.PlatformLibrary;

public class BassInit {
    public static boolean DEBUG = false;
    protected static boolean librariesLoaded = false;
    protected static boolean[] pluginsLoaded = new boolean[12];

    private BassInit() {
    }

    public static void loadLibraries() throws BassException {
        String[] libs = new String[]{"bass", "NativeBass"};
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] libLoaderFirst = blArray;
        LibLoader.DEBUG = DEBUG;
        int i = 0;
        while (i < libs.length) {
            String libName = libs[i];
            boolean libLoader = libLoaderFirst[i];
            String x64 = i == 1 ? "64" : "";
            String macLib = i == 0 ? ".dylib" : ".jnilib";
            LibraryConfig libConfig = new LibraryConfig();
            libConfig.windowsLibraries = new PlatformLibrary(libName, String.valueOf(libName) + ".dll");
            libConfig.windows64Libraries = new PlatformLibrary(String.valueOf(libName) + x64, String.valueOf(libName) + x64 + ".dll");
            libConfig.linuxLibraries = new PlatformLibrary(libName, "lib" + libName + ".so");
            libConfig.linux64Libraries = new PlatformLibrary(String.valueOf(libName) + x64, "lib" + libName + x64 + ".so");
            libConfig.macLibraries = new PlatformLibrary(libName, "lib" + libName + macLib);
            if (!LibLoader.loadLibrary(libConfig, libLoader)) {
                throw new BassException("no " + libName + " in java.library.path or org.lwjgl.librarypath");
            }
            BassInit.printlnDebug(String.valueOf(libName) + " successfully loaded");
            ++i;
        }
        if (!BassInit.attachJavaVM()) {
            throw new BassException("JVM not attached");
        }
        String[] libsOpt = new String[]{"bass_aac", "bass_ac3", "bass_alac", "bass_fx", "bass_mpc", "bass_spx", "bassenc", "bassflac", "bassmidi", "bassmix", "basswv"};
        int i2 = 0;
        while (i2 < libsOpt.length) {
            boolean loaded;
            String libName = libsOpt[i2];
            LibraryConfig libConfig = new LibraryConfig();
            libConfig.windowsLibraries = new PlatformLibrary(libName, String.valueOf(libName) + ".dll");
            libConfig.windows64Libraries = new PlatformLibrary(libName, String.valueOf(libName) + ".dll");
            libConfig.linuxLibraries = new PlatformLibrary(libName, "lib" + libName + ".so");
            libConfig.linux64Libraries = new PlatformLibrary(libName, "lib" + libName + ".so");
            libConfig.macLibraries = new PlatformLibrary(libName, "lib" + libName + ".dylib");
            BassInit.pluginsLoaded[i2] = loaded = LibLoader.loadLibrary(libConfig, true);
            if (!loaded) {
                BassInit.printlnDebug(String.valueOf(libName) + " not loaded");
            } else {
                BassInit.printlnDebug(String.valueOf(libName) + " successfully loaded");
            }
            ++i2;
        }
        librariesLoaded = true;
    }

    protected static final int get_NATIVEBASS_JAR_VERSION() {
        return 65793;
    }

    protected static final native boolean attachJavaVM();

    protected static final native int get_BASSVERSION();

    protected static final native int get_NATIVEBASS_VERSION();

    public static final int BASSVERSION() {
        BassInit.checkInit();
        return BassInit.get_BASSVERSION();
    }

    public static final int NATIVEBASS_JAR_VERSION() {
        BassInit.checkInit();
        return BassInit.get_NATIVEBASS_JAR_VERSION();
    }

    public static final int NATIVEBASS_LIBRARY_VERSION() {
        BassInit.checkInit();
        return BassInit.get_NATIVEBASS_VERSION();
    }

    public static final boolean isLibrariesLoaded() {
        return librariesLoaded;
    }

    private static final void checkInit() {
        if (!BassInit.isLibrariesLoaded()) {
            throw new RuntimeException("Libraries not loaded, use Init.loadLibraries().");
        }
    }

    public static final boolean isPluginAacLoaded() {
        return pluginsLoaded[0];
    }

    public static final boolean isPluginAc3Loaded() {
        return pluginsLoaded[1];
    }

    public static final boolean isPluginAlacLoaded() {
        return pluginsLoaded[2];
    }

    public static final boolean isPluginFxLoaded() {
        return pluginsLoaded[3];
    }

    public static final boolean isPluginMpcLoaded() {
        return pluginsLoaded[4];
    }

    public static final boolean isPluginSpxLoaded() {
        return pluginsLoaded[5];
    }

    public static final boolean isPluginEncLoaded() {
        return pluginsLoaded[6];
    }

    public static final boolean isPluginFlacLoaded() {
        return pluginsLoaded[7];
    }

    public static final boolean isPluginMidiLoaded() {
        return pluginsLoaded[8];
    }

    public static final boolean isPluginMixLoaded() {
        return pluginsLoaded[9];
    }

    public static final boolean isPluginWvLoaded() {
        return pluginsLoaded[10];
    }

    private static void printlnDebug(String s2) {
        if (DEBUG) {
            System.out.println(s2);
        }
    }
}

