/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.utils;

import io.lacuna.bifurcan.utils.CharSequences;
import java.nio.charset.Charset;
import java.util.PrimitiveIterator;

public class UnicodeChunk {
    private static final Charset UTF8 = Charset.forName("utf-8");
    public static final byte[] EMPTY = new byte[]{0, 0};
    public static final byte[] LENGTHS = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};

    public static byte[] from(CharSequence cs) {
        return UnicodeChunk.from(cs, 0, cs.length());
    }

    public static byte[] from(CharSequence cs, int start, int end2) {
        if (end2 - start > 255) {
            throw new IllegalArgumentException("cannot encode a block of more than 255 UTF-16 code units");
        }
        int numBytes = 0;
        int numCodePoints = 0;
        int charIdx = start;
        while (charIdx < end2) {
            char c = cs.charAt(charIdx);
            if (Character.isHighSurrogate(c)) {
                numBytes += 4;
                charIdx += 2;
            } else {
                numBytes += UnicodeChunk.encodedLength(c & 0xFFFF);
                ++charIdx;
            }
            ++numCodePoints;
        }
        byte[] chunk = new byte[numBytes + 2];
        chunk[0] = (byte)numCodePoints;
        chunk[1] = (byte)(end2 - start);
        int charIdx2 = start;
        int offset2 = 2;
        while (charIdx2 < end2) {
            int codePoint;
            char c = cs.charAt(charIdx2);
            if (Character.isHighSurrogate(c)) {
                codePoint = Character.toCodePoint(c, cs.charAt(charIdx2 + 1));
                charIdx2 += 2;
            } else {
                codePoint = c & 0xFFFF;
                ++charIdx2;
            }
            numBytes += UnicodeChunk.encodedLength(codePoint);
            offset2 += UnicodeChunk.overwrite(chunk, offset2, codePoint);
        }
        return chunk;
    }

    public static CharSequence toCharSequence(final byte[] chunk) {
        return new CharSequence(){

            @Override
            public int length() {
                return UnicodeChunk.numCodeUnits(chunk);
            }

            @Override
            public char charAt(int index) {
                return UnicodeChunk.nthUnit(chunk, index);
            }

            @Override
            public CharSequence subSequence(int start, int end2) {
                return CharSequences.subSequence(this, start, end2);
            }

            @Override
            public String toString() {
                return UnicodeChunk.toString(chunk);
            }
        };
    }

    public static String toString(byte[] chunk) {
        char[] cs = new char[UnicodeChunk.numCodeUnits(chunk)];
        int bi = 2;
        int ci = 0;
        while (ci < cs.length) {
            int codePoint;
            bi += (codePoint = UnicodeChunk.decode(chunk, bi)) < 128 ? 1 : UnicodeChunk.prefixLength(chunk[bi]);
            if (Character.isBmpCodePoint(codePoint)) {
                cs[ci++] = (char)codePoint;
                continue;
            }
            cs[ci++] = Character.highSurrogate(codePoint);
            cs[ci++] = Character.lowSurrogate(codePoint);
        }
        return new String(cs);
    }

    public static byte[] concat(byte[] a2, byte[] b) {
        if (UnicodeChunk.numCodeUnits(a2) + UnicodeChunk.numCodeUnits(b) > 255) {
            throw new IllegalArgumentException("cannot create a chunk larger than 255 UTF-16 code units");
        }
        byte[] newChunk = new byte[a2.length + b.length - 2];
        System.arraycopy(a2, 2, newChunk, 2, a2.length - 2);
        System.arraycopy(b, 2, newChunk, a2.length, b.length - 2);
        newChunk[0] = (byte)(UnicodeChunk.numCodePoints(a2) + UnicodeChunk.numCodePoints(b));
        newChunk[1] = (byte)(UnicodeChunk.numCodeUnits(a2) + UnicodeChunk.numCodeUnits(b));
        return newChunk;
    }

    public static byte[] insert(byte[] a2, byte[] b, int idx) {
        if (UnicodeChunk.numCodeUnits(a2) + UnicodeChunk.numCodeUnits(b) > 255) {
            throw new IllegalArgumentException("cannot create a chunk larger than 255 UTF-16 code units");
        }
        int offset2 = UnicodeChunk.offset(a2, idx);
        byte[] newChunk = new byte[a2.length + b.length - 2];
        System.arraycopy(a2, 2, newChunk, 2, offset2 - 2);
        System.arraycopy(b, 2, newChunk, offset2, b.length - 2);
        System.arraycopy(a2, offset2, newChunk, offset2 + b.length - 2, a2.length - offset2);
        newChunk[0] = (byte)(UnicodeChunk.numCodePoints(a2) + UnicodeChunk.numCodePoints(b));
        newChunk[1] = (byte)(UnicodeChunk.numCodeUnits(a2) + UnicodeChunk.numCodeUnits(b));
        return newChunk;
    }

    public static byte[] slice(byte[] chunk, int start, int end2) {
        int endOffset;
        int startOffset;
        if (start == end2) {
            return EMPTY;
        }
        if (start == 0 && end2 == UnicodeChunk.numCodePoints(chunk)) {
            return chunk;
        }
        int codeUnits = 0;
        if (UnicodeChunk.isAscii(chunk)) {
            startOffset = start + 2;
            endOffset = end2 + 2;
            codeUnits = end2 - start;
        } else {
            endOffset = startOffset = UnicodeChunk.offset(chunk, start);
            for (int i = start; i < end2; ++i) {
                byte b = chunk[endOffset];
                int len = b >= 0 ? 1 : UnicodeChunk.prefixLength(b);
                codeUnits += len == 4 ? 2 : 1;
                endOffset += len;
            }
        }
        byte[] newChunk = new byte[endOffset - startOffset + 2];
        System.arraycopy(chunk, startOffset, newChunk, 2, newChunk.length - 2);
        newChunk[0] = (byte)(end2 - start);
        newChunk[1] = (byte)codeUnits;
        return newChunk;
    }

    public static char nthUnit(byte[] chunk, int idx) {
        if (UnicodeChunk.isAscii(chunk)) {
            return (char)chunk[idx + 2];
        }
        return UnicodeChunk.findNthUnit(chunk, idx);
    }

    public static int nthPoint(byte[] chunk, int idx) {
        return UnicodeChunk.decode(chunk, UnicodeChunk.offset(chunk, idx));
    }

    public static int numCodePoints(byte[] chunk) {
        return chunk[0] & 0xFF;
    }

    public static int numCodeUnits(byte[] chunk) {
        return chunk[1] & 0xFF;
    }

    public static PrimitiveIterator.OfInt codePointIterator(final byte[] chunk) {
        return new PrimitiveIterator.OfInt(){
            private int idx = 2;

            @Override
            public int nextInt() {
                int codePoint = UnicodeChunk.decode(chunk, this.idx);
                this.idx += UnicodeChunk.prefixLength(chunk[this.idx]);
                return codePoint;
            }

            @Override
            public boolean hasNext() {
                return this.idx < chunk.length;
            }
        };
    }

    public static PrimitiveIterator.OfInt reverseCodePointIterator(final byte[] chunk) {
        return new PrimitiveIterator.OfInt(){
            int idx;
            {
                this.idx = chunk.length;
            }

            @Override
            public int nextInt() {
                while ((chunk[this.idx] & 0xC0) == 128) {
                    --this.idx;
                }
                int codePoint = UnicodeChunk.decode(chunk, this.idx);
                --this.idx;
                return codePoint;
            }

            @Override
            public boolean hasNext() {
                return this.idx > 2;
            }
        };
    }

    public static PrimitiveIterator.OfInt codeUnitIterator(final byte[] chunk) {
        return new PrimitiveIterator.OfInt(){
            PrimitiveIterator.OfInt it;
            short low;
            {
                this.it = UnicodeChunk.codePointIterator(chunk);
                this.low = (short)-1;
            }

            @Override
            public int nextInt() {
                if (this.low == -1) {
                    int codePoint = this.it.nextInt();
                    if (codePoint < 65536) {
                        return codePoint;
                    }
                    this.low = (short)Character.lowSurrogate(codePoint);
                    return Character.highSurrogate(codePoint);
                }
                short val = this.low;
                this.low = (short)-1;
                return val;
            }

            @Override
            public boolean hasNext() {
                return this.low != -1 || this.it.hasNext();
            }
        };
    }

    public static PrimitiveIterator.OfInt reverseCodeUnitIterator(final byte[] chunk) {
        return new PrimitiveIterator.OfInt(){
            PrimitiveIterator.OfInt it;
            short high;
            {
                this.it = UnicodeChunk.codePointIterator(chunk);
                this.high = (short)-1;
            }

            @Override
            public int nextInt() {
                if (this.high == -1) {
                    int codePoint = this.it.nextInt();
                    if (codePoint < 65536) {
                        return codePoint;
                    }
                    this.high = (short)Character.highSurrogate(codePoint);
                    return Character.lowSurrogate(codePoint);
                }
                short val = this.high;
                this.high = (short)-1;
                return val;
            }

            @Override
            public boolean hasNext() {
                return this.high != -1 || this.it.hasNext();
            }
        };
    }

    public static int writeCodeUnits(char[] array, int offset2, byte[] chunk) {
        int aryIdx = offset2;
        int chunkIdx = 2;
        while (chunkIdx < chunk.length) {
            byte b = chunk[chunkIdx];
            if (b >= 0) {
                array[aryIdx++] = (char)b;
                ++chunkIdx;
                continue;
            }
            int codePoint = UnicodeChunk.decode(chunk, chunkIdx);
            chunkIdx += UnicodeChunk.encodedLength(codePoint);
            if (Character.isBmpCodePoint(codePoint)) {
                array[aryIdx++] = (char)codePoint;
                continue;
            }
            array[aryIdx++] = Character.highSurrogate(codePoint);
            array[aryIdx++] = Character.lowSurrogate(codePoint);
        }
        return UnicodeChunk.numCodeUnits(chunk);
    }

    public static int writeCodePoints(int[] array, int offset2, byte[] chunk) {
        int codePoint;
        int aryIdx = offset2;
        for (int chunkIdx = 2; chunkIdx < chunk.length; chunkIdx += UnicodeChunk.encodedLength(codePoint)) {
            codePoint = UnicodeChunk.decode(chunk, chunkIdx);
            array[aryIdx++] = codePoint;
        }
        return UnicodeChunk.numCodePoints(chunk);
    }

    private static char findNthUnit(byte[] chunk, int idx) {
        int offset2 = 2;
        while (true) {
            if (idx == 0) {
                int point = UnicodeChunk.decode(chunk, offset2);
                return Character.isBmpCodePoint(point) ? (char)point : Character.highSurrogate(point);
            }
            byte b = chunk[offset2];
            if (b >= 0) {
                --idx;
                ++offset2;
                continue;
            }
            int len = UnicodeChunk.prefixLength(b);
            int codeUnits = 1 << (len >> 2);
            if ((idx -= codeUnits) < 0) {
                return Character.lowSurrogate(UnicodeChunk.decode(chunk, offset2));
            }
            offset2 += len;
        }
    }

    private static int offset(byte[] chunk, int idx) {
        if (UnicodeChunk.isAscii(chunk)) {
            return idx + 2;
        }
        return UnicodeChunk.findNthPoint(chunk, idx);
    }

    private static int findNthPoint(byte[] chunk, int idx) {
        int offset2 = 2;
        while (idx-- > 0) {
            byte b = chunk[offset2];
            if (b >= 0) {
                ++offset2;
                continue;
            }
            offset2 += UnicodeChunk.prefixLength(b);
        }
        return offset2;
    }

    private static boolean isAscii(byte[] chunk) {
        return (chunk[0] & 0xFF) == chunk.length - 2;
    }

    private static int encodedLength(int codePoint) {
        if (codePoint < 128) {
            return 1;
        }
        if (codePoint < 2048) {
            return 2;
        }
        if (codePoint < 65536) {
            return 3;
        }
        return 4;
    }

    private static int overwrite(byte[] chunk, int offset2, int codePoint) {
        if (codePoint < 128) {
            chunk[offset2] = (byte)codePoint;
            return 1;
        }
        return UnicodeChunk.overwriteMultibyte(chunk, offset2, codePoint);
    }

    private static int overwriteMultibyte(byte[] chunk, int offset2, int codePoint) {
        int mask;
        int length;
        if (codePoint < 2048) {
            length = 2;
            mask = 192;
        } else if (codePoint < 65536) {
            length = 3;
            mask = 224;
        } else {
            length = 4;
            mask = 240;
        }
        for (int i = offset2 + length - 1; i > offset2; --i) {
            chunk[i] = (byte)(codePoint & 0x3F | 0x80);
            codePoint >>= 6;
        }
        chunk[offset2] = (byte)(codePoint | mask);
        return length;
    }

    public static int prefixLength(byte prefix) {
        return LENGTHS[(prefix & 0xFF) >> 3];
    }

    private static int decode(byte[] array, int offset2) {
        byte b = array[offset2];
        if (b >= 0) {
            return b;
        }
        int len = UnicodeChunk.prefixLength(b);
        int codePoint = b & (1 << 7 - len) - 1;
        for (int i = offset2 + 1; i < offset2 + len; ++i) {
            codePoint = codePoint << 6 | array[i] & 0x3F;
        }
        return codePoint;
    }
}

